/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.nocallbacklistener;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.nocallbacklistener.NoCallBackListener;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final Long ID = 1L;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"orm.xml"};
        String[] classes = new String[]{pkgName + "NoCallBackListener"};
        return this.createDeploymentJar("jpa_core_override_nocallbacklistener.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void testNoCallBackListener() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CallBackCounts.clearCountsMap();
        NoCallBackListener entity = new NoCallBackListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        logger.log(System.Logger.Level.TRACE, "persisted entity" + entity);
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        NoCallBackListener newEntity = null;
        List result = this.getEntityManager().createQuery("SELECT n FROM NoCallBackListener n").getResultList();
        if (result != null && result.size() > 0) {
            newEntity = (NoCallBackListener)result.get(0);
            if (newEntity.getId() == 1L) {
                logger.log(System.Logger.Level.TRACE, "Retrieved persisted entity");
            }
            this.getEntityManager().remove((Object)entity);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            try {
                pass1 = this.checkPersistCallBacks();
                logger.log(System.Logger.Level.TRACE, "pass1 = " + pass1);
                pass2 = this.checkRemoveCallBacks();
                logger.log(System.Logger.Level.TRACE, "pass2 = " + pass2);
                pass3 = this.checkLoadCallBacks();
                logger.log(System.Logger.Level.TRACE, "pass3 = " + pass3);
                if (!(pass1 && pass2 && pass3)) {
                    throw new Exception("Test failed while testing prePersist, postPersist, preremove and postremove methods and also the post Load method");
                }
                logger.log(System.Logger.Level.TRACE, "testOverrideCallBackMethods Passed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoCallBackListener" + e);
            }
        } else {
            throw new Exception("getResultList returned a null list");
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws Exception {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            return true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        boolean pass = false;
        int count = CallBackCounts.getCount(callBackName);
        if (count == expectedCount) {
            logger.log(System.Logger.Level.TRACE, "test passed in test method" + callBackName);
            pass = true;
        } else {
            logger.log(System.Logger.Level.TRACE, "test not passed as the count and the expected count are not same" + callBackName);
        }
        return pass;
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

