/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.managedtype;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.A;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.B;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Project;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Department;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Order;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMPerson;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject;
import ee.jakarta.tck.persistence.core.metamodelapi.managedtype.ZipCode;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Set;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "Address", pkgName + "B", pkgName + "BiDirMX1Person", pkgName + "BiDirMX1Project", pkgName + "Department", pkgName + "Employee", pkgName + "Order", pkgName + "Uni1XMPerson", pkgName + "Uni1XMProject", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_metamodelapi_managedtype.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void managedtype() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("managedtype failed");
        }
    }

    @Test
    public void getAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("total");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set attribSet = mTypeOrder.getAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                logger.log(System.Logger.Level.TRACE, "Received expected:" + attrib.getName());
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getAttributes failed");
        }
    }

    @Test
    public void getDeclaredAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("total");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set attribSet = mTypeOrder.getDeclaredAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                logger.log(System.Logger.Level.TRACE, "Received expected:" + attrib.getName());
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredAttributes failed");
        }
    }

    @Test
    public void getSingularAttributeStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getSingularAttribute("address", Address.class);
                    Class addrClass = singAttrib.getType().getJavaType();
                    if (addrClass.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        logger.log(System.Logger.Level.TRACE, "address class getName =" + addrClass.getName());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + addrClass.getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassTest failed");
        }
    }

    @Test
    public void getSingularAttributeStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mTypeB.getSingularAttribute("doesnotexist", Address.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mTypeB.getSingularAttribute("addreess", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getSingularAttributeStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getSingularAttribute("address");
                    logger.log(System.Logger.Level.TRACE, "singAttrib Type = " + singAttrib.getType());
                    logger.log(System.Logger.Level.TRACE, "singAttrib Java Type = " + singAttrib.getJavaType());
                    if (singAttrib.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: address, actual:" + singAttrib.getJavaType().getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringTest failed");
        }
    }

    @Test
    public void getSingularAttributeStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mTypeB.getSingularAttribute("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSingularAttributeStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address", Address.class);
                    Class addrClass = singAttrib.getType().getJavaType();
                    if (addrClass.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        logger.log(System.Logger.Level.TRACE, "address class getName =" + addrClass.getName());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + addrClass.getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassTest failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mTypeB.getDeclaredSingularAttribute("doesnotexist", Address.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mTypeB.getDeclaredSingularAttribute("address", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SingularAttribute singAttrib = mTypeB.getDeclaredSingularAttribute("address");
                    logger.log(System.Logger.Level.TRACE, "singAttrib Type = " + singAttrib.getType());
                    logger.log(System.Logger.Level.TRACE, "singAttrib Java Type = " + singAttrib.getJavaType());
                    if (singAttrib.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + singAttrib.getJavaType().getName());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringTest failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributeStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    try {
                        mTypeB.getDeclaredSingularAttribute("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributeStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredSingularAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("address");
        expected.add("name");
        expected.add("value");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set attribSet = mTypeB.getDeclaredSingularAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                logger.log(System.Logger.Level.TRACE, "Received expected:" + attrib.getName());
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getDeclaredSingularAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredSingularAttributes failed");
        }
    }

    @Test
    public void getSingularAttributes() throws Exception {
        boolean pass = true;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        expected.add("address");
        expected.add("name");
        expected.add("value");
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeB = metaModel.managedType(B.class);
                if (mTypeB != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set attribSet = mTypeB.getSingularAttributes();
                    if (attribSet != null) {
                        if (attribSet.size() != expected.size()) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Received wrong number of results");
                        }
                        for (Attribute attrib : attribSet) {
                            logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                            if (expected.contains(attrib.getName())) {
                                logger.log(System.Logger.Level.TRACE, "Received expected:" + attrib.getName());
                                continue;
                            }
                            logger.log(System.Logger.Level.ERROR, "Received unexpected result" + attrib.getName());
                            pass = false;
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getSingularAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSingularAttributes failed");
        }
    }

    @Test
    public void getCollectionStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getCollection("projects");
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject");
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringTest failed");
        }
    }

    @Test
    public void getCollectionStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getCollection("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getCollectionStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getCollection("projects", Uni1XMProject.class);
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            logger.log(System.Logger.Level.TRACE, "Received expected ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject");
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringClassTest failed");
        }
    }

    @Test
    public void getCollectionStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getCollection("doesnotexist", Uni1XMProject.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("projects", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCollectionStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getSetStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getSet("address", Address.class);
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSetStringClassTest failed");
        }
    }

    @Test
    public void getSetStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getSet("doesnotexist", Address.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("address", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getSetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getSetStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getSet("address");
                    Type t = setAttrib.getElementType();
                    logger.log(System.Logger.Level.TRACE, "element Type  = " + setAttrib.getElementType());
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "java Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSetStringTest failed");
        }
    }

    @Test
    public void getSetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getSet("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getSetStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getListStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getListStringClassTest failed");
        }
    }

    @Test
    public void getListStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getList("doesnotexist", BiDirMX1Person.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("biDirMX1Persons", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getListStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getListStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getListStringTest failed");
        }
    }

    @Test
    public void getListStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getList("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getListStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getMapStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getMap("lastNameEmployees", String.class, Employee.class);
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getMapStringClassTest failed");
        }
    }

    @Test
    public void getMapStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getMap("doesnotexist", String.class, Employee.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getMap("lastNameEmployees", String.class, Client.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getMapStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getMapStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getMap("lastNameEmployees");
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getMapStringTest failed");
        }
    }

    @Test
    public void getMapStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getMap("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getMapStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getDeclaredCollection("projects", Uni1XMProject.class);
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        String type = t.getJavaType().getName();
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + type);
                        if (type.equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + type);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassTest failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredCollection("doesnotexist", Uni1XMProject.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("projects", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    CollectionAttribute colAttrib = mType.getDeclaredCollection("projects");
                    Type t = colAttrib.getElementType();
                    if (t != null) {
                        String type = t.getJavaType().getName();
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + type);
                        if (type.equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Uni1XMProject, actual:" + type);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringTest failed");
        }
    }

    @Test
    public void getDeclaredCollectionStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredCollection("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredCollectionStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredSetStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getDeclaredSet("address", Address.class);
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassTest failed");
        }
    }

    @Test
    public void getDeclaredSetStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredSet("doesnotexist", Address.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("address", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredSetStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    SetAttribute setAttrib = mType.getDeclaredSet("address");
                    logger.log(System.Logger.Level.TRACE, "element Type  = " + setAttrib.getElementType());
                    Type t = setAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Address, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringTest failed");
        }
    }

    @Test
    public void getDeclaredSetStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(A.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredSet("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredSetStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredListStringClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons", BiDirMX1Person.class);
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringClassTest failed");
        }
    }

    @Test
    public void getDeclaredListStringClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredList("doesnotexist", BiDirMX1Person.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getCollection("biDirMX1Persons", ZipCode.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredListStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    ListAttribute listAttrib = mType.getDeclaredList("biDirMX1Persons");
                    Type t = listAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.BiDirMX1Person, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringTest failed");
        }
    }

    @Test
    public void getDeclaredListStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(BiDirMX1Project.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredList("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredListStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClassTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees", String.class, Employee.class);
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassTest failed");
        }
    }

    @Test
    public void getDeclaredMapStringClassClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredMap("doesnotexist", String.class, Employee.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                    logger.log(System.Logger.Level.INFO, "Testing invalid type");
                    try {
                        mType.getDeclaredMap("lastNameEmployees", String.class, Client.class);
                        pass = false;
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                    }
                    catch (Exception e) {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringClassClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getDeclaredMapStringTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    MapAttribute mapAttrib = mType.getDeclaredMap("lastNameEmployees");
                    Type t = mapAttrib.getElementType();
                    if (t != null) {
                        logger.log(System.Logger.Level.TRACE, "element Type  = " + t.getJavaType());
                        if (t.getJavaType().getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: ee.jakarta.tck.persistence.core.metamodelapi.managedtype.Employee, actual:" + t.getJavaType().getName());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getElementType() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringTest failed");
        }
    }

    @Test
    public void getDeclaredMapStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Department.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.INFO, "Testing invalid name");
                    try {
                        mType.getDeclaredMap("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredMapStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getPluralAttributes() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set pluralAttribSet = mType.getPluralAttributes();
                    if (pluralAttribSet != null) {
                        if (pluralAttribSet.size() != 1) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected size:1, actual:" + pluralAttribSet.size());
                        }
                        for (Attribute attrib : pluralAttribSet) {
                            if (attrib.getName().equals("projects")) {
                                logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                                continue;
                            }
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected: projects, actual:" + attrib.getName());
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getPluralAttributes failed");
        }
    }

    @Test
    public void getDeclaredPluralAttributes() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mType = metaModel.managedType(Uni1XMPerson.class);
                if (mType != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Set pluralAttribSet = mType.getDeclaredPluralAttributes();
                    if (pluralAttribSet != null) {
                        if (pluralAttribSet.size() != 1) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected size:1, actual:" + pluralAttribSet.size());
                        }
                        for (Attribute attrib : pluralAttribSet) {
                            if (attrib.getName().equals("projects")) {
                                logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                                continue;
                            }
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected: projects, actual:" + attrib.getName());
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getPluralAttributes() returned null");
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getDeclaredPluralAttributes failed");
        }
    }

    @Test
    public void getAttribute() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Attribute attrib = mTypeOrder.getAttribute("total");
                    if (attrib != null) {
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + attrib.getName());
                        logger.log(System.Logger.Level.TRACE, "attribute Java Type =" + attrib.getJavaType());
                        String name = attrib.getName();
                        String type = attrib.getJavaType().getSimpleName();
                        if (name.equals("total") && type.equals("int")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get either:");
                            logger.log(System.Logger.Level.ERROR, "Expected name:total, actual:" + name);
                            logger.log(System.Logger.Level.ERROR, "Expected type:int, actual:" + type);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getAttribute return null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getAttribute failed");
        }
    }

    @Test
    public void getAttributeIllegalArgumentException() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    try {
                        mTypeOrder.getAttribute("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getAttributeIllegalArgumentException failed");
        }
    }

    @Test
    public void getDeclaredAttribute() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    Attribute attrib = mTypeOrder.getDeclaredAttribute("total");
                    if (attrib != null) {
                        String name = attrib.getName();
                        String type = attrib.getJavaType().getSimpleName();
                        logger.log(System.Logger.Level.TRACE, "attribute Name = " + name);
                        logger.log(System.Logger.Level.TRACE, "attribute Java Type =" + type);
                        if (name.equals("total") && type.equals("int")) {
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected: total/int, actual:" + name + "/" + type);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "getDeclaredAttribute() returned null");
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredAttribute failed");
        }
    }

    @Test
    public void getDeclaredAttributeIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Metamodel metaModel = this.getEntityManager().getMetamodel();
            if (metaModel != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
                ManagedType mTypeOrder = metaModel.managedType(Order.class);
                if (mTypeOrder != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                    try {
                        mTypeOrder.getDeclaredAttribute("doesnotexist");
                        logger.log(System.Logger.Level.TRACE, "Did not receive IllegalArgumentException");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                        pass = true;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "managedType() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getDeclaredAttributeIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getPersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Type.PersistenceType type = mTypeOrder.getPersistenceType();
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null ManagedType");
                if (type.equals((Object)Type.PersistenceType.ENTITY)) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Persistence type = " + type.name());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType Test  failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

