/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.lock.entitymanager;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.lock.entitymanager.Coffee;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.Timeout;
import java.util.HashMap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Coffee"};
        return this.createDeploymentJar("jpa_core_lock_entitymanager.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "Create Test data");
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void findTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            if (coffeeFound != null) {
                logger.log(System.Logger.Level.TRACE, "Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("findTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin findTest2");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ, myMap);
            if (coffeeFound != null) {
                logger.log(System.Logger.Level.TRACE, "Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("findTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin findTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em2 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("findTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void findTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1, myMap);
            if (coffeeFound != null) {
                logger.log(System.Logger.Level.TRACE, "Found coffee as expected");
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("findTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lockTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin lockTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lockTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin lockTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE, myMap);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void lockTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin lockTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            LockOption[] lockOptions = new LockOption[]{Timeout.ms((int)0)};
            this.getEntityManager().lock((Object)coffeeFound, LockModeType.PESSIMISTIC_WRITE, lockOptions);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().lock((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("lockTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTest1() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager  and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)1);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin refreshTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager em1 and lock");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, LockModeType.PESSIMISTIC_READ, myMap);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, LockModeType.PESSIMISTIC_WRITE, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin refreshTest3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager");
            Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            HashMap<String, String> myMap = new HashMap<String, String>();
            myMap.put("some.cts.specific.property", "nothing.in.particular");
            this.getEntityManager().refresh((Object)coffeeFound, myMap);
            logger.log(System.Logger.Level.TRACE, "locate Entity Coffee in EntityManager and update");
            Coffee coffeeFound2 = (Coffee)this.getEntityManager().find(Coffee.class, (Object)2);
            this.getEntityManager().refresh((Object)coffeeFound2, myMap);
            coffeeFound2.setPrice(6.0f);
            this.getEntityTransaction().commit();
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("refreshTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData");
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Create 5 Coffees");
            Coffee[] cRef = new Coffee[]{new Coffee(1, "hazelnut", 1.0f), new Coffee(2, "vanilla creme", 2.0f), new Coffee(3, "decaf", 3.0f), new Coffee(4, "breakfast blend", 4.0f), new Coffee(5, "mocha", 5.0f)};
            logger.log(System.Logger.Level.TRACE, "Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                logger.log(System.Logger.Level.TRACE, "persisted coffee " + c);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

