/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.exceptions;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.exceptions.Coffee;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import jakarta.persistence.Query;
import jakarta.persistence.QueryTimeoutException;
import jakarta.persistence.RollbackException;
import jakarta.persistence.TransactionRequiredException;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Coffee"};
        return this.createDeploymentJar("jpa_core_exceptions.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void TransactionRequiredExceptionTest() throws Exception {
        boolean pass = false;
        Coffee newCoffee = new Coffee(1, "hazelnut", 1.0f);
        try {
            logger.log(System.Logger.Level.TRACE, "Invoked persist without an active transaction");
            this.getEntityManager().persist((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "In JavaEE, Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass && this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("TransactionRequiredExceptionTest failed");
        }
    }

    @Test
    public void TransactionRequiredException2Test() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Test TransactionRequiredExceptionNullMsg");
        boolean pass = true;
        try {
            throw new TransactionRequiredException();
        }
        catch (TransactionRequiredException eee) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected");
            if (eee.getMessage() != null) {
                logger.log(System.Logger.Level.ERROR, "TransactionRequiredException should have had null message, actual message=" + eee.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.INFO, "Test TransactionRequiredExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new TransactionRequiredException(expected);
        }
        catch (TransactionRequiredException eee) {
            logger.log(System.Logger.Level.TRACE, "TransactionRequiredException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "TransactionRequiredException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("TransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin exceptionTest2");
        Coffee newCoffee = new Coffee(2, "french roast", 9.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "try flush");
            this.getEntityManager().flush();
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception :", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("exceptionTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin exceptionTest3");
        boolean pass = false;
        Coffee newCoffee = new Coffee(3, "french roast", 9.0f);
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Persist Coffee ");
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "Call refresh without an active transaction");
            this.getEntityManager().refresh((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin exceptionTest4");
        Coffee newCoffee = new Coffee(5, "breakfast blend", 3.0f);
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.getEntityTransaction().commit();
            logger.log(System.Logger.Level.TRACE, "Call remove without an active transaction");
            this.getEntityManager().remove((Object)newCoffee);
        }
        catch (TransactionRequiredException tre) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Exception Caught as Expected: " + tre);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest4 failed");
        }
    }

    @Test
    public void exceptionTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin exceptionTest5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().close();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Exception Caught as Expected: " + ise);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass && this.isStandAloneMode()) {
            logger.log(System.Logger.Level.TRACE, "In JavaSE, Exception Not Thrown as Expected");
            pass = true;
        }
        if (!pass) {
            throw new Exception("exceptionTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void exceptionTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin exceptionTest6");
        boolean pass = false;
        Coffee newCoffee = new Coffee(7, "cinnamon", 7.0f);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)newCoffee);
            this.clearCache();
            if (!this.getEntityManager().contains((Object)newCoffee)) {
                this.getEntityManager().refresh((Object)newCoffee);
            } else {
                logger.log(System.Logger.Level.TRACE, "Entity is managed, cannot proceed with test");
            }
            this.getEntityTransaction().commit();
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Exception Caught as Expected: " + iae);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("exceptionTest6 failed");
        }
    }

    @Test
    public void RollbackExceptionTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Test RollbackExceptionNullMsg");
        boolean pass = true;
        try {
            throw new RollbackException();
        }
        catch (RollbackException re) {
            logger.log(System.Logger.Level.TRACE, "RollbackException Caught as Expected");
            if (re.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "RollbackException should have had null message, actual message=" + re.getMessage());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.INFO, "Test RollbackExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new RollbackException(expected);
        }
        catch (RollbackException re) {
            logger.log(System.Logger.Level.TRACE, "RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test RollbackExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new RollbackException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (RollbackException re) {
            logger.log(System.Logger.Level.TRACE, "RollbackException Caught as Expected");
            String msg = re.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = re.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "RollbackException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test RollbackExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new RollbackException((Throwable)new IllegalAccessException(expected));
        }
        catch (RollbackException re) {
            logger.log(System.Logger.Level.TRACE, "RollbackException Caught as Expected");
            Throwable t = re.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("RollbackExceptionTest failed");
        }
    }

    @Test
    public void EntityExistsExceptionTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Test EntityExistsExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityExistsException();
        }
        catch (EntityExistsException eee) {
            logger.log(System.Logger.Level.TRACE, "EntityExistsException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "EntityExistsException should have had null message, actual message=" + eee.getMessage());
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.INFO, "Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityExistsException(expected);
        }
        catch (EntityExistsException eee) {
            logger.log(System.Logger.Level.TRACE, "EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test EntityExistsExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new EntityExistsException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (EntityExistsException eee) {
            logger.log(System.Logger.Level.TRACE, "EntityExistsException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "EntityExistsException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test EntityExistsExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new EntityExistsException((Throwable)new IllegalAccessException(expected));
        }
        catch (EntityExistsException eee) {
            logger.log(System.Logger.Level.TRACE, "EntityExistsException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("EntityExistsExceptionTest failed");
        }
    }

    @Test
    public void EntityNotFoundExceptionTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Test EntityNotFoundExceptionNullMsg");
        boolean pass = true;
        try {
            throw new EntityNotFoundException();
        }
        catch (EntityNotFoundException enf) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected");
            if (enf.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "EntityNotFoundException should have had null message, actual message=" + enf.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test EntityNotFoundExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new EntityNotFoundException(expected);
        }
        catch (EntityNotFoundException enf) {
            logger.log(System.Logger.Level.TRACE, "EntityNotFoundException Caught as Expected");
            String msg = enf.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "EntityNotFoundException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("EntityNotFoundExceptionTest failed");
        }
    }

    @Test
    public void OptimisticLockExceptionTest() throws Exception {
        String msg;
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new OptimisticLockException();
        }
        catch (OptimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "OptimisticLockException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new OptimisticLockException(expected);
        }
        catch (OptimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (OptimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new OptimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (OptimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException((Object)cExpected);
        }
        catch (OptimisticLockException ol) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test OptimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new OptimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (OptimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "OptimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                logger.log(System.Logger.Level.ERROR, "Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "OptimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("OptimisticLockExceptionTest failed");
        }
    }

    @Test
    public void PersistenceExceptionTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Test PersistenceExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PersistenceException();
        }
        catch (PersistenceException eee) {
            logger.log(System.Logger.Level.TRACE, "PersistenceException Caught as Expected");
            if (eee.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PersistenceException should have had null message, actual message=" + eee.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test EntityExistskExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PersistenceException(expected);
        }
        catch (PersistenceException eee) {
            logger.log(System.Logger.Level.TRACE, "PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PersistenceExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PersistenceException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PersistenceException eee) {
            logger.log(System.Logger.Level.TRACE, "PersistenceException Caught as Expected");
            String msg = eee.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = eee.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (!msg.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PersistenceException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PersistenceExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PersistenceException((Throwable)new IllegalAccessException(expected));
        }
        catch (PersistenceException eee) {
            logger.log(System.Logger.Level.TRACE, "PersistenceException Caught as Expected");
            Throwable t = eee.getCause();
            if (t instanceof IllegalAccessException) {
                String msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("PersistenceExceptionTest failed");
        }
    }

    @Test
    public void LockTimeoutExceptionTest() throws Exception {
        String msg;
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionNullMsg");
        boolean pass = true;
        try {
            throw new LockTimeoutException();
        }
        catch (LockTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "LockTimeoutException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new LockTimeoutException(expected);
        }
        catch (LockTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (LockTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new LockTimeoutException((Throwable)new IllegalAccessException(expected));
        }
        catch (LockTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException((Object)cExpected);
        }
        catch (LockTimeoutException ol) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            Coffee c = (Coffee)ol.getObject();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test LockTimeoutExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new LockTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (LockTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "LockTimeoutException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getObject();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                logger.log(System.Logger.Level.ERROR, "Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "LockTimeoutException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("LockTimeoutExceptionTest failed");
        }
    }

    @Test
    public void PessimisticLockExceptionTest() throws Exception {
        String msg;
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionNullMsg");
        boolean pass = true;
        try {
            throw new PessimisticLockException();
        }
        catch (PessimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            if (ole.getMessage() != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PessimisticLockException should have had null message, actual message=" + ole.getMessage());
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new PessimisticLockException(expected);
        }
        catch (PessimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            String msg2 = ole.getMessage();
            if (msg2 != null) {
                if (!msg2.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg2 + ", Actual=" + msg2);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionStringThrowable");
        expected = "This is the String message";
        String expected2 = "This is the Throwable message";
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2));
        }
        catch (PessimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            String msg3 = ole.getMessage();
            if (msg3 != null) {
                if (msg3.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg3 = t.getMessage();
                        if (!msg3.equals(expected2)) {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg3 + ", Actual=" + msg3);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionThrowable");
        expected = "This is the Throwable message";
        try {
            throw new PessimisticLockException((Throwable)new IllegalAccessException(expected));
        }
        catch (PessimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            Throwable t = ole.getCause();
            if (t instanceof IllegalAccessException) {
                msg = t.getMessage();
                if (!msg.equals(expected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionObjectMsg");
        Coffee cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException((Object)cExpected);
        }
        catch (PessimisticLockException ol) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            Coffee c = (Coffee)ol.getEntity();
            if (c != null) {
                if (!c.equals(cExpected)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + cExpected + ", Actual=" + c);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        logger.log(System.Logger.Level.INFO, "Test PessimisticLockExceptionStringThrowableObject");
        expected = "This is the String message";
        expected2 = "This is the Throwable message";
        cExpected = new Coffee(1, "hazelnut", 1.0f);
        try {
            throw new PessimisticLockException(expected, (Throwable)new IllegalAccessException(expected2), (Object)cExpected);
        }
        catch (PessimisticLockException ole) {
            logger.log(System.Logger.Level.TRACE, "PessimisticLockException Caught as Expected");
            msg = ole.getMessage();
            if (msg != null) {
                if (msg.equals(expected)) {
                    Throwable t = ole.getCause();
                    if (t instanceof IllegalAccessException) {
                        msg = t.getMessage();
                        if (msg.equals(expected2)) {
                            Coffee c = (Coffee)ole.getEntity();
                            if (!c.equals(cExpected)) {
                                pass = false;
                                logger.log(System.Logger.Level.ERROR, "Expected Entity=" + cExpected + ", Actual=" + c);
                            }
                        } else {
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg + ", Actual=" + msg);
                        }
                    } else {
                        pass = false;
                        logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                    }
                } else {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                }
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "PessimisticLockException returned null message");
            }
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("PessimisticLockExceptionTest failed");
        }
    }

    @Test
    public void QueryTimeoutExceptionTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "Begin QueryTimeoutExceptionNullMsgTest");
        boolean pass = true;
        try {
            throw new QueryTimeoutException();
        }
        catch (QueryTimeoutException ole) {
            logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
            if (ole.getMessage() != null) {
                logger.log(System.Logger.Level.ERROR, "QueryTimeoutException should have had null message, actual message=" + ole.getMessage());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Test QueryTimeoutExceptionStringMsg");
            String expected = "This is the String message";
            try {
                throw new QueryTimeoutException(expected);
            }
            catch (QueryTimeoutException ole2) {
                logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
                String msg = ole2.getMessage();
                if (msg != null) {
                    if (!msg.equals(expected)) {
                        logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "QueryTimeoutException returned null message");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Test QueryTimeoutExceptionStringThrowable");
                expected = "This is the String message";
                String expected2 = "This is the Throwable message";
                try {
                    throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2));
                }
                catch (QueryTimeoutException ole3) {
                    logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
                    String msg2 = ole3.getMessage();
                    if (msg2 != null) {
                        if (msg2.equals(expected)) {
                            Throwable t = ole3.getCause();
                            if (t instanceof IllegalAccessException) {
                                msg2 = t.getMessage();
                                if (!msg2.equals(expected2)) {
                                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg2 + ", Actual=" + msg2);
                                    pass = false;
                                }
                            } else {
                                logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                                pass = false;
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected=" + msg2 + ", Actual=" + msg2);
                            pass = false;
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "QueryTimeoutException returned null message");
                        pass = false;
                    }
                    logger.log(System.Logger.Level.INFO, "Test QueryTimeoutExceptionThrowable");
                    expected = "This is the Throwable message";
                    try {
                        throw new QueryTimeoutException((Throwable)new IllegalAccessException(expected));
                    }
                    catch (QueryTimeoutException qte) {
                        String msg3;
                        logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
                        Throwable t = qte.getCause();
                        if (t instanceof IllegalAccessException) {
                            msg3 = t.getMessage();
                            if (msg3 != null) {
                                if (!msg3.equals(expected)) {
                                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                                    pass = false;
                                }
                            } else {
                                logger.log(System.Logger.Level.ERROR, "t.getMessage() returned null");
                                pass = false;
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t);
                            pass = false;
                        }
                        logger.log(System.Logger.Level.INFO, "Begin QueryTimeoutExceptionObjectMsgTest");
                        Query qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                        try {
                            throw new QueryTimeoutException(qExpected);
                        }
                        catch (QueryTimeoutException qte2) {
                            logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
                            Query q = qte2.getQuery();
                            if (q != null) {
                                if (q.equals(qExpected)) {
                                    pass = true;
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "Expected=" + expected + ", Actual=" + q);
                                    pass = false;
                                }
                            } else {
                                logger.log(System.Logger.Level.ERROR, "QueryTimeoutException returned null message");
                                pass = false;
                            }
                            logger.log(System.Logger.Level.INFO, "Test QueryTimeoutExceptionStringThrowableObject");
                            expected = "This is the String message";
                            expected2 = "This is the Throwable message";
                            qExpected = this.getEntityManager().createQuery("select c from Coffee c");
                            try {
                                throw new QueryTimeoutException(expected, (Throwable)new IllegalAccessException(expected2), qExpected);
                            }
                            catch (QueryTimeoutException qte3) {
                                logger.log(System.Logger.Level.TRACE, "QueryTimeoutException Caught as Expected");
                                msg3 = qte3.getMessage();
                                if (msg3 != null) {
                                    if (msg3.equals(expected)) {
                                        Throwable t2 = qte3.getCause();
                                        if (t2 instanceof IllegalAccessException) {
                                            msg3 = t2.getMessage();
                                            if (msg3 != null) {
                                                if (msg3.equals(expected2)) {
                                                    Query q2 = qte3.getQuery();
                                                    if (q2 != null) {
                                                        if (!q2.equals(qExpected)) {
                                                            logger.log(System.Logger.Level.ERROR, "Expected Entity=" + qExpected + ", Actual=" + q2);
                                                            pass = false;
                                                        }
                                                    } else {
                                                        logger.log(System.Logger.Level.ERROR, "getQuery returned null");
                                                        pass = false;
                                                    }
                                                } else {
                                                    logger.log(System.Logger.Level.ERROR, "Expected Throwable msg=" + msg3 + ", Actual=" + msg3);
                                                    pass = false;
                                                }
                                            } else {
                                                logger.log(System.Logger.Level.ERROR, "t.getMessage returned null");
                                                pass = false;
                                            }
                                        } else {
                                            logger.log(System.Logger.Level.ERROR, "getCause did not return an instance of IllegalAccessException, instead got " + t2);
                                            pass = false;
                                        }
                                    } else {
                                        logger.log(System.Logger.Level.ERROR, "Expected=" + msg3 + ", Actual=" + msg3);
                                        pass = false;
                                    }
                                } else {
                                    logger.log(System.Logger.Level.ERROR, "QueryTimeoutException returned null message");
                                    pass = false;
                                }
                            }
                            catch (Exception e) {
                                logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
                                pass = false;
                            }
                            if (!pass) {
                                throw new Exception("QueryTimeoutExceptionTest failed");
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    @Test
    public void NonUniqueResultExceptionTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.INFO, "Begin NonUniqueResultExceptionNullMsgTest");
        try {
            throw new NonUniqueResultException();
        }
        catch (NonUniqueResultException nure) {
            logger.log(System.Logger.Level.TRACE, "NonUniqueResultException Caught as Expected");
            if (nure.getMessage() != null) {
                logger.log(System.Logger.Level.ERROR, "NonUniqueResultException should have had null message, actual message=" + nure.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.TRACE, "Testing NonUniqueResultExceptionStringMsg");
        String expected = "This is the String message";
        try {
            throw new NonUniqueResultException(expected);
        }
        catch (NonUniqueResultException ole) {
            logger.log(System.Logger.Level.TRACE, "NonUniqueResultException Caught as Expected");
            String msg = ole.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "NonUniqueResultException returned null message");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("NonUniqueResultExceptionTest failed");
        }
    }

    @Test
    public void NoResultExceptionTest() throws Exception {
        boolean pass = true;
        logger.log(System.Logger.Level.INFO, "Testing NoResultExceptionNullMsg");
        try {
            throw new NoResultException();
        }
        catch (NoResultException nre) {
            logger.log(System.Logger.Level.TRACE, "NoResultException Caught as Expected");
            if (nre.getMessage() != null) {
                logger.log(System.Logger.Level.ERROR, "NoResultException should have had null message, actual message=" + nre.getMessage());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception Caught", (Throwable)e);
            pass = false;
        }
        logger.log(System.Logger.Level.INFO, "Testing NoResultExceptionStringMsgTest");
        String expected = "This is the String message";
        try {
            throw new NoResultException(expected);
        }
        catch (NoResultException nre) {
            logger.log(System.Logger.Level.TRACE, "NoResultException Caught as Expected");
            String msg = nre.getMessage();
            if (msg != null) {
                if (!msg.equals(expected)) {
                    logger.log(System.Logger.Level.ERROR, "Expected=" + msg + ", Actual=" + msg);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "NoResultException returned null message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("NoResultExceptionTest failed");
            }
            return;
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            if (this.getEntityManager().isOpen()) {
                this.removeTestData();
            }
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

