/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany.A;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_remove_oneXmany.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest1() throws Exception {
        boolean pass = false;
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest1");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("11", "b1", 1);
            B b2 = new B("12", "b2", 2);
            B b3 = new B("13", "b3", 3);
            B b4 = new B("14", "b4", 4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "a1", 1, v1);
            boolean status = this.getInstanceStatus(aRef);
            if (!status) {
                logger.log(System.Logger.Level.TRACE, "Instance state is not managed as expected.Try invoking remove on it.");
                this.getEntityManager().remove((Object)aRef);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance state is managed.  Unexpected as this is NEW instance.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception during remove operation. Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest2() throws Exception {
        boolean pass = false;
        boolean status = false;
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest2");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("21", "b1", 2);
            this.createB(b1);
            B b2 = new B("22", "b2", 2);
            this.createB(b2);
            B b3 = new B("23", "b3", 2);
            this.createB(b3);
            B b4 = new B("24", "b4", 2);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove");
                this.getEntityManager().remove((Object)this.findA("2"));
                logger.log(System.Logger.Level.TRACE, "Call contains after remove");
                if (!this.getEntityManager().contains((Object)aRef)) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest3");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("31", "b1", 3);
            this.createB(b1);
            B b2 = new B("32", "b2", 3);
            this.createB(b2);
            B b3 = new B("33", "b3", 3);
            this.createB(b3);
            B b4 = new B("34", "b4", 3);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("3", "bean3", 3, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("3"));
                logger.log(System.Logger.Level.TRACE, "Remove is immediately visible to the contains method");
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest4");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("51", "b1", 5);
            this.createB(b1);
            B b2 = new B("52", "b2", 5);
            this.createB(b2);
            B b3 = new B("53", "b3", 5);
            this.createB(b3);
            B b4 = new B("54", "b4", 5);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("5", "bean5", 5, v1);
            this.createA(aRef);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getEntityManager().contains((Object)aRef);
            if (status) {
                logger.log(System.Logger.Level.TRACE, "Status is true, try remove");
                this.getEntityManager().remove((Object)aRef);
                if (!this.getEntityManager().contains((Object)aRef)) {
                    this.getEntityManager().remove((Object)aRef);
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "contains method returned true; unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest5() throws Exception {
        boolean pass = false;
        boolean status = false;
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest5");
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("61", "b1", 6);
            this.createB(b1);
            B b2 = new B("62", "b2", 6);
            this.createB(b2);
            B b3 = new B("63", "b3", 6);
            this.createB(b3);
            B b4 = new B("64", "b4", 6);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("6", "bean6", 6, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("6"));
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "A removed entity is removed from the  database as a result of the flush operation");
                A newA = this.findA("6");
                if (newA == null) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest6");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("71", "b1", 7);
            this.createB(b1);
            B b2 = new B("72", "b2", 7);
            this.createB(b2);
            B b3 = new B("73", "b3", 7);
            this.createB(b3);
            B b4 = new B("74", "b4", 7);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("7", "bean7", 7, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("7"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception during remove operation. Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void remove1XMTest7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin remove1XMTest7");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("81", "b1", 8);
            this.createB(b1);
            B b2 = new B("82", "b2", 8);
            this.createB(b2);
            B b3 = new B("83", "b3", 8);
            this.createB(b3);
            B b4 = new B("84", "b4", 8);
            this.createB(b4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("8", "bean8", 8, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            logger.log(System.Logger.Level.TRACE, "Get Instance Status ");
            status = this.getInstanceStatus(aRef);
            if (status && newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                logger.log(System.Logger.Level.TRACE, "Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findA("8"));
                if (!(this.getEntityManager().contains((Object)aRef) || this.getEntityManager().contains((Object)b1) || this.getEntityManager().contains((Object)b2) || this.getEntityManager().contains((Object)b3) || this.getEntityManager().contains((Object)b4))) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception during remove operation.  Should have been ignored.", (Throwable)fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1XMTest7 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        logger.log(System.Logger.Level.TRACE, "Entered createB method");
        this.getEntityManager().persist((Object)b);
        this.getEntityManager().flush();
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        logger.log(System.Logger.Level.TRACE, "Collection Data");
        logger.log(System.Logger.Level.TRACE, "---------------");
        logger.log(System.Logger.Level.TRACE, "- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            logger.log(System.Logger.Level.TRACE, "- Element #" + elem++);
            logger.log(System.Logger.Level.TRACE, "  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

