/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.persist.oneXone;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.persist.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.persist.oneXone.B;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "B"};
        return this.createDeploymentJar("jpa_core_entitytest_remove_persist.oneXone.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Entering Setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("1", "a1", 1);
            B bRef = new B("1", "bean1", 1, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "getA1");
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)bRef)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results - test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test2");
        boolean pass = false;
        boolean result = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("2", "a2", 2);
            B bRef = new B("2", "b2", 2, a1);
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            result = this.getInstanceStatus(this.findB("2"));
            if (result) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, remove it ");
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().flush();
                    logger.log(System.Logger.Level.TRACE, "Persist a removed entity");
                    this.getEntityManager().persist((Object)bRef);
                    pass = this.getInstanceStatus(bRef);
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist a removed entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("13", "b13", 13);
            A aRef = new A("13", "bean13", 13, b1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException e) {
            logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected:" + e);
            pass = true;
            Object aRef = null;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("4", "a4", 4);
            B bRef = new B("4", "bean4", 4, a1);
            this.getEntityManager().persist((Object)bRef);
            A a2 = bRef.getA1();
            if (a1 == a2 && this.getEntityManager().contains((Object)a2)) {
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Unexpected results received - test failed");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New A instance");
            A a1 = new A("5", "a5", 5);
            logger.log(System.Logger.Level.TRACE, "New B instance");
            B bRef = new B("5", "bean5", 5, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "get newly persisted A instance");
            A a2 = bRef.getA1();
            if (a1 == a2) {
                logger.log(System.Logger.Level.TRACE, "try to remove a2 instance");
                this.getEntityManager().remove((Object)a2);
                logger.log(System.Logger.Level.TRACE, "try to remove bRef instance");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
            }
            A newA = this.findA("5");
            B newB = this.findB("5");
            if (null == newA && null == newB) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test6() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("6", "a6", 6);
            B bRef = new B("6", "bean6", 6, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)bRef.getA1());
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test7() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("7", "a7", 7);
            B bRef = new B("7", "bean7", 7, a1);
            this.getEntityManager().persist((Object)bRef);
            pass = this.getEntityManager().contains((Object)bRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test8() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test8");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "bean8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            logger.log(System.Logger.Level.TRACE, "bref created, try find");
            A newA = this.findA("8");
            pass = this.getEntityManager().contains((Object)newA);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test9() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test9");
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("9", "a9", 9);
            B bRef = new B("9", "bean9", 9, a1);
            pass = this.getEntityManager().contains((Object)bRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass) {
            throw new Exception("persist1X1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test10() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test10");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            B b1 = new B("10", "b10", 10);
            A aRef = new A("10", "bean10", 10, b1);
            pass1 = this.getEntityManager().contains((Object)b1);
            pass2 = this.getEntityManager().contains((Object)aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (pass1 || pass2 || !pass) {
            logger.log(System.Logger.Level.ERROR, "pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2);
            throw new Exception("persist1X1Test10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test11() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test11");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("11");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                pass = this.getEntityManager().contains((Object)a1);
                logger.log(System.Logger.Level.TRACE, "try to find A");
                A a2 = this.findA("11");
                if (null != a2) {
                    logger.log(System.Logger.Level.TRACE, "A2 is not null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persist1X1Test12() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persist1X1Test12");
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.TRACE, "New instances");
            A a1 = new A("12", "a12", 12);
            B bRef = new B("12", "bean12", 12, a1);
            this.createB(bRef);
            this.getEntityTransaction().begin();
            B b2 = this.findB("12");
            if (this.getEntityManager().contains((Object)b2)) {
                b2.setBName("newBean12");
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "getBName returns: " + b2.getBName());
                if (b2.getBName().equals("newBean12")) {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persist1X1Test12 failed");
        }
    }

    private A findA(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        logger.log(System.Logger.Level.TRACE, "Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private B findB(String id) {
        logger.log(System.Logger.Level.TRACE, "Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

