/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.ordercolumn;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Course;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Student;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private List<Student> expectedResults;
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Course", pkgName + "Department", pkgName + "Department2", pkgName + "Employee", pkgName + "Employee2", pkgName + "Student"};
        return this.createDeploymentJar("jpa_core_annotations_ordercolumn1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createStudentTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void orderColumn() throws Exception {
        boolean pass = false;
        String expectedStudentName = "Joseph";
        int expectedListSize = 4;
        int courseNumber = 101;
        int numStudents = 0;
        try {
            this.getEntityTransaction().begin();
            Course course = (Course)this.getEntityManager().find(Course.class, (Object)101);
            if (course != null) {
                numStudents = course.getStudents().size();
            } else {
                logger.log(System.Logger.Level.ERROR, "course from find() is NULL!");
            }
            if (numStudents == 4) {
                List<Student> students = course.getStudents();
                if (students.get(0).equals(this.expectedResults.get(0)) && students.get(1).equals(this.expectedResults.get(1)) && students.get(2).equals(this.expectedResults.get(2)) && students.get(3).equals(this.expectedResults.get(3))) {
                    logger.log(System.Logger.Level.TRACE, "****Current order of students returned via getStudents()\nNow checking via JPQL");
                    Query q = this.getEntityManager().createQuery("SELECT s.studentName FROM Course c JOIN c.students s where c.courseName ='Physics' and INDEX(s) = 1");
                    String result = (String)q.getSingleResult();
                    if (result.equals("Joseph")) {
                        logger.log(System.Logger.Level.TRACE, "+++Received expected Name via Query:Joseph");
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did NOT get expected name via Query: Joseph, received: " + result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Failed to return the correct order of students via getStudents()");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "course.getStudents() returned wrong number!");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("orderColumn test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStudentTestData() {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData");
            this.getEntityTransaction().begin();
            Student student1 = new Student(1, "Neo");
            Student student2 = new Student(2, "Vivek");
            Student student3 = new Student(3, "Arun");
            Student student4 = new Student(4, "Ganesh");
            Student student5 = new Student(5, "Ram");
            Student student6 = new Student(6, "Rahim");
            Student student7 = new Student(7, "Joseph");
            Student student8 = new Student(8, "Krishna");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            Course operationResearch = new Course(103, "OperationResearch");
            Course statistics = new Course(201, "Statistics");
            Course operatingSystem = new Course(202, "OperatingSystem");
            ArrayList<Student> studentList1 = new ArrayList<Student>();
            studentList1.add(student1);
            studentList1.add(student7);
            studentList1.add(student2);
            studentList1.add(student8);
            this.expectedResults = new ArrayList<Student>();
            this.expectedResults.addAll(studentList1);
            ArrayList<Student> studentList2 = new ArrayList<Student>();
            studentList2.add(student3);
            studentList2.add(student4);
            ArrayList<Student> studentList3 = new ArrayList<Student>();
            studentList3.add(student5);
            studentList3.add(student6);
            ArrayList<Student> studentList4 = new ArrayList<Student>();
            studentList4.add(student7);
            studentList4.add(student8);
            appliedMath.setStudents(studentList1);
            physics.setStudents(studentList1);
            operationResearch.setStudents(studentList1);
            statistics.setStudents(studentList2);
            operatingSystem.setStudents(studentList2);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            firstSemCourses.add(operationResearch);
            ArrayList<Course> secondSemCourses = new ArrayList<Course>();
            secondSemCourses.add(statistics);
            secondSemCourses.add(operatingSystem);
            student1.setCourses(firstSemCourses);
            student2.setCourses(firstSemCourses);
            student3.setCourses(secondSemCourses);
            student4.setCourses(secondSemCourses);
            student5.setCourses(secondSemCourses);
            student6.setCourses(secondSemCourses);
            student7.setCourses(firstSemCourses);
            student8.setCourses(firstSemCourses);
            EntityManager entityManager = this.getEntityManager();
            entityManager.persist((Object)student1);
            entityManager.persist((Object)student2);
            entityManager.persist((Object)student3);
            entityManager.persist((Object)student4);
            entityManager.persist((Object)student5);
            entityManager.persist((Object)student6);
            entityManager.persist((Object)student7);
            entityManager.persist((Object)student8);
            logger.log(System.Logger.Level.TRACE, "persisted 8 students");
            entityManager.persist((Object)appliedMath);
            entityManager.persist((Object)physics);
            entityManager.persist((Object)operationResearch);
            entityManager.persist((Object)statistics);
            entityManager.persist((Object)operatingSystem);
            logger.log(System.Logger.Level.TRACE, "persisted 5 Courses");
            logger.log(System.Logger.Level.TRACE, "persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COURSE_STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

