/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.entity;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.entity.Coffee;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static Coffee[] cRef = new Coffee[5];
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Coffee"};
        return this.createDeploymentJar("jpa_core_annotations_entity.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "Create Test data");
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationEntityTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationEntityTest1");
        boolean pass = true;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedBrands = new String[]{"vanilla creme", "mocha", "hazelnut", "decaf", "breakfast blend"};
            logger.log(System.Logger.Level.TRACE, "find coffees by brand name");
            c = this.getEntityManager().createQuery("Select c.brandName from cof c ORDER BY c.brandName DESC").setMaxResults(10).getResultList();
            Object[] result = c.toArray(new String[c.size()]);
            logger.log(System.Logger.Level.TRACE, "Compare results of Coffee Brand Names");
            pass = Arrays.equals(expectedBrands, result);
            if (!pass) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 5 Coffees : vanilla creme, mocha, hazelnut, decaf, breakfast blend.  Received: " + c.size());
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, " Coffee Brand Name: " + it.next());
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationEntityTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin annotationEntityTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Integer[] expectedPKs = new Integer[]{21, 22, 23, 24, 25};
            logger.log(System.Logger.Level.TRACE, "find all coffees");
            c = this.getEntityManager().createQuery("Select c from cof c").setMaxResults(10).getResultList();
            if (c.size() != 5) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 5 references, got: " + c.size());
                pass1 = false;
            } else if (pass1) {
                logger.log(System.Logger.Level.TRACE, "Expected size received, verify contents . . . ");
                Iterator i = c.iterator();
                int foundCof = 0;
                block11: while (i.hasNext()) {
                    logger.log(System.Logger.Level.TRACE, "Check List for expected coffees");
                    Coffee o = (Coffee)i.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedPKs[l].equals(o.getId())) continue;
                        logger.log(System.Logger.Level.TRACE, "Found coffee with PK: " + o.getId());
                        ++foundCof;
                        continue block11;
                    }
                }
                if (foundCof != 5) {
                    logger.log(System.Logger.Level.ERROR, "anotationEntityTest2: Did not get expected results");
                    pass2 = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected results received");
                    pass2 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData");
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Create 5 Coffees");
            Client.cRef[0] = new Coffee(21, "hazelnut", 1.0f);
            Client.cRef[1] = new Coffee(22, "vanilla creme", 2.0f);
            Client.cRef[2] = new Coffee(23, "decaf", 3.0f);
            Client.cRef[3] = new Coffee(24, "breakfast blend", 4.0f);
            Client.cRef[4] = new Coffee(25, "mocha", 5.0f);
            logger.log(System.Logger.Level.TRACE, "Start to persist coffees ");
            for (Coffee coffee : cRef) {
                this.getEntityManager().persist((Object)coffee);
                logger.log(System.Logger.Level.TRACE, "persisted coffee " + coffee);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

