/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.staticfieldelresolver;

import com.sun.ts.tests.el.api.jakarta_el.staticfieldelresolver.TCKELClass;
import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELClass;
import jakarta.el.ELContext;
import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.StandardELContext;
import jakarta.el.StaticFieldELResolver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void staticFieldELResolverTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        ELClass base = new ELClass(TCKELClass.class);
        String property = "firstName";
        String value = "Ender";
        context.setPropertyResolved(false);
        try {
            resolver.setValue((ELContext)context, (Object)base, (Object)property, (Object)value);
            buf.append("Test FAILED" + ELTestUtil.NL + "Expected PropertyNotWritableException to be thrown when calling setValue()!" + ELTestUtil.NL + "No exception was thown!" + ELTestUtil.NL);
            pass = false;
        }
        catch (PropertyNotWritableException pnwe) {
            buf.append("Test PASSED" + ELTestUtil.NL + "PropertyNotWritableException Thrown as expected for setValue()!" + ELTestUtil.NL);
        }
        catch (Exception e) {
            buf.append("Test FAILED" + ELTestUtil.NL + "Wrong Exception Thrownfor setValue()!" + ELTestUtil.NL + "Expected: PropertyNotWritableException" + ELTestUtil.NL + "Received: " + e.getClass().getSimpleName() + ELTestUtil.NL);
        }
        context.setPropertyResolved(false);
        Object valueRetrieved = resolver.getValue((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("getValue() did not resolve" + ELTestUtil.NL);
            pass = false;
        }
        if (valueRetrieved != value) {
            buf.append("Invalid value from getValue():" + ELTestUtil.NL + "Value expected: " + value.toString() + ELTestUtil.NL + "Value retrieved: " + valueRetrieved.toString() + ELTestUtil.NL);
            pass = false;
        }
        context.setPropertyResolved(false);
        Class type = resolver.getType((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("getType() did not resolve" + ELTestUtil.NL);
            pass = false;
        } else if (type != null) {
            buf.append("getType() returns " + type.getName() + " rather than null" + ELTestUtil.NL);
            pass = false;
        } else {
            buf.append("getType() returns null" + ELTestUtil.NL + "as expected." + ELTestUtil.NL);
        }
        context.setPropertyResolved(false);
        boolean nonWritable = resolver.isReadOnly((ELContext)context, (Object)base, (Object)property);
        if (!context.isPropertyResolved()) {
            buf.append("isReadOnly() did not resolve" + ELTestUtil.NL);
            pass = false;
        } else if (!nonWritable) {
            buf.append("isReadOnly() returned unexpected value: " + ELTestUtil.NL + "Expected: false" + ELTestUtil.NL + "Received: " + nonWritable + ELTestUtil.NL);
            pass = false;
        } else {
            buf.append("isReadOnly() returns false as expected" + ELTestUtil.NL);
        }
        context.setPropertyResolved(false);
        Class commonPropertyType = resolver.getCommonPropertyType((ELContext)context, (Object)base);
        buf.append("getCommonPropertyType() returns " + commonPropertyType.getName() + ELTestUtil.NL);
        if (!pass) {
            throw new Exception("Test FAILED" + ELTestUtil.NL + buf.toString());
        }
    }

    @Test
    public void staticFieldResolverInvokeMNFETest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class, String.class};
        Object[] values = new String[]{"Doug", "Donahue"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, context.getELResolver(), new ELClass(TCKELClass.class), "bogue_method", types, values, true, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void staticFieldELResolverInvokeTest() throws Exception {
        StringBuffer buf = new StringBuffer();
        boolean pass = false;
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        Class[] types = new Class[]{String.class};
        Object[] values = new String[]{"Ender"};
        try {
            pass = ResolverTest.testELResolverInvoke((ELContext)context, context.getELResolver(), new ELClass(TCKELClass.class), "isName", types, values, false, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void staticFieldELResolverNPETest() throws Exception {
        boolean pass = false;
        StringBuffer buf = new StringBuffer();
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, new ELClass(TCKELClass.class), "intention", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void staticFieldResolverInvokePNFETest() throws Exception {
        ELClass base = new ELClass(TCKELClass.class);
        this.testForPNFE("notStatic", base);
        this.testForPNFE("privStatic", base);
        this.testForPNFE("privStatic", "bogus");
    }

    private void testForPNFE(String property, Object base) {
        StringBuffer buf = new StringBuffer();
        ELManager elm = new ELManager();
        StaticFieldELResolver resolver = new StaticFieldELResolver();
        elm.addELResolver((ELResolver)resolver);
        StandardELContext context = elm.getELContext();
        try {
            resolver.getType((ELContext)context, base, (Object)property);
            buf.append("Test FAILED getType() did not throw any exception." + ELTestUtil.NL + "Expected: PropertyNotFoundException " + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            buf.append("Test PASSED");
        }
        catch (Exception e) {
            buf.append("Test FAILEDWrong Exception thrown for getType()!" + ELTestUtil.NL + " Expected: PropertyNotFoundException" + ELTestUtil.NL + "Received: " + e.getClass().getSimpleName());
        }
        try {
            resolver.getValue((ELContext)context, base, (Object)property);
            buf.append("Test FAILED getValue() did not throw any exception." + ELTestUtil.NL + "Expected: PropertyNotFoundException " + ELTestUtil.NL);
        }
        catch (PropertyNotFoundException pnfe) {
            buf.append("Test PASSED");
        }
        catch (Exception e) {
            buf.append("Test FAILEDWrong Exception thrown getValue()!" + ELTestUtil.NL + " Expected: PropertyNotFoundException" + ELTestUtil.NL + "Received: " + e.getClass().getSimpleName());
        }
    }
}

