/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */


/*
 *  @(#)TypeConstraintException.test.xml	1.1 02/11/04 Evgueni Rouban
 * Generated from : api/jakarta_xml/bind/TypeConstraintException/TypeConstraintException.test.xml
 *
 * General tests of constructors and methods
 * General tests of constructors and methods.
 */

package javasoft.sqe.tests.api.jakarta.xml.bind.TypeConstraintException;

import jakarta.xml.bind.TypeConstraintException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiTest;


public class TypeConstraintExceptionTests extends MultiTest {

    static final String msg = "test message";
    static final String err = "error code";
    static final Throwable linkedException = new Throwable();

    public static class PrintStackTraceDetector extends Throwable {
        public boolean printStackTraceCalled;
        public void printStackTrace(java.io.PrintStream s) {
            printStackTraceCalled = true;
            super.printStackTrace(s);
        }
        public void printStackTrace() {
            printStackTraceCalled = true;
            super.printStackTrace();
        }
    };

    /* standalone interface */
    public static void main(String argv[]) {
        TypeConstraintExceptionTests test = new TypeConstraintExceptionTests();
        test.run(argv, System.err, System.out).exit();
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message),
     * Construct a TypeConstraintException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor001() {
        TypeConstraintException tce = new TypeConstraintException(msg);
        if (tce.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + tce.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and output values orientation
     * for public java.lang.String getErrorCode(),
     * <br><b>pre-conditions</b>: errorCode set to null,
     * <br><b>output</b>: null.
     */
    public Status Ctor002() {
        TypeConstraintException tce = new TypeConstraintException(msg);
        if (tce.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + tce.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor003() {
        TypeConstraintException tce = new TypeConstraintException(msg);
        if (tce.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + tce.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.String errorCode),
     * Construct a TypeConstraintException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor004() {
        TypeConstraintException tce = new TypeConstraintException(msg, err);
        if (tce.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + tce.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and output values orientation
     * for public java.lang.String getErrorCode(),
     * <br><b>pre-conditions</b>: errorCode set to a non-null value,
     * <br><b>output</b>: non-null.
     */
    public Status Ctor005() {
        TypeConstraintException tce = new TypeConstraintException(msg, err);
        if (tce.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + tce.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.String errorCode),
     * The linkedException will default to null..
     * <br><b>Expected results</b>: linkedException is null
     */
    public Status Ctor006() {
        TypeConstraintException tce = new TypeConstraintException(msg, err);
        if (tce.getLinkedException() != null) {
            return Status.failed("getLinkedException() != null: \""
                               + tce.getLinkedException() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a TypeConstraintException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor007() {
        TypeConstraintException tce = new TypeConstraintException(msg, err, linkedException);
        if (tce.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + tce.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.Throwable getLinkedException(),
     * <br><b>pre-conditions</b>: linkedException set to a non-null value,
     * Get the linked exception..
     * <br><b>Expected output value</b>: the linkedException is what set
     */
    public Status Ctor008() {
        TypeConstraintException tce = new TypeConstraintException(msg, err, linkedException);
        if (tce.getErrorCode() != err) {
            return Status.failed("getErrorCode() != err: \""
                               + tce.getErrorCode() + "\", expected is \"" + err + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.String errorCode, java.lang.Throwable exception),
     * Construct a TypeConstraintException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor009() {
        TypeConstraintException tce = new TypeConstraintException(msg, err, linkedException);
        if (tce.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + tce.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.Throwable exception),
     * Construct a TypeConstraintException with the specified detail message..
     * <br><b>Expected results</b>: the message is what set
     */
    public Status Ctor010() {
        TypeConstraintException tce = new TypeConstraintException(msg, linkedException);
        if (tce.getMessage() != msg) {
            return Status.failed("getMessage() != msg: \""
                               + tce.getMessage() + "\", expected is \"" + msg + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor011() {
        TypeConstraintException tce = new TypeConstraintException(msg, linkedException);
        if (tce.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + tce.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.String message, java.lang.Throwable exception),
     * Construct a TypeConstraintException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor012() {
        TypeConstraintException tce = new TypeConstraintException(msg, linkedException);
        if (tce.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + tce.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.Throwable exception),
     * The detail message will default to null..
     * <br><b>Expected results</b>: the message is null
     */
    public Status Ctor013() {
        TypeConstraintException tce = new TypeConstraintException(linkedException);
        if (tce.getMessage() != null) {
            return Status.failed("getMessage() != null: \""
                               + tce.getMessage() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.Throwable exception),
     * The errorCode will default to null..
     * <br><b>Expected results</b>: errorCode is null
     */
    public Status Ctor014() {
        TypeConstraintException tce = new TypeConstraintException(linkedException);
        if (tce.getErrorCode() != null) {
            return Status.failed("getErrorCode() != null: \""
                               + tce.getErrorCode() + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public TypeConstraintException(java.lang.Throwable exception),
     * Construct a TypeConstraintException with the specified linkedException..
     * <br><b>Expected results</b>: linkedException is what set
     */
    public Status Ctor015() {
        TypeConstraintException tce = new TypeConstraintException(linkedException);
        if (tce.getLinkedException() != linkedException) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + tce.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public java.lang.String toString(),
     * <br><b>pre-conditions</b>: detail message, error code and linked exception are not null,
     * Returns a short description of this TypeConstraintException..
     * <br><b>Expected output value</b>: non-empty string
     */
    public Status Ctor016() {
        TypeConstraintException tce = new TypeConstraintException(msg, err, linkedException);
        String str = tce.toString();

        if (str == null) {
            return Status.failed("tce.toString() returns null");
        }

        if (str.length() <= 0) {
            return Status.failed("tce.toString().length() returns " + str.length());
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and input values orientation
     * for public void setLinkedException(java.lang.Throwable exception),
     * <br><b>pre-conditions</b>: linkedException is not set,
     * <br><b>exception</b>: non-null.
     * <br><b>Expected results</b>: the linkedException is what set
     */
    public Status Ctor017() {
        TypeConstraintException tce = new TypeConstraintException(msg);

        tce.setLinkedException(linkedException);
        if (tce.getLinkedException() == null) {
            return Status.failed("getLinkedException() == null");
        }

        return Status.passed("OKAY");
    }

    /**
     * Boundary value analysis
     * with state and input values orientation
     * for public void setLinkedException(java.lang.Throwable exception),
     * <br><b>pre-conditions</b>: linkedException is set to a non-null value,
     * <br><b>exception</b>: null.
     * <br><b>Expected results</b>: the linkedException is null
     */
    public Status Ctor018() {
        TypeConstraintException tce = new TypeConstraintException(linkedException);

        tce.setLinkedException(null);
        if (tce.getLinkedException() != null) {
            return Status.failed("getLinkedException() != linkedException: \""
                               + tce.getLinkedException() + "\", expected is \"" + linkedException + "\"");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void printStackTrace(),
     * <br><b>pre-conditions</b>: linkedException is set to a non-null value,
     * Prints this TypeConstraintException and its stack trace (including the stack trace of the linkedException if it is
     * non-null) to the PrintStream..
     * <br><b>Expected results</b>: the linkedException's method printStackTrace() or printStackTrace(PrintStream) is called
     */
    public Status Ctor019() {
        PrintStackTraceDetector linkedException = new PrintStackTraceDetector();
        TypeConstraintException tce = new TypeConstraintException(linkedException);

        tce.printStackTrace();
        if (!linkedException.printStackTraceCalled) {
            return Status.failed("printStackTrace() of the linked exception has not been called");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void printStackTrace(java.io.PrintStream s),
     * <br><b>pre-conditions</b>: linkedException is set to a non-null value,
     * Prints this TypeConstraintException and its stack trace (including the stack trace of the linkedException if it is
     * non-null) to the PrintStream..
     * <br><b>Expected results</b>: the linkedException's method printStackTrace(PrintStream) is called
     */
    public Status Ctor020() {
        PrintStackTraceDetector linkedException = new PrintStackTraceDetector();
        TypeConstraintException tce = new TypeConstraintException(linkedException);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);

        tce.printStackTrace(ps);
        ps.close();
        if (!linkedException.printStackTraceCalled) {
            return Status.failed("printStackTrace(PrintStream) of the linked exception has not been called");
        }

        return Status.passed("OKAY");
    }

    /**
     * Assertion testing
     * for public void printStackTrace(java.io.PrintStream s),
     * <br><b>pre-conditions</b>: error message is set to a non-null value,
     * Prints this TypeConstraintException and its stack trace to the PrintStream..
     * <br><b>Expected results</b>: at leat one byte has been written to the PrintWriter's stream
     */
    public Status Ctor021() {
        TypeConstraintException tce = new TypeConstraintException(msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);

        tce.printStackTrace(ps);
        ps.close();
        if (baos.size() <= 0) {
            return Status.failed("no bytes were written to the stream");
        }

        return Status.passed("OKAY");
    }
}
