/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class ToolAction
implements Action {
    private String name;
    private String desc;
    private Integer mnemonic;
    private Icon icon;
    private Map<String, Object> misc;
    private boolean enabled = true;
    private List<WeakReference<PropertyChangeListener>> listeners = new ArrayList<WeakReference<PropertyChangeListener>>();

    public ToolAction(String name, String desc, int mnemonic) {
        this.name = name;
        this.desc = desc;
        this.mnemonic = mnemonic;
        this.enabled = true;
    }

    public ToolAction(UIFactory uif, String key) {
        this(uif.getI18NResourceBundle(), key);
    }

    public ToolAction(UIFactory uif, String key, boolean needIcon) {
        this(uif, key);
        if (needIcon) {
            this.putValue("SmallIcon", uif.createIcon(key));
        }
    }

    public ToolAction(I18NResourceBundle i18n, String key) {
        this(i18n.getString(key + ".act"), i18n.getString(key + ".tip"), ToolAction.getMnemonic(i18n, key + ".mne"));
    }

    private static int getMnemonic(I18NResourceBundle i18n, String key) {
        String keyString = i18n.getString(key);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyString);
        return keyStroke == null ? 0 : keyStroke.getKeyCode();
    }

    private static boolean equal(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public Object getValue(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.equals("Name")) {
            return this.name;
        }
        if (key.equals("ShortDescription")) {
            return this.desc;
        }
        if (key.equals("MnemonicKey")) {
            return this.mnemonic;
        }
        if (key.equals("SmallIcon")) {
            return this.icon;
        }
        return this.misc == null ? null : this.misc.get(key);
    }

    @Override
    public void putValue(String key, Object newVal) {
        Object oldVal;
        if (key.equals("Name")) {
            if (ToolAction.equal(newVal, this.name)) {
                return;
            }
            oldVal = this.name;
            this.name = (String)newVal;
        } else if (key.equals("ShortDescription")) {
            if (ToolAction.equal(newVal, this.desc)) {
                return;
            }
            oldVal = this.desc;
            this.desc = (String)newVal;
        } else if (key.equals("MnemonicKey")) {
            if (ToolAction.equal(newVal, this.mnemonic)) {
                return;
            }
            oldVal = this.mnemonic;
            this.mnemonic = (Integer)newVal;
        } else if (key.equals("SmallIcon")) {
            if (ToolAction.equal(newVal, this.icon)) {
                return;
            }
            oldVal = this.icon;
            this.icon = (Icon)newVal;
        } else {
            if (this.misc == null) {
                this.misc = new HashMap<String, Object>();
            }
            if (ToolAction.equal(newVal, oldVal = this.misc.get(key))) {
                return;
            }
            this.misc.put(key, newVal);
        }
        this.firePropertyChangeEvent(key, oldVal, newVal);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean newVal) {
        if (this.enabled == newVal) {
            return;
        }
        boolean oldVal = this.enabled;
        this.enabled = newVal;
        if (this.listeners.size() > 0) {
            this.firePropertyChangeEvent("enabled", oldVal, newVal);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(new WeakReference<PropertyChangeListener>(listener));
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        WeakReference<PropertyChangeListener> found = null;
        for (WeakReference<PropertyChangeListener> reference : this.listeners) {
            if (reference.get() != listener) continue;
            found = reference;
            break;
        }
        if (found != null) {
            this.listeners.remove(found);
        }
    }

    private void firePropertyChangeEvent(String name, Object oldVal, Object newVal) {
        PropertyChangeEvent ev = null;
        if (this.listeners.size() > 0) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                PropertyChangeListener pcl = (PropertyChangeListener)this.listeners.get(i).get();
                if (pcl == null) continue;
                if (ev == null) {
                    ev = new PropertyChangeEvent(this, name, oldVal, newVal);
                }
                pcl.propertyChange(ev);
            }
        }
    }
}

