/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.AgentMonitorBatchCommandManager;
import com.sun.javatest.agent.AgentMonitorToolManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.ListIterator;

public class AgentMonitorCommandManager
extends AgentMonitorBatchCommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(AgentMonitorCommandManager.class);

    @Override
    public boolean parseCommand(String cmd, ListIterator<String> argIter, CommandContext ctx) throws Command.Fault {
        if (super.parseCommand(cmd, argIter, ctx)) {
            return true;
        }
        if (cmd.equalsIgnoreCase(ShowMonitorCommand.getName())) {
            ctx.addCommand(new ShowMonitorCommand());
            return true;
        }
        return false;
    }

    @Override
    String[] getCommands() {
        String[] cmds = super.getCommands();
        String[] newCmds = new String[cmds.length + 1];
        System.arraycopy(cmds, 0, newCmds, 0, cmds.length);
        newCmds[cmds.length] = ShowMonitorCommand.getName();
        return newCmds;
    }

    private static class ShowMonitorCommand
    extends Command {
        ShowMonitorCommand() {
            super(ShowMonitorCommand.getName());
        }

        static String getName() {
            return "monitorAgent";
        }

        @Override
        public int getDesktopMode() {
            return 2;
        }

        @Override
        public void run(CommandContext ctx) {
            Desktop d = ctx.getDesktop();
            AgentMonitorToolManager tm = (AgentMonitorToolManager)d.getToolManager(AgentMonitorToolManager.class);
            tm.startTool();
        }
    }
}

