/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.common;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class MyBufferedInputStream
extends BufferedInputStream {
    private static final Logger LOGGER = Logger.getLogger(MyBufferedInputStream.class.getName());
    private boolean throwIOException = false;

    public MyBufferedInputStream(InputStream in) {
        super(in);
    }

    public MyBufferedInputStream(InputStream in, int sz) {
        super(in, sz);
    }

    public MyBufferedInputStream(InputStream in, boolean throwIOException) {
        super(in);
        this.throwIOException = throwIOException;
    }

    private void checkToTripIOException() throws IOException {
        if (this.throwIOException) {
            LOGGER.info("MyBufferedInputStream->checkToTripIOException: *** tripping an IOException ***");
            throw new IOException("tripping an IOException");
        }
    }

    public void setThrowIOException(boolean throwIOException) {
        this.throwIOException = throwIOException;
    }

    @Override
    public int read() throws IOException {
        this.checkToTripIOException();
        int c = super.read();
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkToTripIOException();
        int c = super.read(b, off, len);
        return c;
    }

    @Override
    public void close() throws IOException {
        this.checkToTripIOException();
        super.close();
    }
}

