/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.attrdecl.ad_name.ad_name00118.ad_name00118;

import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class AD_name00118_CTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        AD_name00118_CTTests test = new AD_name00118_CTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status Get001( ) {
        Root root = (Root)unmarshal("AD_name00118_p.xml");
        String failure = "";

        if (root.getA\u01bbA() != 0) {
            failure += "; root.getA\u01bbA() returns " + root.getA\u01bbA();
        }
        if (root.getB\u01bbB() != 1) {
            failure += "; root.getB\u01bbB() returns " + root.getB\u01bbB();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }

    public Status Set001( ) {
        Root root = (Root)unmarshal("AD_name00118_p.xml");
        String failure = "";

        root.setA\u01bbA(10);
        root.setB\u01bbB(20);

        if (root.getA\u01bbA() != 10) {
            failure += "; root.getA\u01bbA() returns " + root.getA\u01bbA();
        }
        if (root.getB\u01bbB() != 20) {
            failure += "; root.getB\u01bbB() returns " + root.getB\u01bbB();
        }

        if (failure.length() == 0) {
            return Status.passed("OK");
        }

        return Status.failed(failure.substring(2));
    }


}

