/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.IntQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class IntQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    protected int lwb;
    protected int upb;
    protected long range;
    protected int[] suggs;
    protected JButton resetBtn;

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        IntQuestion q = (IntQuestion)qq;
        this.lwb = q.getLowerBound();
        this.upb = q.getUpperBound();
        this.range = (long)this.upb - (long)this.lwb;
        this.suggs = q.getSuggestions();
        if (this.range > 10L || this.suggs != null) {
            return this.createTextField(q, listener);
        }
        return this.createSlider(q, listener);
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    protected JPanel createTextField(IntQuestion q, ActionListener listener) {
        String[] strSuggs;
        int w = 1;
        while (this.range >= 10L) {
            this.range /= 10L;
            ++w;
        }
        if (this.lwb < 0) {
            ++w;
        }
        if (this.suggs == null) {
            strSuggs = null;
        } else {
            strSuggs = new String[this.suggs.length];
            for (int i = 0; i < this.suggs.length; ++i) {
                strSuggs[i] = String.valueOf(this.suggs[i]);
            }
        }
        int defVal = q.getDefaultValue();
        if (defVal == Integer.MIN_VALUE) {
            this.resetBtn = null;
        } else {
            this.resetBtn = new JButton(i18n.getString("int.reset.btn"));
            this.resetBtn.setName("int.reset.btn");
            this.resetBtn.setMnemonic(i18n.getString("int.reset.mne").charAt(0));
            this.resetBtn.setToolTipText(i18n.getString("int.reset.tip"));
        }
        TypeInPanel p = new TypeInPanel("int.field", q, w, strSuggs, this.resetBtn, listener);
        if (this.resetBtn != null) {
            this.resetBtn.addActionListener(e -> {
                NumberFormat fmt = NumberFormat.getNumberInstance();
                p.setValue(fmt.format((Object)defVal));
            });
        }
        return p;
    }

    protected JPanel createSlider(IntQuestion q, ActionListener listener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("int");
        panel.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(i18n.getString("int.sldr.lbl"));
        label.setName("int.sldr.lbl");
        label.setDisplayedMnemonic(i18n.getString("int.sldr.mne").charAt(0));
        label.setToolTipText(i18n.getString("int.sldr.tip"));
        panel.add((Component)label, c);
        int value = q.isValid() ? q.getValue() : this.lwb;
        JSlider slider = new JSlider(this.lwb, this.upb, value);
        slider.setName("int.sldr");
        slider.setMajorTickSpacing((this.upb - this.lwb) / 2);
        slider.setMinorTickSpacing(1);
        slider.setSnapToTicks(true);
        slider.setPaintTicks(true);
        int startHint = q.getLabelStartHint();
        int incHint = q.getLabelIncrementHint();
        if (incHint != 0) {
            slider.setLabelTable(slider.createStandardLabels(incHint, startHint));
        }
        slider.setPaintLabels(true);
        label.setLabelFor(slider);
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)slider, c);
        Runnable valueSaver = () -> q.setValue(slider.getValue());
        panel.putClientProperty("valueSaver", valueSaver);
        return panel;
    }
}

