/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import com.sun.javatest.tool.jthelp.HelpBroker;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class PreferencesPane
extends JPanel {
    public static void showDialog(JFrame f, Preferences preferences, PreferencesPane[] panes, HelpBroker helpBroker) {
        PrefsDialog d = new PrefsDialog(f, preferences, panes, helpBroker);
        d.setVisible(true);
    }

    protected void setHelp(String helpID) {
        ContextHelpManager.setHelpIDString(this, helpID);
    }

    public abstract String getText();

    public void load(Map<String, String> m) {
        PreferencesPane[] p = this.getChildPanes();
        if (p != null) {
            for (PreferencesPane aP : p) {
                aP.load(m);
            }
        }
    }

    public void save(Map<String, String> m) {
        PreferencesPane[] p = this.getChildPanes();
        if (p != null) {
            for (PreferencesPane aP : p) {
                aP.save(m);
            }
        }
    }

    public String validateValues() {
        return null;
    }

    public PreferencesPane[] getChildPanes() {
        return null;
    }

    private static class PrefsDialog
    extends JDialog
    implements ActionListener,
    TreeModel,
    TreeSelectionListener,
    WindowListener {
        private int cardNum;
        private JFrame owner;
        private Preferences preferences;
        private Map<String, String> props;
        private HelpBroker helpBroker;
        private PreferencesPane[] panes;
        private UIFactory uif;
        private JPanel main;
        private JPanel deck;
        private JButton okBtn;
        private JButton cancelBtn;
        private JButton helpBtn;
        private JTree tree;

        PrefsDialog(JFrame f, Preferences preferences, PreferencesPane[] panes, HelpBroker helpBroker) {
            super((Frame)null, true);
            this.owner = f;
            this.preferences = preferences;
            this.props = preferences.getProperties();
            this.panes = panes;
            this.helpBroker = helpBroker;
            this.uif = new UIFactory(this.getClass(), helpBroker);
            this.initGUI();
            this.owner.addWindowListener(this);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                for (PreferencesPane pane : this.panes) {
                    pane.load(this.props);
                }
            }
            super.setVisible(b);
            if (!b) {
                this.owner.removeWindowListener(this);
            }
        }

        private void initGUI() {
            this.setName("prefs");
            this.setTitle(this.uif.getI18NString("prefs.title"));
            KeyStroke keystroke = KeyStroke.getKeyStroke(112, 0, false);
            this.getRootPane().registerKeyboardAction(e -> {
                if (this.helpBroker != null) {
                    this.helpBroker.displayCurrentID(ContextHelpManager.getHelpIDString(this.getRootPane()));
                }
            }, keystroke, 1);
            ContextHelpManager.setHelpIDString(this.getRootPane(), "ui.prefs.dialog.csh");
            Desktop.addHelpDebugListener(this);
            this.uif.setAccessibleDescription(this, "prefs");
            this.main = this.uif.createPanel("prefs.main", new BorderLayout(), false);
            this.initTree();
            this.initPanes();
            this.initButtons();
            this.setContentPane(this.main);
            Object[] path = new Object[]{this.tree.getModel().getRoot(), this.getChildren(this)[0]};
            this.tree.setSelectionPath(new TreePath(path));
            this.pack();
            this.setLocationRelativeTo(this.owner);
            this.getRootPane().setDefaultButton(this.okBtn);
        }

        private void initTree() {
            this.tree = new JTree(this);
            this.tree.setName("prefs.tree");
            this.tree.addTreeSelectionListener(this);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.uif.setAccessibleInfo(this.tree, "prefs.tree");
            int dpi = this.uif.getDotsPerInch();
            this.tree.setPreferredSize(new Dimension(2 * dpi, dpi));
            this.tree.setVisibleRowCount(10);
            this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (value instanceof PreferencesPane) {
                        return super.getTreeCellRendererComponent(tree, ((PreferencesPane)value).getText(), selected, expanded, leaf, row, hasFocus);
                    }
                    return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
            });
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.expandRow(2);
            JScrollPane treeStuff = this.uif.createScrollPane(this.tree);
            treeStuff.setBorder(BorderFactory.createEtchedBorder());
            this.main.add((Component)treeStuff, "West");
        }

        private void initButtons() {
            this.okBtn = this.uif.createButton("prefs.ok", this);
            this.cancelBtn = this.uif.createCancelButton("prefs.cancel", this);
            this.helpBtn = this.uif.createHelpButton("prefs.help", "ui.prefs.dialog.csh");
            JButton[] btns = new JButton[]{this.okBtn, this.cancelBtn, this.helpBtn};
            Dimension maxBtnDims = new Dimension();
            for (JButton btn2 : btns) {
                Dimension d = btn2.getPreferredSize();
                maxBtnDims.width = Math.max(maxBtnDims.width, d.width);
                maxBtnDims.height = Math.max(maxBtnDims.height, d.height);
            }
            for (JButton btn1 : btns) {
                btn1.setPreferredSize(maxBtnDims);
            }
            JPanel p = this.uif.createPanel("prefs.btns", false);
            p.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            c.insets.top = 5;
            c.insets.bottom = 11;
            c.insets.right = 11;
            c.weightx = 1.0;
            for (JButton btn : btns) {
                p.add((Component)btn, c);
                c.weightx = 0.0;
            }
            this.main.add((Component)p, "South");
            InputMap inputMap = p.getInputMap(2);
            ActionMap actionMap = p.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cancelBtn.doClick(250);
                }
            });
        }

        private void initPanes() {
            this.deck = this.uif.createPanel("prefs.deck", new CardLayout(), false);
            this.addAllPanes(this.deck, this.panes);
            int dpi = this.uif.getDotsPerInch();
            Dimension maxPrefSize = new Dimension(3 * dpi, 2 * dpi);
            for (int i = 0; i < this.deck.getComponentCount(); ++i) {
                Dimension d = this.deck.getComponent(i).getPreferredSize();
                maxPrefSize.width = Math.max(maxPrefSize.width, d.width);
                maxPrefSize.height = Math.max(maxPrefSize.height, d.height);
            }
            this.deck.setPreferredSize(maxPrefSize);
            this.main.add((Component)this.deck, "Center");
        }

        private void addAllPanes(JPanel deck, PreferencesPane ... panes) {
            for (PreferencesPane pane : panes) {
                JPanel p = this.uif.createPanel("prefs.card" + this.cardNum++, false);
                p.setLayout(new BorderLayout());
                JLabel head = new JLabel(pane.getText());
                head.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                p.add((Component)head, "North");
                pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                p.add((Component)this.uif.createScrollPane(pane), "Center");
                deck.add((Component)p, pane.getText());
                if (pane.getChildPanes() == null) continue;
                this.addAllPanes(deck, pane.getChildPanes());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.okBtn) {
                boolean b = this.okToSave();
                if (!b) {
                    return;
                }
                this.setPreferences(this.panes);
                this.preferences.save();
                this.setVisible(false);
            } else if (src == this.cancelBtn) {
                for (PreferencesPane pane : this.panes) {
                    pane.load(this.props);
                }
                this.setVisible(false);
            }
        }

        private boolean okToSave() {
            String reason = null;
            for (PreferencesPane pane : this.panes) {
                reason = pane.validateValues();
                if (reason != null) {
                    this.tree.setSelectionPath(new TreePath(new Object[]{this, pane}));
                    break;
                }
                PreferencesPane[] p = pane.getChildPanes();
                if (p == null) continue;
                for (PreferencesPane aP : p) {
                    reason = aP.validateValues();
                    if (reason == null) continue;
                    this.tree.setSelectionPath(new TreePath(new Object[]{this, pane, aP}));
                    break;
                }
                if (reason != null) break;
            }
            if (reason != null) {
                this.uif.showLiteralError(this.uif.getI18NString("prefs.badPref.title"), reason);
                return false;
            }
            return true;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path != null) {
                PreferencesPane pane = (PreferencesPane)path.getLastPathComponent();
                ((CardLayout)this.deck.getLayout()).show(this.deck, pane.getText());
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getChildren(parent)[index];
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getChildren(parent).length;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            PreferencesPane[] children = this.getChildren(parent);
            for (int i = 0; i < children.length; ++i) {
                if (children[i] != child) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this;
        }

        @Override
        public boolean isLeaf(Object node) {
            PreferencesPane[] children = this.getChildren(node);
            return children == null || children.length == 0;
        }

        private void setPreferences(PreferencesPane ... panes) {
            Map<String, String> m = new Map<String, String>(){

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsKey(Object key) {
                    return props.containsKey(key);
                }

                @Override
                public boolean containsValue(Object value) {
                    return props.containsValue(value);
                }

                @Override
                public Set<Map.Entry<String, String>> entrySet() {
                    return props.entrySet();
                }

                @Override
                public boolean equals(Object o) {
                    return props.equals(o);
                }

                @Override
                public String get(Object key) {
                    return (String)props.get(key);
                }

                @Override
                public int hashCode() {
                    return props.hashCode();
                }

                @Override
                public boolean isEmpty() {
                    return props.isEmpty();
                }

                @Override
                public Set<String> keySet() {
                    return props.keySet();
                }

                @Override
                public String put(String key, String value) {
                    String oldValue = (String)props.get(key);
                    if (oldValue == null || !oldValue.equals(value)) {
                        preferences.setPreference(key, value);
                    }
                    return oldValue;
                }

                @Override
                public void putAll(Map<? extends String, ? extends String> m) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String remove(Object key) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    return props.size();
                }

                @Override
                public Collection<String> values() {
                    return props.values();
                }
            };
            for (PreferencesPane pane : panes) {
                pane.save(m);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            if (e.getSource() == this.owner) {
                this.toFront();
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (e.getSource() == this.owner) {
                this.toFront();
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        private PreferencesPane[] getChildren(Object parent) {
            return parent == this ? this.panes : ((PreferencesPane)parent).getChildPanes();
        }
    }
}

