/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.Interview;
import java.util.Objects;
import java.util.ResourceBundle;

public abstract class YesNoQuestion
extends ChoiceQuestion {
    public static final String YES = "Yes";
    public static final String NO = "No";
    private static final ResourceBundle i18n = Interview.i18n;

    protected YesNoQuestion(Interview interview, String tag) {
        this(interview, tag, (String)null);
    }

    protected YesNoQuestion(Interview interview, String tag, String defaultValue) {
        super(interview, tag);
        if (defaultValue != null && !defaultValue.equals(YES) && !defaultValue.equals(NO)) {
            throw new IllegalArgumentException();
        }
        String[] choices = new String[]{null, YES, NO};
        String[] displayChoices = new String[]{null, i18n.getString("yn.yes"), i18n.getString("yn.no")};
        this.setChoices(choices, displayChoices);
        if (!Objects.equals(defaultValue, this.getDefaultValue())) {
            this.setDefaultValue(defaultValue);
            this.setValue(defaultValue);
        }
    }

    @Override
    protected final void setChoices(String ... choices) {
        throw new IllegalArgumentException("Cannot set choices for YesNoQuestion");
    }
}

