/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.DirectResponseUsageResource;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.Resource;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.ResponseWithNoEntityUsesMapperResource;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.resource.webappexception.mapper.WebAppExceptionMapper;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_resource_webappexception_mapper_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/resource/webappexception/mapper/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_resource_webappexception_mapper_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, RuntimeExceptionMapper.class, WebAppExceptionMapper.class, DirectResponseUsageResource.class, ResponseWithNoEntityUsesMapperResource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void noResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "noresponse"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void okResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responseok"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void responseEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responseentity"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Resource.class.getSimpleName());
        this.invoke();
    }

    @Test
    public void statusOkResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responsestatusok"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void statusIntOkResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responsestatusintok"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void throwableResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responsethrowable"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void throwableOkResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responsestatusthrowableok"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void throwableIntOkResponseTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "responsestatusthrowableintok"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.ACCEPTED));
        this.invoke();
    }

    @Test
    public void throwUncheckedExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", this.buildRequest("GET ", "uncheckedexception"));
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }

    @Test
    public void webApplicationExceptionHasResponseWithEntityDoesNotUseMapperTest() throws JAXRSCommonClient.Fault {
        int[] codes = new int[]{2000, 4000, 400, 401, 403, 404, 405, 406, 415, 3000, 5000, 500, 503};
        for (int i = 0; i != codes.length; ++i) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "direct/" + codes[i]));
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, String.valueOf(codes[i] > 1000 ? codes[i] / 10 : codes[i]));
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, codes[i] > 1000 ? "DirectEntity" : DirectResponseUsageResource.getReasonPhrase(codes[i]));
            this.invoke();
        }
    }

    @Test
    public void webApplicationExceptionHasResponseWithoutEntityDoesUseMapperTest() throws JAXRSCommonClient.Fault {
        int[] codes = new int[]{4000, 400, 401, 403, 404, 405, 406, 415, 3000, 5000, 500, 503};
        for (int i = 0; i != codes.length; ++i) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "noentity/" + codes[i]));
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.FOUND));
            this.invoke();
        }
    }
}

