/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.ReaderClient;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext.ContextOperation;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext.ExceptionThrowingStringBean;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext.ExceptionThrowingStringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext.ReaderInterceptorOne;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.readerinterceptorcontext.ReaderInterceptorTwo;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends ReaderClient<ContextOperation> {
    private static final long serialVersionUID = -6962070973647934636L;

    public JAXRSClientIT() {
        this.setup();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getHeadersOperationSetTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETHEADERS);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "OPERATION");
        this.invoke();
    }

    @Test
    public void getHeadersHeadersSetTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETHEADERS);
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "Property" + i);
            builder = builder.header("Property" + i, (Object)"any");
        }
        Response fake = builder.build();
        this.addProviders(fake);
        this.setTextCaser(TextCaser.LOWER);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "OPERATION");
        this.invoke();
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETHEADERSISMUTABLE);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Property");
        this.invoke();
    }

    @Test
    public void getInputStreamTest() throws JAXRSCommonClient.Fault {
        String entity = "getInputStreamEntity";
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETINPUTSTREAM);
        Response fake = builder.entity((Object)entity).build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    @Test
    public void proceedThrowsIOExceptionTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.PROCEEDTHROWSIOEXCEPTION);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IOException has been thrown as expected");
        this.invoke();
    }

    @Test
    public void proceedThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.PROCEEDTHROWSWEBAPPEXCEPTION);
        Response fake = builder.build();
        this.addProviders(fake);
        this.addProvider(ExceptionThrowingStringBeanEntityProvider.class);
        this.invoke();
        StringBean bean = this.getResponseBody(ExceptionThrowingStringBean.class);
        JAXRSClientIT.assertContains(bean.get(), "WebApplicationException has been thrown as expected", new Object[]{"WebApplicationException has not been thrown and the message is", bean.get()});
        JAXRSClientIT.logMsg("WebApplicationException has been thrown as expected", bean.get());
    }

    @Test
    public void setInputStreamTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETINPUTSTREAM);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Other Entity");
        this.invoke();
    }

    @Override
    protected void addProviders(Response response) throws JAXRSCommonClient.Fault {
        super.addProviders(response);
        this.addProvider(ReaderInterceptorTwo.class);
        this.addProvider(ReaderInterceptorOne.class);
    }
}

