/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.annotation;

import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedAdaptedContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedDateContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedDoubleContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedNillableContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedNillablePropertyContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedPropertyOrderContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedPropertyVisibilityContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedSerializedArrayContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleAnnotatedSerializedContainer;
import ee.jakarta.tck.json.bind.api.model.SimpleContainer;
import ee.jakarta.tck.json.bind.api.model.SimplePartiallyAnnotatedPropertyOrderContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class AnnotationTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testJsonbDateFormat() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedDateContainer());
        MatcherAssert.assertThat((Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"Do(\\.?), 01 Jan(\\.?) 1970\"\\s*}"));
    }

    @Test
    public void testJsonbNillable() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedNillableContainer());
        MatcherAssert.assertThat((String)"Failed to enable serialization of null values using JsonbNillable annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*null\\s*}"));
    }

    @Test
    public void testJsonbNumberFormat() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedDoubleContainer());
        MatcherAssert.assertThat((String)"Failed to customize number format using JsonbNumberFormat annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"123.456,8\"\\s*}"));
    }

    @Test
    public void testJsonbProperty() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedNillablePropertyContainer());
        MatcherAssert.assertThat((String)"Failed to customize property name and enable serialization of null values using JsonbProperty annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nillableInstance\"\\s*:\\s*null\\s*}"));
    }

    @Test
    public void testJsonbPropertyOrder() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedPropertyOrderContainer());
        MatcherAssert.assertThat((String)"Failed to customize the order in which fields will be serialized using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"secondInstance\"\\s*:\\s*\"Second String\"\\s*,\\s*\"firstInstance\"\\s*:\\s*\"First String\"\\s*}"));
    }

    @Test
    public void testJsonbPropertyPartialOrder() {
        String jsonString = this.jsonb.toJson((Object)new SimplePartiallyAnnotatedPropertyOrderContainer());
        MatcherAssert.assertThat((String)"Failed to order the fields partially defined using JsonbPropertyOrder annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"thirdInstance\"\\s*:\\s*\"Third String\"\\s*,\\s*\"fourthInstance\"\\s*:\\s*\"Fourth String\".*}"));
    }

    @Test
    public void testJsonbTypeAdapter() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedAdaptedContainer(){
            {
                this.setInstance(new SimpleContainer(){
                    {
                        this.setInstance("Test String");
                    }
                });
            }
        });
        MatcherAssert.assertThat((String)"Failed to configure a JsonbAdapter implementation to provide custom mapping using JsonbTypeAdapter annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Adapted\"\\s*}\\s*}"));
    }

    @Test
    public void testJsonbTypeSerializer() {
        SimpleAnnotatedSerializedContainer container = new SimpleAnnotatedSerializedContainer();
        SimpleContainer instance = new SimpleContainer();
        instance.setInstance("Test String");
        container.setInstance(instance);
        String jsonString = this.jsonb.toJson((Object)container);
        MatcherAssert.assertThat((String)"Failed to configure a JsonbSerializer implementation to provide custom mapping using JsonbTypeSerializer annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Serialized\"\\s*}\\s*}"));
        SimpleAnnotatedSerializedContainer unmarshalledObject = (SimpleAnnotatedSerializedContainer)this.jsonb.fromJson("{ \"instance\" : { \"instance\" : \"Test String\" } }", SimpleAnnotatedSerializedContainer.class);
        MatcherAssert.assertThat((String)"Failed to configure a JsonbDeserializer implementation to provide custom mapping using JsonbTypeDeserializer annotation.", (Object)unmarshalledObject.getInstance().getInstance(), (Matcher)Matchers.is((Object)"Test String Deserialized"));
    }

    @Test
    public void testJsonbArrayTypeSerializer() {
        SimpleAnnotatedSerializedArrayContainer container = new SimpleAnnotatedSerializedArrayContainer();
        SimpleContainer instance1 = new SimpleContainer();
        instance1.setInstance("Test String 1");
        SimpleContainer instance2 = new SimpleContainer();
        instance2.setInstance("Test String 2");
        container.setInstance(new SimpleContainer[]{instance1, instance2});
        String jsonString = this.jsonb.toJson((Object)container);
        MatcherAssert.assertThat((String)"Failed to configure a JsonbSerializer implementation to provide custom mapping using JsonbTypeSerializer annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String 1\"\\s*}\\s*,\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String 2\"\\s*}\\s*]\\s*}"));
        SimpleAnnotatedSerializedArrayContainer unmarshalledObject = (SimpleAnnotatedSerializedArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ { \"instance\" : \"Test String 1\" }, { \"instance\" : \"Test String 2\" } ] }", SimpleAnnotatedSerializedArrayContainer.class);
        MatcherAssert.assertThat((String)"Failed to configure a JsonbDeserializer implementation to provide custom mapping using JsonbTypeDeserializer annotation.", (Object)unmarshalledObject.getInstance()[0].getInstance(), (Matcher)Matchers.is((Object)"Test String 1"));
    }

    @Test
    public void testJsonbVisibility() {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedPropertyVisibilityContainer());
        MatcherAssert.assertThat((String)"Failed to customize fields visibility using JsonbVisibility annotation.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"secondInstance\"\\s*:\\s*\"Second String\"\\s*}"));
    }
}

