/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.packaging.embed.classloader.annotated;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.basic.common.GlobalJNDITest;
import com.sun.ts.tests.ejb30.lite.packaging.embed.classloader.annotated.LocalIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Context;

public abstract class BeanBase
implements LocalIF {
    private StringBuilder postConstructRecords;
    protected CopyOnWriteArrayList arrayList;
    protected String databaseURL;
    protected String databaseUser;
    protected String databasePassword;
    protected String driverClassName;
    @EJB(name="oneBean", beanName="OneBean")
    protected LocalIF oneBean;
    @EJB(name="twoBean", beanName="TwoBean")
    protected LocalIF twoBean;
    @EJB(name="threeBean", beanName="ThreeBean")
    protected LocalIF threeBean;

    @Override
    public List<String> call123() {
        if (this.postConstructRecords == null) {
            throw new RuntimeException("postConstructRecords is null.");
        }
        ArrayList<String> records = new ArrayList<String>();
        records.add(this.oneBean.getName());
        records.add(this.twoBean.getName());
        records.add(this.threeBean.getName());
        return records;
    }

    @PostConstruct
    private void postConstruct() {
        this.postConstructRecords = new StringBuilder();
        LocalIF b1 = (LocalIF)ServiceLocator.lookupByShortNameNoTry("oneBean");
        Helper.assertEquals(null, this.oneBean, b1, this.postConstructRecords);
        LocalIF b2 = (LocalIF)ServiceLocator.lookupByShortNameNoTry("twoBean");
        Helper.assertEquals(null, this.twoBean, b2, this.postConstructRecords);
        LocalIF b3 = (LocalIF)ServiceLocator.lookupByShortNameNoTry("threeBean");
        Helper.assertEquals(null, this.threeBean, b3, this.postConstructRecords);
    }

    @Override
    public StringBuilder getPostConstructRecords() {
        return this.postConstructRecords;
    }

    @Override
    public StringBuilder lookupJNDINames(String appName, String moduleName1, String moduleName2, String moduleName3) {
        StringBuilder sb = new StringBuilder();
        LocalIF b1 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getGlobalJNDIName(appName, moduleName1, "OneBean"), new Context[0]);
        Helper.assertEquals(null, this.oneBean, b1, sb);
        LocalIF b2 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getGlobalJNDIName(appName, moduleName2, "TwoBean"), new Context[0]);
        Helper.assertEquals(null, this.twoBean, b2, sb);
        LocalIF b3 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getGlobalJNDIName(appName, moduleName3, "ThreeBean"), new Context[0]);
        Helper.assertEquals(null, this.threeBean, b3, sb);
        b1 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getAppJNDIName(moduleName1, "OneBean"), new Context[0]);
        Helper.assertEquals(null, this.oneBean, b1, sb);
        b2 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getAppJNDIName(moduleName2, "TwoBean"), new Context[0]);
        Helper.assertEquals(null, this.twoBean, b2, sb);
        b3 = (LocalIF)ServiceLocator.lookupNoTry(GlobalJNDITest.getAppJNDIName(moduleName3, "ThreeBean"), new Context[0]);
        Helper.assertEquals(null, this.threeBean, b3, sb);
        return sb;
    }

    @Override
    public List<String> setupOneBean(String url, String user, String password, String driverName) {
        this.databaseURL = url;
        this.databaseUser = user;
        this.databasePassword = password;
        this.driverClassName = driverName;
        return Arrays.asList("Setup called");
    }

    @Override
    public List<String> setupOneBeanWithArrayList(CopyOnWriteArrayList copyOnWriteArrayList) {
        this.arrayList = copyOnWriteArrayList;
        return Arrays.asList("setupOneBeanWithArrayList called");
    }
}

