/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.soap;

import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ClientAuthModule;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSSendFailureClientAuthModule
implements ClientAuthModule {
    private static TSLogger logger = null;
    private static Map options = null;

    public void initialize(MessagePolicy reqPolicy, MessagePolicy resPolicy, CallbackHandler handler, Map optns) throws AuthException {
        options = optns;
        if (options.get("TSLogger") != null) {
            logger = (TSLogger)options.get("TSLogger");
        }
    }

    public Class[] getSupportedMessageTypes() {
        Class[] classarray = new Class[]{SOAPMessage.class};
        this.logMsg("TSSendFailureClientAuthModule.getSupportedMessageTypes called");
        return classarray;
    }

    public AuthStatus secureRequest(MessageInfo messageInfo, Subject clientSubject) throws AuthException {
        String msg = "TSSendFailureClientAuthModule.secureRequest called";
        this.logMsg(msg);
        return AuthStatus.SEND_SUCCESS;
    }

    public AuthStatus validateResponse(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        Object msg = "TSSendFailureClientAuthModule.validateResponse called";
        this.logMsg((String)msg);
        SOAPMessage smsg = (SOAPMessage)messageInfo.getResponseMessage();
        String faultString = this.getSOAPFaultString(smsg);
        if (faultString != null) {
            msg = "TSSendFailureClientAuthModule.validateResponse received SOAPFault :" + faultString;
            this.logMsg((String)msg);
        }
        return AuthStatus.SUCCESS;
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSSendFailureClientAuthModule.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    private String getSOAPFaultString(SOAPMessage smsg) {
        String faultString = null;
        SOAPPart soap = smsg.getSOAPPart();
        if (soap != null) {
            try {
                SOAPBody body;
                SOAPEnvelope envelope = soap.getEnvelope();
                if (envelope != null && (body = envelope.getBody()) != null && body.hasFault()) {
                    SOAPFault sf = body.getFault();
                    faultString = sf.getFaultString();
                }
            }
            catch (SOAPException se) {
                logger.log(Level.INFO, "Error adding SOAP Fault", se);
            }
        }
        return faultString;
    }
}

