/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.JaxbKeyValueBean;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.common.impl.SecurityContextImpl;
import ee.jakarta.tck.ws.rs.common.impl.SinglevaluedMap;
import ee.jakarta.tck.ws.rs.common.impl.StringDataSource;
import ee.jakarta.tck.ws.rs.common.impl.StringSource;
import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import ee.jakarta.tck.ws.rs.common.impl.TRACE;
import ee.jakarta.tck.ws.rs.common.util.Holder;
import ee.jakarta.tck.ws.rs.common.util.LinkedHolder;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.SSEJAXRSClient;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink.CloseResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink.MBWCheckResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink.StageCheckerResource;
import ee.jakarta.tck.ws.rs.jaxrs21.ee.sse.sseeventsink.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends SSEJAXRSClient {
    private static final long serialVersionUID = 21L;
    protected long millis = 550L;
    protected int callbackResult = 0;
    protected Throwable callbackException = null;
    protected int sleep = -1;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_jaxrs21_ee_sse_sseeventsink_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/jaxrs21/ee/sse/sseeventsink/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_ee_sse_sseeventsink_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, CloseResource.class, MBWCheckResource.class, StageCheckerResource.class, TRACE.class, StringSource.class, StringStreamingOutput.class, StringDataSource.class, SinglevaluedMap.class, SecurityContextImpl.class, ReplacingOutputStream.class, JaxbKeyValueBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void stringTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/string");
    }

    @Test
    public void charTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/char");
        JAXRSClientIT.assertEquals(String.valueOf("some_ServiceUnavailableEndpoint_message".charAt(0)), holder.get().readData(), "Unexpected message received", holder.get().readData());
    }

    @Test
    public void intTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/int");
        JAXRSClientIT.assertEquals(Integer.MIN_VALUE, (Integer)holder.get().readData(Integer.class), "Unexpected message received", holder.get().readData());
    }

    @Test
    public void doubleTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/double");
        JAXRSClientIT.assertEquals(Double.MAX_VALUE, (Double)holder.get().readData(Double.class), "Unexpected message received", holder.get().readData());
    }

    @Test
    public void bytearrayTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/bytearray");
    }

    @Test
    public void readerTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/reader");
    }

    @Test
    public void inputstreamTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/inputstream");
    }

    @Test
    public void fileTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/file");
    }

    @Test
    public void datasourceTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/datasource");
    }

    @Test
    public void transformSourceTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/transformsource");
        JAXRSClientIT.logTrace("Received", holder.get());
        Assertions.assertTrue((boolean)holder.get().readData().contains("some_ServiceUnavailableEndpoint_message"), (String)("Unexpected message received" + holder.get().readData()));
    }

    @Test
    @Tag(value="xml_binding")
    public void jaxbElementTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/jaxbelement");
        JAXRSClientIT.logTrace("Received", holder.get());
        Assertions.assertTrue((boolean)holder.get().readData().contains("some_ServiceUnavailableEndpoint_message"), (String)("Unexpected message received" + holder.get().readData()));
    }

    @Test
    public void multivaluedMapTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("mbw/multivaluedmap");
        JAXRSClientIT.logTrace("Received", holder.get());
        Assertions.assertTrue((boolean)holder.get().readData().contains("some_ServiceUnavailableEndpoint_message"), (String)("Unexpected message received" + holder.get().readData()));
    }

    @Test
    public void streamingOutputTest() throws JAXRSCommonClient.Fault {
        this.querySSEEndpointAndAssert("mbw/streamingoutput");
    }

    @Test
    public void closeTest() throws JAXRSCommonClient.Fault {
        Holder<InboundSseEvent> holder = this.querySSEEndpoint("close/reset");
        JAXRSClientIT.assertEquals(holder.get().readData(), "RESET", "Reset unsuccessful");
        this.querySSEEndpointAndAssert("close/send");
        boolean closed = false;
        for (int cnt = 0; !closed && cnt < 20; ++cnt) {
            this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "close/closed"));
            this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
            this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, JAXRSClientIT.buildContentType(MediaType.TEXT_PLAIN_TYPE));
            this.invoke();
            closed = (Boolean)this.getResponse().readEntity(Boolean.class);
            TestUtil.sleepMsec(200);
        }
        holder = this.querySSEEndpoint("close/check");
        String msg = holder.get().readData();
        JAXRSClientIT.assertEquals(msg, "CHECK", "check unsuccessful:", msg);
    }

    @Test
    public void sseStageCheckTest() throws JAXRSCommonClient.Fault {
        LinkedHolder holder = new LinkedHolder();
        WebTarget target = ClientBuilder.newClient().target(this.getAbsoluteUrl("stage"));
        try (SseEventSource source = SseEventSource.target((WebTarget)target).build();){
            source.register(holder::add);
            source.open();
            this.sleepUntilHolderGetsFilled(holder);
            JAXRSClientIT.assertNotNull(holder.get(), "No message received");
            Assertions.assertTrue((boolean)((InboundSseEvent)holder.get(0)).readData().contains("some_ServiceUnavailableEndpoint_message"), (String)(holder.get(0) + "does not contain expectedsome_ServiceUnavailableEndpoint_message"));
            if (!((InboundSseEvent)holder.get(1)).readData().contains("CompletionStage has been done")) {
                this.sleepUntilHolderGetsFilled(holder);
            }
        }
        JAXRSClientIT.assertNotNull(holder.get(1), "No message received");
        JAXRSClientIT.assertEquals(((InboundSseEvent)holder.get(1)).readData(), "CompletionStage has been done", "The stage has not ever been done, message is", ((InboundSseEvent)holder.get()).readData());
    }
}

