/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.notauthorizedexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -377888431788668222L;
    private static final Response.Status STATUS = Response.Status.UNAUTHORIZED;
    private static final String[] CHALLENGE = new String[]{"challenge1", "challenge2", "challenge3"};
    protected static final String MESSAGE = "TCK NotAuthorizedException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorObjectsTest() throws JAXRSCommonClient.Fault {
        NotAuthorizedException e = new NotAuthorizedException((Object)CHALLENGE[0], new Object[]{CHALLENGE[1], CHALLENGE[2]});
        this.assertResponse((WebApplicationException)e);
        this.assertChallenges(e);
    }

    @Test
    public void constructorObjectsThrowsNPEWhenNullTest() throws JAXRSCommonClient.Fault {
        try {
            NotAuthorizedException e = new NotAuthorizedException(null, new Object[]{CHALLENGE[1], CHALLENGE[2]});
            JAXRSClientIT.fault("NullPointerException has NOT been thrown as expected for null challenge; exception", e);
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected for null challenge");
        }
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        NotAuthorizedException e = new NotAuthorizedException(this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAuthorizedException e = new NotAuthorizedException(this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "and exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorThrowableObjectTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAuthorizedException e = new NotAuthorizedException(t, (Object)CHALLENGE[0], new Object[]{CHALLENGE[1], CHALLENGE[2]});
            this.assertResponse((WebApplicationException)e);
            this.assertChallenges(e);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAuthorizedException e = new NotAuthorizedException(this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            this.assertCause((WebApplicationException)e, t);
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAuthorizedException e = new NotAuthorizedException(this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringObjectsTest() throws JAXRSCommonClient.Fault {
        NotAuthorizedException e = new NotAuthorizedException(MESSAGE, (Object)CHALLENGE[0], new Object[]{CHALLENGE[1], CHALLENGE[2]});
        this.assertResponse((WebApplicationException)e);
        this.assertChallenges(e);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringObjectsThrowsNPEWhenNullTest() throws JAXRSCommonClient.Fault {
        try {
            NotAuthorizedException e = new NotAuthorizedException(MESSAGE, null, new Object[]{CHALLENGE[1], CHALLENGE[2]});
            JAXRSClientIT.fault("NullPointerException has NOT been thrown as expected for null challenge; exception", e);
        }
        catch (NullPointerException npe) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected for null challenge");
        }
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        NotAuthorizedException e = new NotAuthorizedException(MESSAGE, this.buildResponse(STATUS));
        this.assertResponse((WebApplicationException)e, HOST);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAuthorizedException e = new NotAuthorizedException(MESSAGE, this.buildResponse(status));
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "and exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    @Test
    public void constructorStringThrowableObjectsTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAuthorizedException e = new NotAuthorizedException(MESSAGE, t, (Object)CHALLENGE[0], new Object[]{CHALLENGE[1], CHALLENGE[2]});
            this.assertResponse((WebApplicationException)e);
            this.assertChallenges(e);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable t : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            NotAuthorizedException e = new NotAuthorizedException(MESSAGE, this.buildResponse(STATUS), t);
            this.assertResponse((WebApplicationException)e, HOST);
            this.assertCause((WebApplicationException)e, t);
            this.assertMessage(e);
        }
    }

    @Test
    public void constructorStringResponseThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                NotAuthorizedException e = new NotAuthorizedException(MESSAGE, this.buildResponse(status), new Throwable());
                JAXRSClientIT.fault("IllegalArgumentException has not been thrown for status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected for status", status);
            }
        }
    }

    protected Response buildResponse(Response.Status status) {
        return Response.status((Response.Status)status).header("Host", (Object)HOST).build();
    }

    protected void assertResponse(WebApplicationException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response cobtains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertResponse(WebApplicationException e, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }

    protected void assertChallenges(NotAuthorizedException e) throws JAXRSCommonClient.Fault {
        List challenges = e.getChallenges();
        String list = JaxrsUtil.iterableToString(";", challenges);
        JAXRSClientIT.assertContains(list, CHALLENGE[0], new Object[]{"Challenge", CHALLENGE[0], "not found in", list});
        JAXRSClientIT.assertContains(list, CHALLENGE[1], new Object[]{"Challenge", CHALLENGE[1], "not found in", list});
        JAXRSClientIT.assertContains(list, CHALLENGE[2], new Object[]{"Challenge", CHALLENGE[2], "not found in", list});
    }

    protected void assertMessage(NotAuthorizedException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }
}

