/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.responseclient;

import ee.jakarta.tck.ws.rs.api.rs.core.responseclient.VerificationResult;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -2343034378084516380L;
    protected final Response.Status[] resp_status = new Response.Status[]{Response.Status.OK, Response.Status.CREATED, Response.Status.ACCEPTED, Response.Status.NO_CONTENT, Response.Status.RESET_CONTENT, Response.Status.PARTIAL_CONTENT, Response.Status.MULTIPLE_CHOICES, Response.Status.MOVED_PERMANENTLY, Response.Status.FOUND, Response.Status.SEE_OTHER, Response.Status.NOT_MODIFIED, Response.Status.USE_PROXY, Response.Status.TEMPORARY_REDIRECT, Response.Status.PERMANENT_REDIRECT, Response.Status.BAD_REQUEST, Response.Status.UNAUTHORIZED, Response.Status.PAYMENT_REQUIRED, Response.Status.FORBIDDEN, Response.Status.NOT_FOUND, Response.Status.METHOD_NOT_ALLOWED, Response.Status.NOT_ACCEPTABLE, Response.Status.PROXY_AUTHENTICATION_REQUIRED, Response.Status.REQUEST_TIMEOUT, Response.Status.CONFLICT, Response.Status.GONE, Response.Status.LENGTH_REQUIRED, Response.Status.PRECONDITION_FAILED, Response.Status.REQUEST_ENTITY_TOO_LARGE, Response.Status.REQUEST_URI_TOO_LONG, Response.Status.UNSUPPORTED_MEDIA_TYPE, Response.Status.REQUESTED_RANGE_NOT_SATISFIABLE, Response.Status.EXPECTATION_FAILED, Response.Status.PRECONDITION_REQUIRED, Response.Status.TOO_MANY_REQUESTS, Response.Status.REQUEST_HEADER_FIELDS_TOO_LARGE, Response.Status.UNAVAILABLE_FOR_LEGAL_REASONS, Response.Status.INTERNAL_SERVER_ERROR, Response.Status.NOT_IMPLEMENTED, Response.Status.BAD_GATEWAY, Response.Status.SERVICE_UNAVAILABLE, Response.Status.GATEWAY_TIMEOUT, Response.Status.HTTP_VERSION_NOT_SUPPORTED, Response.Status.NETWORK_AUTHENTICATION_REQUIRED};
    protected final int[] status_codes = new int[]{200, 201, 202, 204, 205, 206, 300, 301, 302, 303, 304, 305, 307, 308, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 428, 429, 431, 451, 500, 501, 502, 503, 504, 505, 511};
    protected final Response.Status.Family[] status_family = new Response.Status.Family[]{Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.SUCCESSFUL, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.REDIRECTION, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.CLIENT_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SERVER_ERROR};
    protected final Response.Status.Family[] status_family_list = new Response.Status.Family[]{Response.Status.Family.CLIENT_ERROR, Response.Status.Family.INFORMATIONAL, Response.Status.Family.OTHER, Response.Status.Family.REDIRECTION, Response.Status.Family.SERVER_ERROR, Response.Status.Family.SUCCESSFUL};
    protected final String[] status = new String[]{"OK", "Created", "Accepted", "No Content", "Reset Content", "Partial Content", "Multiple Choices", "Moved Permanently", "Found", "See Other", "Not Modified", "Use Proxy", "Temporary Redirect", "Permanent Redirect", "Bad Request", "Unauthorized", "Payment Required", "Forbidden", "Not Found", "Method Not Allowed", "Not Acceptable", "Proxy Authentication Required", "Request Timeout", "Conflict", "Gone", "Length Required", "Precondition Failed", "Request Entity Too Large", "Request-URI Too Long", "Unsupported Media Type", "Requested Range Not Satisfiable", "Expectation Failed", "Precondition Required", "Too Many Requests", "Request Header Fields Too Large", "Unavailable For Legal Reasons", "Internal Server Error", "Not Implemented", "Bad Gateway", "Service Unavailable", "Gateway Timeout", "HTTP Version Not Supported", "Network Authentication Required"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void okTest1() throws JAXRSCommonClient.Fault {
        Response response = null;
        int status = 200;
        response = Response.ok().build();
        VerificationResult result = this.verifyStatus(response, status);
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void okTest2() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 200;
        String content = "Test only";
        resp = Response.ok((Object)content).build();
        VerificationResult result = this.verifyContent(resp, content);
        result.append(this.verifyStatus(resp, status));
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void okTest3() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 200;
        String content = "Test only";
        String type = "text/plain";
        resp = Response.ok((Object)content, (String)type).build();
        VerificationResult result = this.verifyContent(resp, content);
        result.append(this.verifyStatus(resp, status));
        result.append(this.verifyContentType(resp, Collections.singletonList(type)));
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void okTest4() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 200;
        String content = "Test only";
        String type = "text/plain";
        MediaType mt = new MediaType(MediaType.TEXT_PLAIN_TYPE.getType(), MediaType.TEXT_PLAIN_TYPE.getSubtype());
        resp = Response.ok((Object)content, (MediaType)mt).build();
        VerificationResult result = this.verifyContent(resp, content);
        result.append(this.verifyStatus(resp, status));
        result.append(this.verifyContentType(resp, Collections.singletonList(type)));
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void okTest5() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        int status = 200;
        String content = "Test Only";
        List<String> encoding = Arrays.asList("gzip", "compress");
        MediaType mt = new MediaType("text", "plain");
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt);
        for (int i = 0; i < vts.size(); ++i) {
            Variant vt = vts.get(i);
            resp = Response.ok((Object)content, (Variant)vt).build();
            result.append(this.verifyContent(resp, content));
            result.append(this.verifyStatus(resp, status));
            result.append(this.verifyEncoding(resp, encoding));
            result.append(this.verifyLanguage(resp, JAXRSClientIT.getLangList()));
            result.append(this.verifyContentType(resp, Collections.singletonList(mt.toString())));
        }
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void noContentTest() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 204;
        resp = Response.noContent().build();
        VerificationResult result = this.verifyStatus(resp, status);
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void notAcceptableTest() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 406;
        List<String> encoding = Arrays.asList("gzip", "compress");
        MediaType mt = new MediaType("text", "plain");
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt);
        resp = Response.notAcceptable(vts).build();
        VerificationResult result = this.verifyStatus(resp, status);
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void notModifiedTest1() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 304;
        resp = Response.notModified().build();
        VerificationResult result = this.verifyStatus(resp, status);
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void notModifiedTest2() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 304;
        String tags = "TestOnly";
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("ETAG", tags);
        resp = Response.notModified((String)tags).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void notModifiedTest3() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 304;
        String value = "TestOnly";
        EntityTag et = new EntityTag(value);
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("ETAG", value);
        resp = Response.notModified((EntityTag)et).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest1() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        for (int status : this.status_codes) {
            resp = Response.status((int)status).build();
            result.append(this.verifyStatus(resp, status));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest2() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        for (int i = 0; i < this.status_codes.length; ++i) {
            resp = Response.status((Response.Status)this.resp_status[i]).build();
            result.append(this.verifyStatus(resp, this.status_codes[i]));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest3() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        for (int status : this.status_codes) {
            resp = Response.ok().status(status).build();
            result.append(this.verifyStatus(resp, status));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest4() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        for (int i = 0; i < this.status_codes.length; ++i) {
            resp = Response.ok().status(this.resp_status[i]).build();
            result.append(this.verifyStatus(resp, this.status_codes[i]));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void createdTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        List<String> uri_expected = Arrays.asList("mailto:java-net@java.sun.com", "news:comp.lang.java", "urn:isbn:096139210x", "http://java.sun.com/j2se/1.3/", "docs/guide/collections/designfaq.html#28", "../../../demo/jfc/SwingSet2/src/SwingSet2.java", "file:///~/calendar");
        URI test_uri = null;
        for (String uri_string : uri_expected) {
            try {
                test_uri = new URI(uri_string);
            }
            catch (URISyntaxException ex) {
                result.message.append("Unexpected exception thrown:").append(ex.getMessage());
                result.pass = false;
            }
            Response resp = Response.created((URI)test_uri).build();
            HashMap<String, String> expected_map = new HashMap<String, String>();
            expected_map.put("Location", uri_string);
            result.append(this.verifyStatus(resp, 201));
            result.append(this.verifyHeaders(resp, expected_map));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void serverErrorTest() throws JAXRSCommonClient.Fault {
        Response resp = Response.serverError().build();
        VerificationResult result = this.verifyStatus(resp, 500);
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void seeOtherTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        URI test_uri = null;
        try {
            test_uri = new URI("http://java.sun.com/j2se/1.3/");
        }
        catch (URISyntaxException ex) {
            result.message.append("Unexpected exception thrown:").append(ex.getMessage());
            result.pass = false;
        }
        Response resp = Response.seeOther((URI)test_uri).build();
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("Location", "http://java.sun.com/j2se/1.3/");
        result.append(this.verifyStatus(resp, 303));
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void temporaryRedirectTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        URI test_uri = null;
        try {
            test_uri = new URI("http://java.sun.com/j2se/1.3/");
        }
        catch (URISyntaxException ex) {
            result.message.append("Unexpected exception thrown:").append(ex.getMessage());
            result.pass = false;
        }
        Response resp = Response.temporaryRedirect((URI)test_uri).build();
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("Location", "http://java.sun.com/j2se/1.3/");
        result.append(this.verifyStatus(resp, 307));
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void fromResponseTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        String content = "Test Only";
        List<String> type = Arrays.asList("text/plain", "text/html");
        List<String> encoding = Arrays.asList("gzip", "compress");
        MediaType mt1 = new MediaType("text", "plain");
        MediaType mt2 = new MediaType("text", "html");
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt1, mt2);
        for (int i = 0; i < vts.size(); ++i) {
            Variant vt = vts.get(i);
            Response resp1 = Response.ok((Object)content, (Variant)vt).build();
            Response resp = Response.fromResponse((Response)resp1).build();
            result.append(this.verifyContent(resp, content));
            result.append(this.verifyStatus(resp, status));
            result.append(this.verifyEncoding(resp, encoding));
            result.append(this.verifyLanguage(resp, JAXRSClientIT.getLangList()));
            result.append(this.verifyContentType(resp, type));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void entityTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        String content = "Test Only";
        Response resp = Response.status((int)status).entity((Object)content).build();
        result.append(this.verifyContent(resp, content));
        result.append(this.verifyStatus(resp, status));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void languageTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        List<String> lang = JAXRSClientIT.getLangList();
        for (String language : lang) {
            Response resp = Response.status((int)status).language(language).build();
            result.append(this.verifyStatus(resp, status));
            result.append(this.verifyLanguage(resp, lang));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void languageTest1() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        for (String language : JAXRSClientIT.getLangList()) {
            Response resp = Response.status((int)status).language(language).build();
            result.append(this.verifyStatus(resp, status));
            result.append(this.verifyLanguage(resp, Arrays.asList(language)));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void typeTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        String type = "text/plain";
        Response resp = Response.status((int)status).type(type).build();
        result.append(this.verifyStatus(resp, status));
        result.append(this.verifyContentType(resp, Arrays.asList(type)));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void typeTest1() throws JAXRSCommonClient.Fault {
        int status = 200;
        List<String> types = Arrays.asList("text/plain", "text/html");
        MediaType mt1 = new MediaType("text", "plain");
        MediaType mt2 = new MediaType("text", "html");
        Response resp = Response.status((int)status).type(mt1).type(mt2).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyContentType(resp, types));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void tagTest1() throws JAXRSCommonClient.Fault {
        int status = 200;
        String tag = "TestOnly";
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("ETAG", tag);
        Response resp = Response.status((int)status).tag(tag).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void tagTest2() throws JAXRSCommonClient.Fault {
        int status = 200;
        EntityTag et1 = new EntityTag("StrongEntityTagTest", true);
        EntityTag et2 = new EntityTag("TestOnly", false);
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("ETAG", "TestOnly");
        Response resp = Response.status((int)status).tag(et1).tag(et2).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void variantTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response resp = null;
        int status = 200;
        List<String> encoding = Arrays.asList("gzip", "compress");
        MediaType mt = new MediaType("text", "plain");
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt);
        for (int i = 0; i < vts.size(); ++i) {
            Variant vt = vts.get(i);
            resp = Response.status((int)status).variant(vt).build();
            this.verifyStatus(resp, status);
            this.verifyEncoding(resp, encoding);
            this.verifyLanguage(resp, JAXRSClientIT.getLangList());
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void variantsTest() throws JAXRSCommonClient.Fault {
        Response resp = null;
        int status = 200;
        List<String> encoding = Arrays.asList("gzip", "compress");
        List<String> vars = Arrays.asList("accept-language", "accept-encoding");
        MediaType mt = new MediaType("text", "plain");
        List<Variant> vts = JAXRSClientIT.getVariantList(encoding, mt);
        resp = Response.status((int)status).variants(vts).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyVary(resp, vars));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void locationTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        List<String> uri_expected = Arrays.asList("mailto:java-net@java.sun.com", "news:comp.lang.java", "urn:isbn:096139210x", "http://java.sun.com/j2se/1.3/", "docs/guide/collections/designfaq.html#28", "../../../demo/jfc/SwingSet2/src/SwingSet2.java", "file:///~/calendar");
        URI test_uri = null;
        for (String uri_string : uri_expected) {
            try {
                test_uri = new URI(uri_string);
            }
            catch (URISyntaxException ex) {
                result.message.append("Unexpected exception thrown:").append(ex.getMessage());
                result.pass = false;
            }
            Response resp = Response.status((int)status).location(test_uri).build();
            HashMap<String, String> expected_map = new HashMap<String, String>();
            expected_map.put("Location", uri_string);
            result.append(this.verifyStatus(resp, status));
            result.append(this.verifyHeaders(resp, expected_map));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void contentLocationTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int status = 200;
        List<String> uri_expected = Arrays.asList("mailto:java-net@java.sun.com", "news:comp.lang.java", "urn:isbn:096139210x", "http://java.sun.com/j2se/1.3/", "docs/guide/collections/designfaq.html#28", "../../../demo/jfc/SwingSet2/src/SwingSet2.java", "file:///~/calendar");
        URI test_uri = null;
        for (String uri_string : uri_expected) {
            try {
                test_uri = new URI(uri_string);
            }
            catch (URISyntaxException ex) {
                result.message.append("Unexpected exception thrown:").append(ex.getMessage());
                result.pass = false;
            }
            Response resp = Response.status((int)status).contentLocation(test_uri).build();
            HashMap<String, String> expected_map = new HashMap<String, String>();
            expected_map.put("Content-Location", uri_string);
            result.append(this.verifyStatus(resp, 200));
            result.append(this.verifyHeaders(resp, expected_map));
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void cacheControlTest() throws JAXRSCommonClient.Fault {
        int status = 200;
        boolean nostore = true;
        CacheControl ccl4 = new CacheControl();
        ccl4.setNoStore(nostore);
        List<String> ccl = Arrays.asList("no-store", "no-transform");
        Response resp = Response.status((int)status).cacheControl(ccl4).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyCacheControl(resp, ccl));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void cookieTest() throws JAXRSCommonClient.Fault {
        int status = 200;
        String name = "name_1";
        String value = "value_1";
        Cookie ck1 = new Cookie(name, value);
        NewCookie nck1 = new NewCookie(ck1);
        name = "name_2";
        value = "value_2";
        String path = "/acme";
        String domain = "";
        Cookie ck2 = new Cookie(name, value, path, domain);
        NewCookie nck2 = new NewCookie(ck2);
        name = "name_3";
        value = "value_3";
        path = "";
        domain = "y.x.foo.com";
        Cookie ck3 = new Cookie(name, value, path, domain);
        NewCookie nck3 = new NewCookie(ck3);
        List<String> cookies = Arrays.asList(nck1.toString().toLowerCase(), nck2.toString().toLowerCase(), nck3.toString().toLowerCase());
        Response resp = Response.status((int)status).cookie(new NewCookie[]{nck1, nck2, nck3}).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyCookies(resp, cookies));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void lastModifiedTest() throws JAXRSCommonClient.Fault {
        int status = 200;
        long dt = 123456789L;
        Date date = new Date(dt);
        HashMap<String, String> expected_map = new HashMap<String, String>();
        expected_map.put("Last-Modified", "123456789");
        Response resp = Response.status((int)status).lastModified(date).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyHeaders(resp, expected_map));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void headerTest() throws JAXRSCommonClient.Fault {
        int status = 200;
        List<String> type = Arrays.asList("text/plain", "text/html");
        List<String> encoding = Arrays.asList("gzip", "compress");
        String name = "name_1";
        String value = "value_1";
        Cookie ck1 = new Cookie(name, value);
        NewCookie nck1 = new NewCookie(ck1);
        List<String> cookies = Arrays.asList(nck1.toString().toLowerCase());
        Response resp = Response.status((int)status).header("Content-Encoding", (Object)encoding.get(0)).header("Content-Encoding", (Object)encoding.get(1)).header("Content-Language", (Object)"en-US").header("Content-Language", (Object)"en-GB").header("Content-Language", (Object)"zh-CN").header("Cache-Control", (Object)"no-transform").header("Set-Cookie", (Object)"name_1=value_1;version=1").header("Content-Type", (Object)type.get(0)).header("Content-Type", (Object)type.get(1)).build();
        VerificationResult result = this.verifyStatus(resp, status);
        result.append(this.verifyEncoding(resp, encoding));
        result.append(this.verifyLanguage(resp, JAXRSClientIT.getLangList()));
        result.append(this.verifyContentType(resp, type));
        result.append(this.verifyCookies(resp, cookies));
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void cloneTest() throws JAXRSCommonClient.Fault {
        int status = 200;
        List<String> type = Arrays.asList("text/plain", "text/html");
        List<String> encoding = Arrays.asList("gzip");
        List<String> lang = JAXRSClientIT.getLangList();
        String name = "name_1";
        String value = "value_1";
        Cookie ck1 = new Cookie(name, value);
        NewCookie nck1 = new NewCookie(ck1);
        List<String> cookies = Arrays.asList(nck1.toString().toLowerCase());
        Response.ResponseBuilder respb1 = Response.status((int)status).header("Content-type", (Object)"text/plain").header("Content-type", (Object)"text/html").header("Content-Language", (Object)"en-US").header("Content-Language", (Object)"en-GB").header("Content-Language", (Object)"zh-CN").header("Cache-Control", (Object)"no-transform").header("Set-Cookie", (Object)"name_1=value_1;version=1").header("Content-Encoding", (Object)"gzip");
        Response.ResponseBuilder respb2 = respb1.clone();
        Response resp2 = respb2.build();
        VerificationResult result = this.verifyStatus(resp2, status);
        result.append(this.verifyEncoding(resp2, encoding));
        result.append(this.verifyLanguage(resp2, lang));
        result.append(this.verifyContentType(resp2, type));
        result.append(this.verifyCookies(resp2, cookies));
        String content = "TestOnly";
        Response resp1 = respb1.entity((Object)content).cookie((NewCookie[])null).build();
        result.append(this.verifyContent(resp1, content));
        result.append(this.verifyStatus(resp1, status));
        result.append(this.verifyEncoding(resp1, encoding));
        result.append(this.verifyLanguage(resp1, lang));
        result.append(this.verifyContentType(resp1, type));
        MultivaluedMap mvp = resp1.getMetadata();
        if (mvp.containsKey((Object)"Set-Cookie")) {
            result.pass = false;
            result.message.append("Response contains unexpected Set-Cookie: ").append(mvp.getFirst((Object)"Set-Cookie").toString()).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest5() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response.Status tmp = null;
        for (int i = 0; i < this.status_codes.length; ++i) {
            tmp = Response.Status.fromStatusCode((int)this.status_codes[i]);
            if (tmp == this.resp_status[i]) continue;
            result.pass = false;
            result.message.append("fromStatusCode[").append(this.status_codes[i]).append("] failed with ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void getFamilyTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response.Status.Family tmp = null;
        Assertions.assertTrue((this.status_family.length == Response.Status.values().length ? 1 : 0) != 0, (String)"Response.Status.values() are unexpected");
        for (int i = 0; i < this.status_family.length; ++i) {
            tmp = this.resp_status[i].getFamily();
            if (tmp == this.status_family[i]) continue;
            result.pass = false;
            result.message.append("getFamily failed with ").append(this.resp_status[i]).append(" ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusTest7() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        int tmp = 0;
        for (int i = 0; i < this.status_codes.length; ++i) {
            tmp = this.resp_status[i].getStatusCode();
            if (tmp == this.status_codes[i]) continue;
            result.pass = false;
            result.message.append("getStatusCode() failed with ").append(this.resp_status[i]).append(newline);
            result.message.append("expecting ").append(this.status_codes[i]).append(", got ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        String tmp = null;
        for (int i = 0; i < this.resp_status.length; ++i) {
            tmp = this.resp_status[i].toString();
            if (tmp.equals(this.status[i])) continue;
            result.pass = false;
            result.message.append("Status.toString() failed with ").append(this.resp_status[i]).append(newline);
            result.message.append("expecting ").append(this.status[i]).append(", got ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void getReasonPhraseTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        String tmp = null;
        Assertions.assertTrue((this.status.length == Response.Status.values().length ? 1 : 0) != 0, (String)"Response.Status.values() are unexpected");
        for (int i = 0; i < this.resp_status.length; ++i) {
            tmp = this.resp_status[i].getReasonPhrase();
            if (tmp.equals(this.status[i])) continue;
            result.pass = false;
            result.message.append("Status.toString() failed with ").append(this.resp_status[i]).append(newline);
            result.message.append("expecting ").append(this.status[i]).append(", got ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusValueOfTest() throws JAXRSCommonClient.Fault {
        VerificationResult result = new VerificationResult();
        Response.Status tmp = null;
        for (int i = 0; i < this.resp_status.length; ++i) {
            try {
                tmp = Response.Status.valueOf((String)this.status[i].replace(" ", "_").replace("-", "_").toUpperCase());
            }
            catch (Exception ex) {
                result.message.append("Exception thrown with status name ").append(this.status[i]).append(newline);
                result.message.append(ex.getMessage());
                result.pass = false;
            }
            if (tmp.equals((Object)this.resp_status[i])) continue;
            result.pass = false;
            result.message.append("Status.toString() failed with ").append(this.resp_status[i]).append(newline);
            result.message.append("expecting ").append(this.resp_status[i]).append(", got ").append(tmp).append(newline);
        }
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void statusFamilyValueOfTest() throws JAXRSCommonClient.Fault {
        Response.Status.Family[] families = Response.Status.Family.values();
        Assertions.assertTrue((families.length == this.status_family_list.length ? 1 : 0) != 0, (String)"Response.Status.Family.values() are unexpected");
        Arrays.sort(this.status_family_list);
        for (int i = 0; i != families.length; ++i) {
            int match = Arrays.binarySearch(this.status_family_list, Response.Status.Family.valueOf((String)families[i].name()));
            Assertions.assertTrue((match != -1 ? 1 : 0) != 0, (String)("Unknown Response Status Family" + families[i]));
        }
    }

    @Test
    public void statusFamilyValuesTest() throws JAXRSCommonClient.Fault {
        Response.Status.Family[] families = Response.Status.Family.values();
        Assertions.assertTrue((families.length == this.status_family_list.length ? 1 : 0) != 0, (String)"Response.Status.Family.values() are unexpected");
        Arrays.sort(this.status_family_list);
        for (int i = 0; i != families.length; ++i) {
            int match = Arrays.binarySearch(this.status_family_list, families[i]);
            Assertions.assertTrue((match != -1 ? 1 : 0) != 0, (String)("Unknown Resposne Status Family" + families[i]));
        }
    }

    @Test
    public void acceptedNoArgTest() throws JAXRSCommonClient.Fault {
        Response response = null;
        response = Response.accepted().build();
        VerificationResult result = this.verifyStatus(response, Response.Status.ACCEPTED.getStatusCode());
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void acceptedStringTest() throws JAXRSCommonClient.Fault {
        String entity = "ENtiTy";
        Response response = null;
        response = Response.accepted((Object)entity).build();
        VerificationResult result = this.verifyStatus(response, Response.Status.ACCEPTED.getStatusCode());
        result.append(this.verifyContent(response, entity));
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void acceptedGenericEntityTest() throws JAXRSCommonClient.Fault {
        String entity = "ENtiTy";
        GenericEntity generic = new GenericEntity((Object)entity, String.class);
        Response response = Response.accepted((Object)generic).build();
        VerificationResult result = this.verifyStatus(response, Response.Status.ACCEPTED.getStatusCode());
        result.append(this.verifyContent(response, entity));
        JAXRSClientIT.logMsg(result.message);
        JAXRSClientIT.assertResultTrue(result);
    }

    @Test
    public void bufferEntityIgnoreNoBackingStreamTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        boolean result = response.bufferEntity();
        Assertions.assertTrue((!result ? 1 : 0) != 0, (String)"#bufferEntity() did not ignore no backing stream");
        JAXRSClientIT.logMsg("#bufferEntity did ignore no backing stream as expected");
    }

    @Test
    public void bufferEntityThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        response.close();
        try {
            response.bufferEntity();
            JAXRSClientIT.fault("buffer entity did not throw IllegalStateException when closed");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#bufferEntity throws IllegalStateException as expected");
        }
    }

    @Test
    public void getAllowedMethodsTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().header("Allow", (Object)JAXRSCommonClient.Request.POST.name()).header("Allow", (Object)JAXRSCommonClient.Request.TRACE.name()).build();
        Set set = response.getAllowedMethods();
        String methods = JaxrsUtil.iterableToString(";", set);
        JAXRSClientIT.assertContainsIgnoreCase(methods, JAXRSCommonClient.Request.POST.name(), new Object[]{JAXRSCommonClient.Request.POST.name(), "method has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(methods, JAXRSCommonClient.Request.TRACE.name(), new Object[]{JAXRSCommonClient.Request.TRACE.name(), "method has not been found"});
        Assertions.assertTrue((methods.length() < JAXRSCommonClient.Request.TRACE.name().length() + JAXRSCommonClient.Request.POST.name().length() + 3 ? 1 : 0) != 0, (String)("Request contains some additional methods then expected" + methods));
        JAXRSClientIT.logMsg("#getAllowedMethods returned expected methods", methods);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        NewCookie cookie1 = new NewCookie("c1", "v1");
        NewCookie cookie2 = new NewCookie("c2", "v2");
        List<String> cookies = Arrays.asList(cookie1.toString().toLowerCase(), cookie2.toString().toLowerCase());
        Response response = Response.ok().cookie(new NewCookie[]{cookie1}).cookie(new NewCookie[]{cookie2}).build();
        VerificationResult result = this.verifyCookies(response, cookies);
        JAXRSClientIT.logMsg(result);
        JAXRSClientIT.assertResultTrue(result);
        Map map = response.getCookies();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equals("c1")) {
                Assertions.assertTrue((boolean)((NewCookie)entry.getValue()).equals((Object)cookie1), (String)(cookie1.toString() + "not match" + entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).equals("c2")) {
                Assertions.assertTrue((boolean)((NewCookie)entry.getValue()).equals((Object)cookie2), (String)(cookie2.toString() + "not match" + entry.getValue()));
                continue;
            }
            Assertions.assertTrue((boolean)false, (String)("Got unknown cookie" + (String)entry.getKey()));
        }
        JAXRSClientIT.logMsg("#getCookies returned expected cookies");
    }

    @Test
    public void getCookiesIsImmutableTest() throws JAXRSCommonClient.Fault {
        Map map;
        NewCookie cookie1 = new NewCookie("c1", "v1");
        NewCookie cookie2 = new NewCookie("c2", "v2");
        Response response = Response.ok().cookie(new NewCookie[]{cookie1}).build();
        try {
            map = response.getCookies();
            map.put("c2", cookie2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        map = response.getCookies();
        Assertions.assertTrue((!map.containsKey("c2") ? 1 : 0) != 0, (String)("getCookies is not read-only returned" + map.get("c2")));
        JAXRSClientIT.logMsg("#getCookies is read-only as expected");
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        Date date = Calendar.getInstance().getTime();
        Response response = Response.ok().header("Date", (Object)date).build();
        Date responseDate = response.getDate();
        Assertions.assertTrue((boolean)date.equals(responseDate), (String)("Original date" + date + "and response#getDate()" + responseDate + "differs"));
        JAXRSClientIT.logMsg("#getDate matches the Date HTTP header");
    }

    @Test
    public void getDateNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Date responseDate = response.getDate();
        Assertions.assertTrue((responseDate == null ? 1 : 0) != 0, (String)("response#getDate() should be null, was" + responseDate));
        JAXRSClientIT.logMsg("#getDate is null as expected");
    }

    @Test
    public void getEntityThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok((Object)"entity").build();
        response.close();
        try {
            response.getEntity();
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("#getEntity throws IllegalStateException as expected", e);
        }
    }

    @Test
    public void getEntityTagTest() throws JAXRSCommonClient.Fault {
        EntityTag tag = new EntityTag("getEntityTag");
        Response response = Response.notModified((EntityTag)tag).build();
        EntityTag responseTag = response.getEntityTag();
        Assertions.assertTrue((boolean)tag.equals((Object)responseTag), (String)("response#getEntityTag()" + responseTag + "is unequal to expected EntityTag" + tag));
        JAXRSClientIT.logMsg("#getEntityTag is", responseTag, "as expected");
    }

    @Test
    public void getEntityTagNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        EntityTag responseTag = response.getEntityTag();
        Assertions.assertTrue((responseTag == null ? 1 : 0) != 0, (String)("response#getEntityTag() should be null, was" + responseTag));
        JAXRSClientIT.logMsg("#getEntityTag() is null as expected");
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        CacheControl ccl = new CacheControl();
        NewCookie cookie = new NewCookie("cookie", "eikooc");
        String encoding = "gzip";
        Date date = Calendar.getInstance().getTime();
        Response response = Response.ok().cacheControl(ccl).cookie(new NewCookie[]{cookie}).encoding(encoding).expires(date).language(Locale.CANADA_FRENCH).build();
        JAXRSClientIT.logMsg("Found following objects:");
        JAXRSClientIT.logMsg(JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)response.getHeaders()));
        MultivaluedMap headers = response.getHeaders();
        String header = null;
        header = headers.getFirst((Object)"Cache-Control").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "no-transform", new Object[]{"Cache-Control:no-transform has not been found"});
        header = headers.getFirst((Object)"Set-Cookie").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "cookie=eikooc", new Object[]{"Set-Cookie:cookie=eikooc has not been found"});
        header = headers.getFirst((Object)"Content-Encoding").toString();
        JAXRSClientIT.assertContainsIgnoreCase(header, "gzip", new Object[]{"Content-Encoding:gzip has not been found"});
        header = headers.getFirst((Object)"Expires").toString();
        JAXRSClientIT.assertNotNull(header, "Expires has not been found");
        header = headers.getFirst((Object)"Content-Language").toString();
        JAXRSClientIT.assertContainsIgnoreCase(JAXRSClientIT.langToString(header), JAXRSClientIT.langToString(Locale.CANADA_FRENCH), new Object[]{"Content-Language:", JAXRSClientIT.langToString(Locale.CANADA_FRENCH), "has not been found"});
        Object noHeader = headers.getFirst((Object)"unknown");
        JAXRSClientIT.assertNull(noHeader, "Unknown header has been found", header);
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        String header = "header";
        Response response = Response.ok().build();
        MultivaluedMap headers = response.getHeaders();
        Object value = headers.getFirst((Object)header);
        JAXRSClientIT.assertNull(value, "Unexpected header", header, ":", value);
        headers.add((Object)header, (Object)header);
        headers = response.getHeaders();
        value = headers.getFirst((Object)header);
        JAXRSClientIT.assertContainsIgnoreCase(value, header, "Unexpected header value", header, ":", value);
        JAXRSClientIT.logMsg("getHeaders is mutable");
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        CacheControl ccl = new CacheControl();
        ccl.setNoStore(true);
        NewCookie cookie = new NewCookie("cookie", "eikooc");
        String encoding = "gzip";
        Date date = Calendar.getInstance().getTime();
        Response response = Response.ok().cacheControl(ccl).cookie(new NewCookie[]{cookie}).encoding(encoding).expires(date).language(Locale.CANADA_FRENCH).build();
        JAXRSClientIT.logMsg("Found following objects:");
        JAXRSClientIT.logMsg(JaxrsCommonClient.getMetadata((MultivaluedMap<String, Object>)response.getHeaders()));
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Cache-Control"), "no-store", new Object[]{"Cache-Control:no-store has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Cache-Control"), "no-transform", new Object[]{"Cache-Control:no-transform has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Set-Cookie"), "cookie=eikooc", new Object[]{"Set-Cookie:cookie=eikooc has not been found"});
        JAXRSClientIT.assertContainsIgnoreCase(response.getHeaderString("Content-Encoding"), "gzip", new Object[]{"Content-Encoding:gzip has not been found"});
        JAXRSClientIT.assertNotNull(response.getHeaderString("Expires"), "Expires has not been found");
        JAXRSClientIT.assertContainsIgnoreCase(JAXRSClientIT.langToString(response.getHeaderString("Content-Language")), JAXRSClientIT.langToString(Locale.CANADA_FRENCH), new Object[]{"Content-Language:", JAXRSClientIT.langToString(Locale.CANADA_FRENCH), "has not been found"});
        JAXRSClientIT.assertNull(response.getHeaderString("unknown"), "Unknown header has been found", response.getHeaderString("unknown"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getHeaderStringUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        StringBean bean = new StringBean("s3");
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new StringBeanRuntimeDelegate(original));
        try {
            Response response = Response.ok().header(bean.get(), (Object)bean).build();
            String header = response.getHeaderString(bean.get());
            JAXRSClientIT.assertContainsIgnoreCase(header, bean.get(), new Object[]{"Header", bean.get(), "has unexpected value", header});
            JAXRSClientIT.logMsg("HeaderDelegate is used for header", bean.get());
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    @Test
    public void getHeaderStringUsingToStringTest() throws JAXRSCommonClient.Fault {
        StringBuilder builder = new StringBuilder("s1");
        StringBuffer buffer = new StringBuffer("s2");
        Response response = Response.ok().header(builder.toString(), (Object)builder).header(buffer.toString(), (Object)buffer).build();
        String header = response.getHeaderString(builder.toString());
        JAXRSClientIT.assertContainsIgnoreCase(header, builder.toString(), new Object[]{"Header", builder, "has unexpected value", header});
        header = response.getHeaderString(buffer.toString());
        JAXRSClientIT.assertContainsIgnoreCase(header, buffer.toString(), new Object[]{"Header", builder, "has unexpected value", header});
        JAXRSClientIT.logMsg("toString method is used as expected");
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().language(Locale.CANADA_FRENCH).build();
        Locale locale = response.getLanguage();
        Assertions.assertTrue((boolean)Locale.CANADA_FRENCH.equals(locale), (String)("Locale" + Locale.CANADA_FRENCH + "does NOT match response#getLocale()" + locale));
        JAXRSClientIT.logMsg("#getLocale matches the Content-Language HTTP header");
    }

    @Test
    public void getLanguageNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Locale locale = response.getLanguage();
        Assertions.assertTrue((locale == null ? 1 : 0) != 0, (String)("response#getLanguage() should be null, was" + locale));
        JAXRSClientIT.logMsg("#getLanguage() is null as expected");
    }

    @Test
    public void getLastModifiedTest() throws JAXRSCommonClient.Fault {
        Date date = Calendar.getInstance().getTime();
        Response response = Response.ok().lastModified(date).build();
        Date responseDate = response.getLastModified();
        Assertions.assertTrue((boolean)date.equals(responseDate), (String)("Last Modified date" + date + "does NOT match response#getLastModified()" + responseDate));
        JAXRSClientIT.logMsg("#getLastModified matches the Last-Modified HTTP header");
    }

    @Test
    public void getLastModifiedNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Date responseDate = response.getLastModified();
        Assertions.assertTrue((responseDate == null ? 1 : 0) != 0, (String)("response#getLastModified() should be null, was" + responseDate));
        JAXRSClientIT.logMsg("#getLastModified() is null as expected");
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok((Object)"1234567890").header("Content-Length", (Object)"10").build();
        int len = response.getLength();
        Assertions.assertTrue((len > 9 ? 1 : 0) != 0, (String)("Expected Content-Length > 9does NOT match response#getLength()" + len));
        JAXRSClientIT.logMsg("#getLength matches expected Content-Length", len);
    }

    @Test
    public void getLengthNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        int len = response.getLength();
        Assertions.assertTrue((len == -1 ? 1 : 0) != 0, (String)("Expected Content-Length = -1does NOT match response#getLength()" + len));
        JAXRSClientIT.logMsg("#getLength matches expected Content-Length", len);
    }

    @Test
    public void getLinkTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.createLink("path", "getLinkTest");
        Response response = Response.ok().links(new Link[]{link}).build();
        Link responseLink = response.getLink("getLinkTest");
        Assertions.assertTrue((boolean)link.equals(responseLink), (String)("#getLink() returned unexpected Link" + responseLink));
        JAXRSClientIT.logMsg("#getLink matches expected Link");
    }

    @Test
    public void getLinkNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Link responseLink = response.getLink("getLinkTest");
        Assertions.assertTrue((responseLink == null ? 1 : 0) != 0, (String)("#getLink() returned unexpected Link" + responseLink));
        JAXRSClientIT.logMsg("#getLink return null as expected");
    }

    @Test
    public void getLinkBuilderForTheRelationTest() throws JAXRSCommonClient.Fault {
        String rel = "anyrelation";
        Response response = Response.ok().link("http://abc.com/b/", rel).build();
        Link builderLink = response.getLinkBuilder("anyrelation").build(new Object[0]);
        response = Response.ok().links(new Link[]{builderLink}).build();
        Link responseLink = response.getLink("anyrelation");
        JAXRSClientIT.assertNotNull(responseLink, "#getLinkBuilder('relation') returned null");
        JAXRSClientIT.logMsg("#getLinkBuilder creates correct Link for given relation");
    }

    @Test
    public void getLinkBuilderForTheNotPresentRelationTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Link.Builder builder = response.getLinkBuilder("anyrelation");
        Assertions.assertTrue((builder == null ? 1 : 0) != 0, (String)("#getLinkBuilder('relation') returned unexpected builder" + builder));
        JAXRSClientIT.logMsg("#getLinkBuilder returned null as expected");
    }

    @Test
    public void getLinksTest() throws JAXRSCommonClient.Fault {
        Link link1 = JAXRSClientIT.createLink("path1", "rel1");
        Link link2 = JAXRSClientIT.createLink("path2", "rel2");
        Response response = Response.ok().links(new Link[]{link1, link2}).build();
        Set responseLinks = response.getLinks();
        JAXRSClientIT.assertEqualsInt(responseLinks.size(), 2, "#getLinks() returned set of unexpected size", responseLinks.size());
        Assertions.assertTrue((boolean)responseLinks.contains(link1), (String)("#getLinks does not contain" + link1));
        Assertions.assertTrue((boolean)responseLinks.contains(link2), (String)("#getLinks does not contain" + link2));
        JAXRSClientIT.logMsg("#getLinks contains expected links");
    }

    @Test
    public void getLinksIsNotNullTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Set responseLinks = response.getLinks();
        Assertions.assertTrue((responseLinks != null ? 1 : 0) != 0, (String)"#getLinks() returned null!");
        Assertions.assertTrue((responseLinks.size() == 0 ? 1 : 0) != 0, (String)"#getLinks() returned non-empty map!");
        JAXRSClientIT.logMsg("#getLinks contains no links as expected");
    }

    @Test
    public void getLocationTest() throws JAXRSCommonClient.Fault {
        URI location = JAXRSClientIT.createUri("path");
        Response response = Response.ok().location(location).build();
        URI responseLocation = response.getLocation();
        Assertions.assertTrue((boolean)responseLocation.equals(location), (String)("#getLocation()" + responseLocation + "differs from expected" + location));
        JAXRSClientIT.logMsg("#getLocation contains expected location");
    }

    @Test
    public void getLocationNotPresentTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        URI responseLocation = response.getLocation();
        Assertions.assertTrue((responseLocation == null ? 1 : 0) != 0, (String)("#getLocation()" + responseLocation + "should be null"));
        JAXRSClientIT.logMsg("#getLocation returns null as expected");
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().type("application/atom+xml").build();
        MediaType responseMedia = response.getMediaType();
        Assertions.assertTrue((boolean)MediaType.APPLICATION_ATOM_XML_TYPE.equals((Object)responseMedia), (String)("#getMediaType()" + responseMedia + "differs from expectedapplication/atom+xml"));
        JAXRSClientIT.logMsg("#getMediaType returned expected MediaType");
    }

    @Test
    public void getMediaTypeNoMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        MediaType responseMedia = response.getMediaType();
        Assertions.assertTrue((responseMedia == null ? 1 : 0) != 0, (String)("#getMediaType()" + responseMedia + "should be null"));
        JAXRSClientIT.logMsg("#getMediaType returned null as expected");
    }

    @Test
    public void getStatusInfoTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            Response response = Response.status((Response.Status)status).build();
            Response.StatusType info = response.getStatusInfo();
            Assertions.assertTrue((info.getStatusCode() == status.getStatusCode() ? 1 : 0) != 0, (String)("#getStatusInfo returned unexpected value" + info));
        }
        JAXRSClientIT.logMsg("#getStatusInfo returned expected StatusTypes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getStringHeadersUsingToStringTest() throws JAXRSCommonClient.Fault {
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new StringBeanRuntimeDelegate(original));
        try {
            StringBuilder builder = new StringBuilder("s1");
            StringBuffer buffer = new StringBuffer("s2");
            StringBean bean = new StringBean("s3");
            Response response = Response.ok().header(builder.toString(), (Object)builder).header(buffer.toString(), (Object)buffer).header(bean.get(), (Object)bean).build();
            MultivaluedMap headers = response.getStringHeaders();
            String header = (String)headers.getFirst((Object)builder.toString());
            JAXRSClientIT.assertContainsIgnoreCase(header, builder.toString(), new Object[]{"Header", builder, "has unexpected value", header});
            header = (String)headers.getFirst((Object)buffer.toString());
            JAXRSClientIT.assertContainsIgnoreCase(header, buffer.toString(), new Object[]{"Header", builder, "has unexpected value", header});
            JAXRSClientIT.logMsg("#getStringHeaders contains expected values", JaxrsUtil.iterableToString(",", headers.entrySet()));
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getStringHeadersUsingHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        RuntimeDelegate.setInstance((RuntimeDelegate)new StringBeanRuntimeDelegate(original));
        try {
            StringBuilder builder = new StringBuilder("s1");
            StringBuffer buffer = new StringBuffer("s2");
            StringBean bean = new StringBean("s3");
            Response response = Response.ok().header(builder.toString(), (Object)builder).header(buffer.toString(), (Object)buffer).header(bean.get(), (Object)bean).build();
            MultivaluedMap headers = response.getStringHeaders();
            String header = (String)headers.getFirst((Object)bean.get());
            JAXRSClientIT.assertContainsIgnoreCase(bean.get(), header, new Object[]{"Header", bean.get(), "has unexpected value", header});
            JAXRSClientIT.logMsg("#getStringHeaders contains expected values", JaxrsUtil.iterableToString(",", headers.entrySet()));
        }
        finally {
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
            StringBeanRuntimeDelegate.assertNotStringBeanRuntimeDelegate();
        }
    }

    @Test
    public void hasEntityWhenEntityTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok((Object)"entity").build();
        Assertions.assertTrue((boolean)response.hasEntity(), (String)"#hasEntity did not found the entity");
        JAXRSClientIT.logMsg("#hasEntity found the entity as expected");
    }

    @Test
    public void hasEntityWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Assertions.assertTrue((!response.hasEntity() ? 1 : 0) != 0, (String)"#hasEntity did found the entity");
        JAXRSClientIT.logMsg("#hasEntity has not found any entity as expected");
    }

    @Test
    public void hasEntityThrowsIllegalStateExceptionTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        response.close();
        try {
            response.hasEntity();
            JAXRSClientIT.fault("No exception has been thrown");
        }
        catch (IllegalStateException e) {
            JAXRSClientIT.logMsg("IllegalStateException has been thrown as expected");
        }
    }

    @Test
    public void hasLinkWhenLinkTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.createLink("path", "rel");
        Response response = Response.ok().links(new Link[]{link}).build();
        Assertions.assertTrue((boolean)response.hasLink("rel"), (String)"#hasLink did not found a Link");
        JAXRSClientIT.logMsg("#hasEntity found the Link as expected");
    }

    @Test
    public void hasLinkWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        Response response = Response.ok().build();
        Assertions.assertTrue((!response.hasLink("rel") ? 1 : 0) != 0, (String)"#has Link did found some Link");
        JAXRSClientIT.logMsg("#hasLink has not found any Link as expected");
    }

    protected VerificationResult verifyContent(Response response, String content) {
        VerificationResult result = new VerificationResult();
        if (content == null || content == "") {
            if (response.getEntity() != null || response.getEntity().equals("")) {
                result.pass = false;
                result.message.append("    ").append("Entity verification failed: expecting no content, got ").append(response.getEntity()).append(newline);
            }
        } else if (!content.equals(response.getEntity())) {
            result.pass = false;
            result.message.append("    ").append("Entity verification failed: expecting ").append(content).append(", got ").append(response.getEntity()).append(newline);
        } else {
            result.message.append("    ").append("Correct content found in Response: ").append(response.getEntity()).append(newline);
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyStatus(Response response, int status) {
        VerificationResult result = new VerificationResult();
        if (response.getStatus() != status) {
            result.pass = false;
            result.message.append("    ").append("Status code verification failed: expecting ").append(status).append(", got ").append(response.getStatus()).append(newline);
        } else {
            result.message.append("    ").append("Correct status found in Response: ").append(status).append(newline);
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyHeaders(Response response, HashMap<String, String> expected) {
        MultivaluedMap headers = response.getMetadata();
        VerificationResult result = new VerificationResult();
        result.message.append("========== Verifying a Response with Map: ").append(newline);
        for (String key_actual : headers.keySet()) {
            result.message.append("    ").append("Response contains key: ").append(key_actual).append(newline);
        }
        result.message.append("    ").append("Verifying the following keys in Response:").append(newline);
        for (Map.Entry<String, String> entry : expected.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!headers.containsKey((Object)key)) {
                result.pass = false;
                result.message.append("    ").append("    ").append("Key: ").append(key).append(" is not found in Response;").append(newline);
                continue;
            }
            if (key.equalsIgnoreCase("last-modified")) {
                result.message.append("    ").append("    ").append("Key Last-Modified is found in response").append(newline);
                continue;
            }
            String actual = headers.getFirst((Object)key).toString().toLowerCase();
            if (actual.startsWith("\"") && actual.endsWith("\"")) {
                actual = actual.substring(1, actual.length() - 1);
            }
            if (!actual.equalsIgnoreCase(value)) {
                result.pass = false;
                result.message.append("    ").append("    ");
                result.message.append("Key: ").append(key);
                result.message.append(" found in Response, but with different value;").append(newline);
                result.message.append("    ").append("    ").append("Expecting ").append(value).append("; got ").append(headers.getFirst((Object)key)).append(newline);
            }
            result.message.append("    ").append("    ").append("Processed key ").append(key).append(" with expected value ").append(value).append(newline);
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyEncoding(Response response, List<String> encoding) {
        VerificationResult result = new VerificationResult();
        List enc = (List)response.getHeaders().get((Object)"Content-Encoding");
        if (enc == null) {
            result.pass = false;
            result.message.append("Content-Encoding").append(" headers is null").append(newline);
            result.message.append("Headers :").append(response.getHeaders()).append(newline);
        } else {
            for (Object e : enc) {
                if (!encoding.contains(e.toString().toLowerCase())) {
                    result.pass = false;
                    result.message.append("    ").append("    ").append("Encoding ").append(e).append(" was not found in headers").append(response.getHeaders()).append(newline);
                    continue;
                }
                result.message.append("    ").append("Encoding ").append(e).append(" was found").append(newline);
            }
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyLanguage(Response response, List<String> languages) {
        VerificationResult result = new VerificationResult();
        List responseLangs = (List)response.getHeaders().get((Object)"Content-Language");
        if (responseLangs == null) {
            result.pass = false;
            result.message.append("Content-Language").append(" headers is null").append(newline);
            result.message.append("Headers :").append(response.getHeaders()).append(newline);
        } else {
            String lang = JAXRSClientIT.langToString(JaxrsUtil.iterableToString(" ", languages)).toLowerCase();
            for (Object responseLang : responseLangs) {
                if (!lang.contains(JAXRSClientIT.langToString(responseLang).toLowerCase())) {
                    result.pass = false;
                    result.message.append("    ").append("    ").append("language test failed: ").append(responseLang).append(" is not expected in Response").append(response.getHeaders()).append(newline);
                    for (String tt : languages) {
                        result.message.append("    ").append("    ").append("Expecting Content-Language ").append(tt).append(newline);
                    }
                    continue;
                }
                result.message.append("    ").append("Content Language ").append(lang).append(" was found").append(newline);
            }
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyContentType(Response response, List<String> type) {
        VerificationResult result = new VerificationResult();
        List enc = (List)response.getHeaders().get((Object)"Content-Type");
        if (enc == null) {
            result.pass = false;
            result.message.append("Content-Type").append(" headers is null").append(newline);
            result.message.append("Headers :").append(response.getHeaders()).append(newline);
        } else {
            for (Object e : enc) {
                if (!type.contains(e.toString().toLowerCase())) {
                    result.pass = false;
                    result.message.append("    ").append("    ").append("Content-Type ").append(e).append(" was not found in headers").append(response.getHeaders()).append(newline);
                    continue;
                }
                result.message.append("    ").append("Content Type ").append(e).append(" was found").append(newline);
            }
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyVary(Response response, List<String> var) {
        VerificationResult result = new VerificationResult();
        if (var != null) {
            for (Map.Entry entry : response.getMetadata().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Vary")) continue;
                for (String value : var) {
                    String actual = ((List)entry.getValue()).toString().toLowerCase();
                    if (actual.indexOf(value.toLowerCase()) < 0) {
                        result.pass = false;
                        result.message.append("    ").append("    ").append("Expected header ").append(value).append(" not set in Vary.").append(newline);
                        continue;
                    }
                    result.message.append("    ").append("    ").append("Found expected header ").append(value).append(".").append(newline);
                }
            }
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyCacheControl(Response response, List<String> ccl) {
        VerificationResult result = new VerificationResult();
        if (ccl != null) {
            for (String tt : ccl) {
                result.message.append("Expecting Cache-Control ").append(tt).append(newline);
            }
            for (Map.Entry entry : response.getMetadata().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Cache-Control")) continue;
                for (Object all_ccl : (List)entry.getValue()) {
                    for (String cc : ccl) {
                        if (all_ccl.toString().toLowerCase().indexOf(cc.toLowerCase()) > -1) continue;
                        result.pass = false;
                        result.message.append("    ").append("    ").append("Cache-Control test failed: ").append(cc).append(" is not found in Response.").append(newline);
                    }
                }
            }
        }
        result.message.append(newline);
        return result;
    }

    protected VerificationResult verifyCookies(Response response, List<String> cookies) {
        VerificationResult result = new VerificationResult();
        if (cookies != null) {
            for (String tt : cookies) {
                result.message.append("    ").append("    ").append("Expecting Set-Cookie").append(tt).append(newline);
            }
            for (Map.Entry entry : response.getMetadata().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Set-Cookie")) continue;
                for (Object nck_actual : (List)entry.getValue()) {
                    result.message.append("    ").append("    ").append("Processing ").append(nck_actual.toString()).append(newline);
                    if (!cookies.contains(nck_actual.toString().toLowerCase().replace(" ", ""))) {
                        result.pass = false;
                        result.message.append("    ").append("    ").append("Set-Cookie test failed: ").append(nck_actual).append(" is not expected in Response.").append(newline);
                        continue;
                    }
                    result.message.append("    ").append("    ").append("Expected Set-Cookie: ").append(nck_actual).append(" is found in Response.").append(newline);
                }
            }
        }
        result.message.append(newline);
        return result;
    }

    protected static void assertResultTrue(VerificationResult result) {
        Assertions.assertTrue((boolean)result.pass, (String)"At least one assertion failed");
    }

    protected static List<String> getLangList() {
        return Arrays.asList("en-US", "en-GB", "zh-CN");
    }

    protected static List<Variant> getVariantList(List<String> encoding, MediaType ... mt) {
        return Variant.VariantListBuilder.newInstance().mediaTypes(mt).languages(new Locale[]{new Locale("en", "US"), new Locale("en", "GB"), new Locale("zh", "CN")}).encodings(encoding.toArray(new String[0])).add().build();
    }

    protected static String langToString(Object object) {
        Locale locale = null;
        if (object instanceof List) {
            object = ((List)object).iterator().next();
        }
        if (object instanceof Locale) {
            locale = (Locale)object;
        }
        String value = locale == null ? object.toString() : locale.toString();
        return value.replace("_", "-");
    }

    protected static Link createLink(String path, String rel) throws JAXRSCommonClient.Fault {
        return Link.fromUri((URI)JAXRSClientIT.createUri(path)).rel(rel).build(new Object[0]);
    }

    protected static URI createUri(String path) throws JAXRSCommonClient.Fault {
        URI uri;
        try {
            uri = new URI("http://localhost.tck:888/url404/" + path);
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return uri;
    }
}

