/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.badrequestexception;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -7606579523483319730L;
    private static final Response.Status STATUS = Response.Status.BAD_REQUEST;
    protected static final String MESSAGE = "TCK BadRequestException description";
    protected static final String HOST = "www.jcp.org";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest() throws JAXRSCommonClient.Fault {
        BadRequestException e = new BadRequestException();
        this.assertResponse(e);
    }

    @Test
    public void constructorResponseTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse();
        BadRequestException e = new BadRequestException(response);
        this.assertResponse(e, HOST);
    }

    @Test
    public void constructorResponseThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                BadRequestException e = new BadRequestException(response);
                JAXRSClientIT.fault("Exception has been not been thrown for response with status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    @Test
    public void constructorThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable throwable : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            BadRequestException e = new BadRequestException(throwable);
            this.assertResponse(e);
            this.assertCause((WebApplicationException)e, throwable);
        }
    }

    @Test
    public void constructorResponseThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        Response response = this.buildResponse();
        for (Throwable throwable : throwables) {
            BadRequestException e = new BadRequestException(response, throwable);
            this.assertResponse(e, HOST);
            this.assertCause((WebApplicationException)e, throwable);
        }
    }

    @Test
    public void constructorResponseThrowableThrowsExceptionTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                BadRequestException e = new BadRequestException(response, new Throwable());
                JAXRSClientIT.fault("Exception has been not been thrown for response with status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    @Test
    public void constructorStringTest() throws JAXRSCommonClient.Fault {
        BadRequestException e = new BadRequestException(MESSAGE);
        this.assertMessage(e);
        this.assertResponse(e);
    }

    @Test
    public void constructorStringResponseTest() throws JAXRSCommonClient.Fault {
        Response response = this.buildResponse();
        BadRequestException e = new BadRequestException(MESSAGE, response);
        this.assertResponse(e, HOST);
        this.assertMessage(e);
    }

    @Test
    public void constructorStringResponseThrowsIEATest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                BadRequestException e = new BadRequestException(MESSAGE, response);
                JAXRSClientIT.fault("Exception has been not been thrown for response with status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    @Test
    public void constructorStringThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables;
        for (Throwable throwable : throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()}) {
            BadRequestException e = new BadRequestException(MESSAGE, throwable);
            this.assertMessage(e);
            this.assertCause((WebApplicationException)e, throwable);
            this.assertResponse(e);
        }
    }

    @Test
    public void constructorStringRequestThrowableTest() throws JAXRSCommonClient.Fault {
        Throwable[] throwables = new Throwable[]{new RuntimeException(), new IOException(), new Error(), new Throwable()};
        Response response = this.buildResponse();
        for (Throwable throwable : throwables) {
            BadRequestException e = new BadRequestException(MESSAGE, response, throwable);
            this.assertMessage(e);
            this.assertCause((WebApplicationException)e, throwable);
            this.assertResponse(e, HOST);
        }
    }

    @Test
    public void constructorStringRequestThrowableThrowsIAETest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            if (status == STATUS) continue;
            try {
                Response response = Response.status((Response.Status)status).build();
                BadRequestException e = new BadRequestException(MESSAGE, response, new Throwable());
                JAXRSClientIT.fault("Exception has been not been thrown for response with status", status, "; exception", e);
            }
            catch (IllegalArgumentException e) {
                JAXRSClientIT.logMsg("IllegalArgumentException has been thrown for status", status, "as expected");
            }
        }
    }

    protected Response buildResponse() {
        Response r = Response.status((Response.Status)STATUS).header("Host", (Object)HOST).build();
        return r;
    }

    protected void assertResponse(BadRequestException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getResponse(), "#getResponse is null");
        Response response = e.getResponse();
        JAXRSClientIT.assertEqualsInt(response.getStatus(), STATUS.getStatusCode(), "response contains unexpected status", response.getStatus());
        JAXRSClientIT.logMsg("response contains expected", STATUS, "status");
    }

    protected void assertResponse(BadRequestException e, String host) throws JAXRSCommonClient.Fault {
        this.assertResponse(e);
        String header = e.getResponse().getHeaderString("Host");
        JAXRSClientIT.assertNotNull(header, "http header", "Host", " of response is null");
        JAXRSClientIT.assertEquals(host, header, "Found unexpected http", "Host", "header", header);
        JAXRSClientIT.logMsg("Found expected http", "Host", "header");
    }

    protected void assertMessage(BadRequestException e) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertNotNull(e.getMessage(), "getMessage() is null");
        JAXRSClientIT.assertContains(e.getMessage(), MESSAGE, new Object[]{"Unexpected getMessage()", e.getMessage()});
        JAXRSClientIT.logMsg("found expected getMessage()=", e.getMessage());
    }

    protected void assertCause(WebApplicationException e, Throwable expected) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(e.getCause(), expected, "#getCause does not contain expected", expected, "but", e.getCause());
        JAXRSClientIT.logMsg("getCause contains expected", expected);
    }
}

