/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class WizEdit {
    private Interview interview;
    private boolean considerCase = false;
    private boolean word = false;
    private boolean verbose;
    private PrintStream out = System.err;
    private static final ResourceBundle i18n = Interview.i18n;

    public static void main(String[] args) {
        try {
            Interview interview;
            Vector<String> v = new Vector<String>();
            File interviewFile = null;
            File outFileName = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") && i + 1 < args.length) {
                    outFileName = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-e")) {
                    v.addElement(args[++i]);
                    continue;
                }
                if (args[i].startsWith("-")) {
                    throw new BadArgs(i18n, "edit.badOption", args[i]);
                }
                if (i == args.length - 1 && args[i].endsWith(".jti")) {
                    interviewFile = new File(args[i]);
                    continue;
                }
                throw new BadArgs(i18n, "edit.badOption", args[i]);
            }
            if (interviewFile == null) {
                throw new BadArgs(i18n, "edit.noInterview");
            }
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(interviewFile));
                Properties p = new Properties();
                p.load(in);
                String interviewClassName = (String)p.get("INTERVIEW");
                if (interviewClassName == null) {
                    throw new Fault(i18n, "edit.noInterview");
                }
                Class<?> ic = Class.forName(interviewClassName);
                interview = (Interview)ic.newInstance();
                interview.load(p, false);
            }
            catch (FileNotFoundException e) {
                throw new Fault(i18n, "edit.cantFindFile", interviewFile);
            }
            catch (IOException e) {
                throw new Fault(i18n, "edit.cantReadFile", e);
            }
            Object[] cmds = new String[v.size()];
            v.copyInto(cmds);
            WizEdit editor = new WizEdit(interview);
            editor.edit((String[])cmds);
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFileName));
                Properties p = new Properties();
                interview.save(p);
                p.store(out, "Interview: " + interview.getTitle());
            }
            catch (IOException e) {
                throw new Fault(i18n, "edit.cantWriteFile", e);
            }
        }
        catch (BadArgs e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Interview.Fault e) {
            System.err.println("Problem reading file: " + e);
            System.exit(2);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview were not found on your classpath. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (IllegalAccessException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview caused access violations. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (InstantiationException e) {
            System.err.println("Problem reading file: the interview could not be loaded because some classes that are required by the interview could not be instantiated. The specific exception that occurred was: " + e);
            System.exit(2);
        }
        catch (Fault e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    public WizEdit(Interview interview) {
        this.interview = interview;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerbose(boolean verbose, PrintStream out) {
        this.verbose = verbose;
        this.out = out;
    }

    public void edit(String[] cmds) throws Fault {
        for (int i = 0; i < cmds.length; ++i) {
            this.edit(cmds[i]);
        }
    }

    public void edit(String cmd) throws Fault {
        int left;
        if (cmd == null || cmd.length() == 0) {
            throw new Fault(i18n, "edit.nullCmd");
        }
        char delim = cmd.charAt(0);
        int center = cmd.indexOf(delim, (left = 0) + 1);
        if (center == -1) {
            throw new Fault(i18n, "edit.badCmd", cmd);
        }
        int right = cmd.indexOf(delim, center + 1);
        String searchText = cmd.substring(left + 1, center);
        String replaceText = cmd.substring(center + 1, right);
        if (searchText.length() == 0) {
            throw new Fault(i18n, "edit.badCmd", cmd);
        }
        Hashtable answers = new Hashtable();
        this.interview.save(answers);
        Question[] path = this.interview.getPath();
        for (int i = 0; i < path.length; ++i) {
            Question q = path[i];
            try {
                String answer = (String)answers.get(q.getTag());
                if (answer == null || !answer.equalsIgnoreCase(searchText)) continue;
                String newAnswer = replaceText;
                q.setValue(newAnswer);
                if (!this.verbose) continue;
                Hashtable h = new Hashtable();
                q.save(h);
                this.out.println("Question:     " + q.getSummary());
                this.out.println("changed from: " + answer);
                this.out.println("          to: " + h.get(q.getTag()));
                continue;
            }
            catch (Interview.Fault e) {
                throw new Fault(i18n, "edit.cantSetValue", new Object[]{q.getSummary(), e.getMessage()});
            }
        }
    }

    private static int match(String s1, String s2, boolean considerCase, boolean word) {
        int s1len = s1.length();
        int s2len = s2.length();
        for (int i = 0; i <= s2len - s1len; ++i) {
            if (!s1.regionMatches(!considerCase, 0, s2, i, s1len) || word && (!word || i != 0 && !WizEdit.isBoundaryCh(s2.charAt(i - 1)) || i + s1len != s2.length() && !WizEdit.isBoundaryCh(s2.charAt(i + s1len)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    public static class Fault
    extends Exception {
        Fault(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        Fault(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        BadArgs(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        BadArgs(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

