/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import java.util.Properties;
import org.glassfish.admin.rest.cli.SecurityUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="__anonymous-user-enabled")
@PerLookup
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, path="anonymous-user-enabled")})
public class IsAnonymousUserEnabledCommand
implements AdminCommand {
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        SecurityUtil su = new SecurityUtil(this.domain);
        String userName = su.getAnonymousUser(this.habitat);
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Properties ep = new Properties();
        ep.put("anonymousUserEnabled", (Object)(userName != null ? 1 : 0));
        report.setExtraProperties(ep);
        if (userName == null) {
            report.setMessage("The anonymous user is disabled.");
        } else {
            ep.put("anonymousUserName", userName);
            report.setMessage("The anonymous user is enabled: " + userName);
        }
    }
}

