/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.jboss.weld.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.contexts.SerializableContextualInstanceImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.reflection.Reflections;

public class DecorationHelper<T>
implements PrivilegedAction<T> {
    private static ThreadLocal<Stack<DecorationHelper<?>>> helperStackHolder = new ThreadLocal<Stack<DecorationHelper<?>>>(){

        @Override
        protected Stack<DecorationHelper<?>> initialValue() {
            return new Stack();
        }
    };
    private final Class<T> proxyClassForDecorator;
    private final TargetBeanInstance targetBeanInstance;
    private T originalInstance;
    private T previousDelegate;
    private int counter;
    private final BeanManagerImpl beanManager;
    private final ContextualStore contextualStore;
    private final Bean<?> bean;
    private final ProxyInstantiator instantiator;
    List<Decorator<?>> decorators;

    public DecorationHelper(TargetBeanInstance originalInstance, Bean<?> bean, Class<T> proxyClassForDecorator, BeanManagerImpl beanManager, ContextualStore contextualStore, List<Decorator<?>> decorators) {
        this.originalInstance = Reflections.cast(originalInstance.getInstance());
        this.targetBeanInstance = originalInstance;
        this.beanManager = beanManager;
        this.contextualStore = contextualStore;
        this.decorators = new LinkedList(decorators);
        this.proxyClassForDecorator = proxyClassForDecorator;
        this.bean = bean;
        this.instantiator = beanManager.getServices().get(ProxyInstantiator.class);
        this.counter = 0;
    }

    public static void push(DecorationHelper<?> helper) {
        helperStackHolder.get().push(helper);
    }

    public static DecorationHelper<?> peek() {
        return helperStackHolder.get().peek();
    }

    public static void pop() {
        Stack<DecorationHelper<?>> stack = helperStackHolder.get();
        stack.pop();
        if (stack.isEmpty()) {
            helperStackHolder.remove();
        }
    }

    public T getNextDelegate(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        if (this.counter == this.decorators.size()) {
            this.previousDelegate = this.originalInstance;
            return this.originalInstance;
        }
        T proxy = this.createProxy(injectionPoint, creationalContext);
        this.previousDelegate = proxy;
        return proxy;
    }

    private T createProxy(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        T proxy = System.getSecurityManager() == null ? this.run() : AccessController.doPrivileged(this);
        TargetBeanInstance newTargetBeanInstance = new TargetBeanInstance(this.targetBeanInstance);
        Decorator decorator = (Decorator)Reflections.cast(this.decorators.get(this.counter++));
        DecoratorProxyMethodHandler methodHandler = this.createMethodHandler(injectionPoint, creationalContext, (Decorator<Object>)decorator);
        newTargetBeanInstance.setInterceptorsHandler(methodHandler);
        ProxyFactory.setBeanInstance(this.beanManager.getContextId(), proxy, newTargetBeanInstance, this.bean);
        return proxy;
    }

    public DecoratorProxyMethodHandler createMethodHandler(InjectionPoint injectionPoint, CreationalContext<?> creationalContext, Decorator<Object> decorator) {
        Object decoratorInstance = this.beanManager.getInjectableReference(injectionPoint, (Bean<?>)decorator, creationalContext);
        assert (this.previousDelegate != null) : "previousDelegate should have been set when calling beanManager.getReference(), but it wasn't!";
        SerializableContextualInstanceImpl<Decorator<Object>, Object> serializableContextualInstance = new SerializableContextualInstanceImpl<Decorator<Object>, Object>(decorator, decoratorInstance, null, this.contextualStore);
        return new DecoratorProxyMethodHandler(serializableContextualInstance, this.previousDelegate);
    }

    @Override
    public T run() {
        try {
            return this.instantiator.newInstance(this.proxyClassForDecorator);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationFailed(this), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanLogger.LOG.proxyInstantiationBeanAccessFailed(this), e.getCause());
        }
    }
}

