/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.LocalTransactionException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTransactionImpl
implements LocalTransaction {
    protected static final Logger _logger = LogDomains.getLogger(LocalTransactionImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private ManagedConnectionImpl managedConnectionImpl;

    public LocalTransactionImpl(ManagedConnectionImpl managedConnectionImpl) {
        this.managedConnectionImpl = managedConnectionImpl;
    }

    public void begin() throws ResourceException {
        this.managedConnectionImpl.transactionStarted();
        try {
            this.managedConnectionImpl.getActualConnection().setAutoCommit(false);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during begin() : " + String.valueOf(sqle));
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    public void commit() throws ResourceException {
        try {
            this.managedConnectionImpl.getActualConnection().commit();
            this.managedConnectionImpl.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during commit() : " + String.valueOf(sqle));
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.managedConnectionImpl.transactionCompleted();
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.managedConnectionImpl.getActualConnection().rollback();
            this.managedConnectionImpl.getActualConnection().setAutoCommit(true);
        }
        catch (SQLException sqle) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Exception during rollback() : " + String.valueOf(sqle));
            }
            throw new LocalTransactionException(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            this.managedConnectionImpl.transactionCompleted();
        }
    }
}

