/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import jakarta.persistence.spi.PersistenceUnitInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.DescriptorCustomizer;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ConverterAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.metadata.MetadataSource;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;

public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataFactory m_factory;
    protected MetadataProject m_project;
    protected AbstractSession m_session;
    protected Map<String, Object> m_predeployProperties;
    protected MetadataProcessor m_compositeProcessor;
    protected Set<MetadataProcessor> m_compositeMemberProcessors;
    protected MetadataSource m_metadataSource;

    public MetadataProcessor() {
    }

    public MetadataProcessor(PersistenceUnitInfo puInfo, AbstractSession session, ClassLoader loader, boolean weaveLazy, boolean weaveEager, boolean weaveFetchGroups, boolean multitenantSharedEmf, boolean multitenantSharedCache, Map<String, Object> predeployProperties, MetadataProcessor compositeProcessor) {
        this.m_loader = loader;
        this.m_session = session;
        this.m_project = new MetadataProject(puInfo, session, weaveLazy, weaveEager, weaveFetchGroups, multitenantSharedEmf, multitenantSharedCache);
        this.m_predeployProperties = predeployProperties;
        this.m_compositeProcessor = compositeProcessor;
        if (this.m_compositeProcessor != null) {
            this.m_compositeProcessor.addCompositeMemberProcessor(this);
            this.m_project.setCompositeProcessor(this.m_compositeProcessor);
        }
    }

    public void addCompositeMemberProcessor(MetadataProcessor compositeMemberProcessor) {
        if (this.m_compositeMemberProcessors == null) {
            this.m_compositeMemberProcessors = new HashSet<MetadataProcessor>();
        }
        this.m_compositeMemberProcessors.add(compositeMemberProcessor);
    }

    public void addEntityListeners() {
        for (EntityAccessor accessor : this.m_project.getEntityAccessors()) {
            accessor.setJavaClass(accessor.getDescriptor().getJavaClass());
            accessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processQueries();
    }

    public void createDynamicClasses() {
        this.m_project.createDynamicClasses(this.m_loader);
    }

    public MetadataProcessor getCompositeProcessor() {
        return this.m_compositeProcessor;
    }

    public MetadataFactory getMetadataFactory() {
        return this.m_factory;
    }

    public MetadataSource getMetadataSource() {
        return this.m_metadataSource;
    }

    public Set<MetadataProject> getPearProjects(MetadataProject project) {
        HashSet<MetadataProject> pearProjects = new HashSet<MetadataProject>();
        if (this.m_compositeMemberProcessors != null) {
            for (MetadataProcessor processor : this.m_compositeMemberProcessors) {
                MetadataProject pearProject = processor.getProject();
                if (pearProject == project) continue;
                pearProjects.add(pearProject);
            }
        }
        return pearProjects;
    }

    public Set<String> getPersistenceUnitClassSetFromMappingFiles() {
        HashSet<String> classSet = new HashSet<String>();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            for (ClassAccessor classAccessor : entityMappings.getEntities()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(classAccessor.getClassName()));
            }
            for (ClassAccessor classAccessor : entityMappings.getEmbeddables()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(classAccessor.getClassName()));
            }
            for (ClassAccessor classAccessor : entityMappings.getMappedSuperclasses()) {
                classSet.add(entityMappings.getPackageQualifiedClassName(classAccessor.getClassName()));
            }
        }
        return classSet;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public void addStructConverterNames() {
        ArrayList<String> structConverters = new ArrayList<String>();
        for (StructConverterMetadata converter : this.m_project.getStructConverters()) {
            structConverters.add(converter.getConverterClassName());
        }
        if (!structConverters.isEmpty()) {
            this.m_session.getProject().setStructConverters(structConverters);
        }
    }

    protected void handleORMException(RuntimeException e, String mappingFile, boolean throwException) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(6, "metadata", "error_loading_xml_file", new Object[]{mappingFile, e});
        } else if (!throwException) {
            this.m_session.log(6, "metadata", "error_loading_xml_file", new Object[]{mappingFile, e});
        } else {
            this.m_session.handleException(e);
        }
    }

    protected void initPersistenceUnitClasses() {
        HashMap<String, EntityAccessor> entities = new HashMap<String, EntityAccessor>();
        HashMap<String, EmbeddableAccessor> embeddables = new HashMap<String, EmbeddableAccessor>();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.initPersistenceUnitClasses(entities, embeddables);
        }
        for (EntityAccessor entity : entities.values()) {
            this.m_project.addEntityAccessor(entity);
            entity.getEntityMappings().processEntityMappingsDefaults(entity);
        }
        for (EmbeddableAccessor embeddable : embeddables.values()) {
            this.m_project.addEmbeddableAccessor(embeddable);
            embeddable.getEntityMappings().processEntityMappingsDefaults(embeddable);
        }
        if (this.m_project.getPersistenceUnitMetadata() != null && this.m_project.getPersistenceUnitMetadata().isXMLMappingMetadataComplete()) {
            return;
        }
        PersistenceUnitInfo persistenceUnitInfo = this.m_project.getPersistenceUnitInfo();
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(persistenceUnitInfo.getManagedClassNames());
        for (URL url : persistenceUnitInfo.getJarFileUrls()) {
            classNames.addAll(PersistenceUnitProcessor.getClassNamesFromURL(url, this.m_loader, null));
        }
        Set<Object> unlistedClasses = Collections.emptySet();
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            unlistedClasses = PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), this.m_loader, this.m_predeployProperties);
        }
        Iterator<Object> iterator = classNames.iterator();
        boolean unlisted = false;
        while (iterator.hasNext() || !unlisted) {
            String className;
            MetadataClass candidateClass;
            if (!iterator.hasNext() && !unlisted) {
                iterator = unlistedClasses.iterator();
                unlisted = true;
            }
            if (!iterator.hasNext() || (candidateClass = this.m_factory.getMetadataClass(className = (String)iterator.next(), unlisted)) == null) continue;
            if (PersistenceUnitProcessor.isEntity(candidateClass) && !this.m_project.hasEntity(candidateClass) && !this.m_project.hasEmbeddable(candidateClass)) {
                this.m_project.addEntityAccessor(new EntityAccessor(PersistenceUnitProcessor.getEntityAnnotation(candidateClass), candidateClass, this.m_project));
                continue;
            }
            if (PersistenceUnitProcessor.isEmbeddable(candidateClass) && !this.m_project.hasEmbeddable(candidateClass) && !this.m_project.hasEntity(candidateClass)) {
                this.m_project.addEmbeddableAccessor(new EmbeddableAccessor(PersistenceUnitProcessor.getEmbeddableAnnotation(candidateClass), candidateClass, this.m_project));
                continue;
            }
            if (PersistenceUnitProcessor.isStaticMetamodelClass(candidateClass)) {
                this.m_project.addStaticMetamodelClass(PersistenceUnitProcessor.getStaticMetamodelAnnotation(candidateClass), candidateClass);
                continue;
            }
            if (PersistenceUnitProcessor.isConverter(candidateClass) && !this.m_project.hasConverterAccessor(candidateClass)) {
                this.m_project.addConverterAccessor(new ConverterAccessor(PersistenceUnitProcessor.getConverterAnnotation(candidateClass), candidateClass, this.m_project));
                continue;
            }
            if (!PersistenceUnitProcessor.isMappedSuperclass(candidateClass) || this.m_project.hasMappedSuperclass(candidateClass)) continue;
            this.m_project.addMappedSuperclass(new MappedSuperclassAccessor(PersistenceUnitProcessor.getMappedSuperclassAnnotation(candidateClass), candidateClass, this.m_project));
        }
    }

    public void loadMappingFiles(boolean throwExceptionOnFail) {
        XMLEntityMappings entityMappings;
        this.loadStandardMappingFiles("META-INF/orm.xml");
        this.loadSpecifiedMappingFiles(throwExceptionOnFail);
        Boolean excludeEclipseLinkORM = Boolean.valueOf((String)this.m_project.getPersistenceUnitInfo().getProperties().get("eclipselink.exclude-eclipselink-orm"));
        if (!excludeEclipseLinkORM.booleanValue()) {
            this.loadStandardMappingFiles("META-INF/eclipselink-orm.xml");
        }
        if (this.m_metadataSource != null && (entityMappings = this.m_metadataSource.getEntityMappings(this.m_predeployProperties, this.m_loader, this.m_session.getSessionLog())) != null) {
            this.m_project.addEntityMappings(entityMappings);
        }
    }

    protected void loadSpecifiedMappingFiles(boolean throwExceptionOnFail) {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        for (String mappingFileName : puInfo.getMappingFileNames()) {
            try {
                Enumeration<URL> mappingFileURLs = this.m_loader.getResources(mappingFileName);
                if (!mappingFileURLs.hasMoreElements()) {
                    mappingFileURLs = this.m_loader.getResources("/./" + mappingFileName);
                }
                if (mappingFileURLs.hasMoreElements()) {
                    URL nextURL = mappingFileURLs.nextElement();
                    if (nextURL == null) {
                        nextURL = mappingFileURLs.nextElement();
                    }
                    if (mappingFileURLs.hasMoreElements()) {
                        ValidationException throwable = ValidationException.nonUniqueMappingFileName((String)puInfo.getPersistenceUnitName(), (String)mappingFileName);
                        this.getSessionLog().logThrowable(2, "metadata", (Throwable)throwable);
                    }
                    this.m_project.addEntityMappings(XMLEntityMappingsReader.read(nextURL, this.m_loader, this.m_project.getPersistenceUnitInfo().getProperties()));
                    continue;
                }
                this.loadMappingFiles(null, throwExceptionOnFail);
            }
            catch (IOException e) {
                this.handleORMException((RuntimeException)PersistenceUnitLoadingException.exceptionLoadingORMXML((String)mappingFileName, (Exception)e), mappingFileName, throwExceptionOnFail);
            }
        }
    }

    protected void loadStandardMappingFiles(String ormXMLFile) {
        this.loadMappingFiles(ormXMLFile, false);
    }

    private void loadMappingFiles(String mappingFile, boolean throwExceptionOnFail) {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        HashSet<URL> rootUrls = new HashSet<URL>(puInfo.getJarFileUrls());
        rootUrls.add(puInfo.getPersistenceUnitRootUrl());
        HashSet<String> entries = new HashSet<String>();
        for (URL rootURL : rootUrls) {
            Archive par = null;
            try {
                par = PersistenceUnitProcessor.getArchiveFactory(this.m_loader, this.m_predeployProperties).createArchive(rootURL, null);
                if (par == null) continue;
                List mappingFileNames = mappingFile != null ? List.of(mappingFile) : puInfo.getMappingFileNames();
                for (String mappingFileName : mappingFileNames) {
                    this.getSessionLog().log(2, "metadata", "searching_for_default_mapping_file", new Object[]{mappingFileName, rootURL}, true);
                    URL ormURL = par.getEntryAsURL(mappingFileName);
                    if (ormURL != null) {
                        this.getSessionLog().log(2, "metadata", "found_default_mapping_file", new Object[]{ormURL, rootURL}, true);
                        if (!entries.contains(mappingFileName)) {
                            entries.add(mappingFileName);
                        } else {
                            ValidationException throwable = ValidationException.nonUniqueMappingFileName((String)puInfo.getPersistenceUnitName(), (String)mappingFileName);
                            this.getSessionLog().logThrowable(2, "metadata", (Throwable)throwable);
                        }
                        XMLEntityMappings entityMappings = XMLEntityMappingsReader.read(ormURL, this.m_loader, puInfo.getProperties());
                        entityMappings.setIsEclipseLinkORMFile("META-INF/eclipselink-orm.xml".equals(mappingFileName));
                        this.m_project.addEntityMappings(entityMappings);
                        continue;
                    }
                    if (mappingFile != null) continue;
                    this.handleORMException((RuntimeException)((Object)ValidationException.mappingFileNotFound((String)puInfo.getPersistenceUnitName(), (String)mappingFileName)), mappingFileName, throwExceptionOnFail);
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (par == null) continue;
                par.close();
            }
        }
    }

    protected SessionLog getSessionLog() {
        if (this.m_session != null) {
            return this.m_session.getSessionLog();
        }
        return AbstractSessionLog.getLog();
    }

    public void processCustomizers() {
        for (ClassAccessor classAccessor : this.m_project.getAccessorsWithCustomizer()) {
            DescriptorCustomizer customizer = (DescriptorCustomizer)MetadataHelper.getClassInstance(classAccessor.getCustomizerClass().getName(), this.m_loader);
            try {
                customizer.customize(classAccessor.getDescriptor().getClassDescriptor());
            }
            catch (Exception e) {
                this.getSessionLog().logThrowable(2, "metadata", (Throwable)e);
            }
        }
    }

    public void processEntityMappings(PersistenceUnitProcessor.Mode mode) {
        if (mode == PersistenceUnitProcessor.Mode.ALL || mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
            this.m_factory = new MetadataAsmFactory(this.m_project.getLogger(), this.m_loader);
            for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
                entityMappings.setLoader(this.m_loader);
                entityMappings.setProject(this.m_project);
                entityMappings.setMetadataFactory(this.m_factory);
                entityMappings.processPersistenceUnitMetadata();
            }
            this.initPersistenceUnitClasses();
            for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
                entityMappings.process();
            }
        }
    }

    public void processORMMetadata(PersistenceUnitProcessor.Mode mode) {
        if (mode == PersistenceUnitProcessor.Mode.ALL || mode == PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
            this.m_project.processStage1();
            this.m_project.processStage2();
        }
        if (mode != PersistenceUnitProcessor.Mode.COMPOSITE_MEMBER_INITIAL) {
            this.m_project.processStage3(mode);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
        this.m_factory.setLoader(loader);
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.setLoader(this.m_loader);
        }
    }

    public void setMetadataSource(MetadataSource source) {
        this.m_metadataSource = source;
    }
}

