/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.simple;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.simple.DropOpposite;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="makeFeatureVolatile", label="Make Feature Volatile", description="In the metamodel, a feature is made volatile. In the model, its values have to be deleted.", breaking=true)
public class MakeFeatureVolatile
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be made volatile")
    public EStructuralFeature feature;
    @EdaptParameter(description="Whether the feature is transient")
    public Boolean trans = true;
    @EdaptParameter(description="Whether the feature is derived")
    public Boolean derived = true;
    @EdaptParameter(description="Whether the feature is changeable")
    public Boolean changeable = false;

    @EdaptConstraint(restricts="feature", description="Feature must not be volatile")
    public boolean checkFeatureNotVolatile(EStructuralFeature feature) {
        return !feature.isVolatile();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) throws MigrationException {
        EReference reference;
        this.feature.setVolatile(true);
        this.feature.setTransient(this.trans.booleanValue());
        this.feature.setDerived(this.derived.booleanValue());
        this.feature.setChangeable(this.changeable.booleanValue());
        if (this.feature instanceof EReference && (reference = (EReference)this.feature).getEOpposite() != null) {
            DropOpposite operation = new DropOpposite();
            operation.reference = reference;
            operation.checkAndExecute(metamodel, model);
        }
        for (Instance instance : model.getAllInstances(this.feature.getEContainingClass())) {
            this.deleteFeatureValue(instance, this.feature);
        }
    }
}

