/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.toolbaractions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.osgi.framework.FrameworkUtil;

public class LoadEcoreAction
extends Action {
    private final Object currentObject;

    public LoadEcoreAction(Object currentObject) {
        super("Load Ecore");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getResource("icons/chart_organisation_add.png")));
        this.currentObject = currentObject;
    }

    public void run() {
        new ExtendedLoadResourceDialog(Display.getDefault().getActiveShell(), AdapterFactoryEditingDomain.getEditingDomainFor((Object)this.currentObject)).open();
    }

    private static class ExtendedLoadResourceDialog
    extends LoadResourceAction.LoadResourceDialog {
        private final Set<EPackage> registeredPackages = new LinkedHashSet<EPackage>();

        ExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
            super(parent, domain);
        }

        protected boolean processResource(Resource resource) {
            ResourceSet resourceSet = this.domain.getResourceSet();
            if (!resourceSet.getResources().contains((Object)resource)) {
                EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                for (EPackage ePackage : this.getAllPackages(resource)) {
                    packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    this.registeredPackages.add(ePackage);
                }
            }
            return true;
        }

        protected Collection<EPackage> getAllPackages(Resource resource) {
            ArrayList<EPackage> result = new ArrayList<EPackage>();
            EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                    return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
                }
            };
            while (j.hasNext()) {
                Object content = j.next();
                if (!(content instanceof EPackage)) continue;
                result.add((EPackage)content);
            }
            return result;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite buttonComposite = (Composite)composite.getChildren()[0];
            Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
            browseRegisteredPackagesButton.setText("Browser Registered Packages");
            this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
            FormData data = new FormData();
            Control[] children = buttonComposite.getChildren();
            data.right = new FormAttachment(children[0], -10);
            browseRegisteredPackagesButton.setLayoutData((Object)data);
            Button browseTargetPlatformPackagesButton = new Button(buttonComposite, 8);
            browseTargetPlatformPackagesButton.setText("Browse Target Platform Packages");
            this.prepareBrowseTargetPlatformPackagesButton(browseTargetPlatformPackagesButton);
            FormData data2 = new FormData();
            data2.right = new FormAttachment((Control)browseRegisteredPackagesButton, -10);
            browseTargetPlatformPackagesButton.setLayoutData((Object)data2);
            return composite;
        }

        protected void prepareBrowseTargetPlatformPackagesButton(Button browseTargetPlatformPackagesButton) {
            browseTargetPlatformPackagesButton.addSelectionListener((SelectionListener)new TargetPlatformSelectionAdapter());
        }

        protected void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
            browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new RegisteredPackageSelectionAdapter());
        }

        private final class RegisteredPackageSelectionAdapter
        extends SelectionAdapter {
            private RegisteredPackageSelectionAdapter() {
            }

            public void widgetSelected(SelectionEvent event) {
                RegisteredPackageDialog registeredPackageDialog = new RegisteredPackageDialog(ExtendedLoadResourceDialog.this.getShell());
                registeredPackageDialog.open();
                Object[] result = registeredPackageDialog.getResult();
                if (result != null) {
                    List<Object> nsURIs = Arrays.asList(result);
                    if (registeredPackageDialog.isDevelopmentTimeVersion()) {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
                        Resource dummyResource = ExtendedLoadResourceDialog.this.domain == null ? null : resourceSet.createResource(((Resource)ExtendedLoadResourceDialog.this.domain.getResourceSet().getResources().get(0)).getURI());
                        StringBuffer uris = new StringBuffer();
                        Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                        int i = 0;
                        int length = result.length;
                        while (i < length) {
                            URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                            Resource resource = resourceSet.getResource(location, true);
                            EcoreUtil.resolveAll((Resource)resource);
                            ++i;
                        }
                        EList resources = resourceSet.getResources();
                        resources.remove((Object)dummyResource);
                        block1: for (Resource resource : resources) {
                            for (EPackage ePackage : ExtendedLoadResourceDialog.this.getAllPackages(resource)) {
                                if (!nsURIs.contains(ePackage.getNsURI())) continue;
                                uris.append(resource.getURI());
                                uris.append("  ");
                                continue block1;
                            }
                        }
                        ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    } else {
                        StringBuffer uris = new StringBuffer();
                        int i = 0;
                        int length = result.length;
                        while (i < length) {
                            uris.append(result[i]);
                            uris.append("  ");
                            ++i;
                        }
                        ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                    }
                }
            }
        }

        private final class TargetPlatformSelectionAdapter
        extends SelectionAdapter {
            private TargetPlatformSelectionAdapter() {
            }

            public void widgetSelected(SelectionEvent event) {
                TargetPlatformPackageDialog classpathPackageDialog = new TargetPlatformPackageDialog(ExtendedLoadResourceDialog.this.getShell());
                classpathPackageDialog.open();
                Object[] result = classpathPackageDialog.getResult();
                if (result != null) {
                    List<Object> nsURIs = Arrays.asList(result);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
                    Resource dummyResource = ExtendedLoadResourceDialog.this.domain == null ? null : resourceSet.createResource(((Resource)ExtendedLoadResourceDialog.this.domain.getResourceSet().getResources().get(0)).getURI());
                    StringBuffer uris = new StringBuffer();
                    Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                        Resource resource = resourceSet.getResource(location, true);
                        EcoreUtil.resolveAll((Resource)resource);
                        ++i;
                    }
                    EList resources = resourceSet.getResources();
                    resources.remove((Object)dummyResource);
                    block1: for (Resource resource : resources) {
                        for (EPackage ePackage : ExtendedLoadResourceDialog.this.getAllPackages(resource)) {
                            if (!nsURIs.contains(ePackage.getNsURI())) continue;
                            uris.append(resource.getURI());
                            uris.append("  ");
                            continue block1;
                        }
                    }
                    ExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(ExtendedLoadResourceDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }
            }
        }
    }

    private static class RegisteredPackageDialog
    extends ElementListSelectionDialog {
        private boolean isDevelopmentTimeVersion = true;

        RegisteredPackageDialog(Shell parent) {
            super(parent, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                }
            });
            this.setMultipleSelection(true);
            this.setMessage("Select Registered Package URI");
            this.setFilter("*");
            this.setTitle("Package Selection");
        }

        public boolean isDevelopmentTimeVersion() {
            return this.isDevelopmentTimeVersion;
        }

        protected void updateElements() {
            if (this.isDevelopmentTimeVersion) {
                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
                Arrays.sort(result);
                this.setListElements(result);
            } else {
                Object[] result = EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
                Arrays.sort(result);
                this.setListElements(result);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            Composite buttonGroup = new Composite(result, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            buttonGroup.setLayout((Layout)layout);
            final Button developmentTimeVersionButton = new Button(buttonGroup, 16);
            developmentTimeVersionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RegisteredPackageDialog.this.isDevelopmentTimeVersion = developmentTimeVersionButton.getSelection();
                    RegisteredPackageDialog.this.updateElements();
                }
            });
            developmentTimeVersionButton.setText("Development Time Version");
            Button runtimeTimeVersionButton = new Button(buttonGroup, 16);
            runtimeTimeVersionButton.setText("Runtime Version");
            developmentTimeVersionButton.setSelection(true);
            this.updateElements();
            return result;
        }
    }

    private static class TargetPlatformPackageDialog
    extends ElementListSelectionDialog {
        TargetPlatformPackageDialog(Shell parent) {
            super(parent, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                }
            });
            this.setMultipleSelection(true);
            this.setMessage("Select Registered Package URI");
            this.setFilter("*");
            this.setTitle("PackageSelection");
        }

        protected void updateElements() {
            Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
            Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
            Arrays.sort(result);
            this.setListElements(result);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.updateElements();
            return result;
        }
    }
}

