/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.structuralchange.index;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.emfforms.spi.core.services.structuralchange.EMFFormsStructuralChangeTester;
import org.eclipse.emfforms.spi.core.services.structuralchange.StructuralChangeTesterInternal;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class StructuralChangeTesterIndex
implements StructuralChangeTesterInternal {
    private EMFFormsStructuralChangeTester emfFormsStructuralChangeTester;
    private EMFFormsDatabindingEMF emfFormsDatabinding;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsStructuralChangeTester> emfFormsStructuralChangeTesterServiceReference;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.emfFormsStructuralChangeTesterServiceReference != null) {
            bundleContext.ungetService(this.emfFormsStructuralChangeTesterServiceReference);
            this.emfFormsStructuralChangeTester = null;
        }
    }

    private EMFFormsStructuralChangeTester getEMFFormsStructuralChangeTester() {
        if (this.emfFormsStructuralChangeTester == null) {
            this.emfFormsStructuralChangeTesterServiceReference = this.bundleContext.getServiceReference(EMFFormsStructuralChangeTester.class);
            if (this.emfFormsStructuralChangeTesterServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.emfFormsStructuralChangeTester = (EMFFormsStructuralChangeTester)this.bundleContext.getService(this.emfFormsStructuralChangeTesterServiceReference);
        }
        return this.emfFormsStructuralChangeTester;
    }

    void setEMFFormsStructuralChangeTester(EMFFormsStructuralChangeTester emfFormsStructuralChangeTester) {
        this.emfFormsStructuralChangeTester = emfFormsStructuralChangeTester;
    }

    @Reference
    protected void setEMFFormsDatabindingEMF(EMFFormsDatabindingEMF emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    public double isApplicable(VDomainModelReference reference) {
        if (VIndexDomainModelReference.class.isInstance(reference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public boolean isStructureChanged(VDomainModelReference reference, EObject domainRootObject, ModelChangeNotification notification) {
        Assert.create((Object)reference).notNull();
        Assert.create((Object)notification).notNull();
        Assert.create((Object)reference).ofClass(VFeaturePathDomainModelReference.class);
        if (notification.getRawNotification().isTouch()) {
            return false;
        }
        if (EAttribute.class.isInstance(notification.getStructuralFeature())) {
            return false;
        }
        VIndexDomainModelReference indexDMR = (VIndexDomainModelReference)VIndexDomainModelReference.class.cast(reference);
        boolean relevantChange = false;
        EObject lastResolvedEObject = domainRootObject;
        if (indexDMR.getPrefixDMR() == null) {
            for (EReference eReference : indexDMR.getDomainModelEReferencePath()) {
                if (lastResolvedEObject == null) {
                    return false;
                }
                if (relevantChange |= eReference.equals(notification.getStructuralFeature()) && lastResolvedEObject == notification.getNotifier()) {
                    return true;
                }
                lastResolvedEObject = (EObject)lastResolvedEObject.eGet((EStructuralFeature)eReference);
            }
            if (relevantChange |= notification.getStructuralFeature().equals(indexDMR.getDomainModelEFeature()) && lastResolvedEObject == notification.getNotifier()) {
                return true;
            }
            lastResolvedEObject = (EObject)((EList)lastResolvedEObject.eGet(indexDMR.getDomainModelEFeature())).get(indexDMR.getIndex());
        } else {
            relevantChange = this.getEMFFormsStructuralChangeTester().isStructureChanged(indexDMR.getPrefixDMR(), domainRootObject, notification);
            if (relevantChange) {
                return true;
            }
            try {
                lastResolvedEObject = (EObject)((EList)this.emfFormsDatabinding.getSetting(indexDMR.getPrefixDMR(), domainRootObject).get(true)).get(indexDMR.getIndex());
            }
            catch (DatabindingFailedException ex) {
                throw new IllegalStateException(ex);
            }
        }
        relevantChange = this.getEMFFormsStructuralChangeTester().isStructureChanged(indexDMR.getTargetDMR(), lastResolvedEObject, notification);
        return relevantChange;
    }
}

