/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.defaultheuristic;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsDomainExpanderImpl")
public class EMFFormsDomainExpanderImpl
implements EMFFormsDomainExpander {
    private final Set<EMFFormsDMRExpander> emfFormsDMRExpanders = new CopyOnWriteArraySet<EMFFormsDMRExpander>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.add(emfFormsDMRExpander);
    }

    protected void removeEMFFormsDMRExpander(EMFFormsDMRExpander emfFormsDMRExpander) {
        this.emfFormsDMRExpanders.remove(emfFormsDMRExpander);
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        EMFFormsDMRExpander bestDMRExpander = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (EMFFormsDMRExpander dmrExpander : this.emfFormsDMRExpanders) {
            if (!(dmrExpander.isApplicable(domainModelReference) > bestScore)) continue;
            bestScore = dmrExpander.isApplicable(domainModelReference);
            bestDMRExpander = dmrExpander;
        }
        if (bestDMRExpander == null) {
            throw new EMFFormsExpandingFailedException("There is no suitable EMFFormsDMRExpander for the given domain model reference.");
        }
        bestDMRExpander.prepareDomainObject(domainModelReference, domainObject);
    }
}

