/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.internal.tooling.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectEStructuralFeatureWizardPage
extends WizardPage {
    private Composite container;
    private EPackage selectedEPackage;
    private EStructuralFeature selectedEStructuralFeature;
    private TreeViewer treeViewer;

    public void setSelectedEPackage(EPackage selectedEPackage) {
        this.selectedEPackage = selectedEPackage;
        this.treeViewer.setInput((Object)selectedEPackage);
    }

    public SelectEStructuralFeatureWizardPage() {
        super("Select EClass");
        this.setTitle("Select EClass");
        this.setDescription("Select an EClass for the current View Model.");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.treeViewer != null && this.selectedEPackage != null) {
            this.treeViewer.setInput((Object)this.selectedEPackage);
            this.treeViewer.expandToLevel(2);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        this.container.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.container);
        layout.numColumns = 1;
        Label label1 = new Label(this.container, 0);
        label1.setText("Select an EClass:");
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        this.treeViewer = new TreeViewer(this.container, 770);
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider((AdapterFactory)adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)this.selectedEPackage);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                Object selectedItem;
                if (event.getSelection() instanceof IStructuredSelection && EStructuralFeature.class.isInstance(selectedItem = (selection = (IStructuredSelection)event.getSelection()).getFirstElement())) {
                    SelectEStructuralFeatureWizardPage.this.selectedEStructuralFeature = (EStructuralFeature)selectedItem;
                    SelectEStructuralFeatureWizardPage.this.setPageComplete(true);
                }
                if (SelectEStructuralFeatureWizardPage.this.selectedEStructuralFeature == null) {
                    SelectEStructuralFeatureWizardPage.this.setPageComplete(false);
                }
            }
        });
        this.treeViewer.expandToLevel(2);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).applyTo(this.treeViewer.getControl());
        this.container.layout(true);
        this.container.pack();
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private ITreeContentProvider getContentProvider(AdapterFactory adapterFactory) {
        return new EStructuralFeatureContentProvider();
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.selectedEStructuralFeature;
    }

    public boolean isPageComplete() {
        return this.selectedEStructuralFeature != null;
    }

    private static final class EStructuralFeatureContentProvider
    implements ITreeContentProvider {
        private EStructuralFeatureContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (EPackage.class.isInstance(element)) {
                return true;
            }
            return EClass.class.isInstance(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (EPackage.class.isInstance(parentElement)) {
                LinkedHashSet<EObject> children = new LinkedHashSet<EObject>();
                children.addAll((Collection<EObject>)((EPackage)EPackage.class.cast(parentElement)).getESubpackages());
                for (EObject obj : ((EPackage)EPackage.class.cast(parentElement)).getEClassifiers()) {
                    EClass eClass;
                    if (!EClass.class.isInstance(obj) || (eClass = (EClass)EClass.class.cast(obj)).isAbstract() || eClass.isInterface()) continue;
                    children.add(obj);
                }
                return children.toArray();
            }
            if (EClass.class.isInstance(parentElement)) {
                return ((EClass)EClass.class.cast(parentElement)).getEAllStructuralFeatures().toArray();
            }
            return null;
        }
    }
}

