/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.ui.json.internal.handler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.emf2web.controller.GenerationController;
import org.eclipse.emf.ecp.emf2web.exporter.FileGenerationExporter;
import org.eclipse.emf.ecp.emf2web.exporter.GenerationExporter;
import org.eclipse.emf.ecp.emf2web.json.controller.JsonGenerationController;
import org.eclipse.emf.ecp.emf2web.ui.handler.AbstractSchemaExportCommandHandler;
import org.eclipse.emf.ecp.emf2web.ui.json.Activator;
import org.eclipse.emf.ecp.emf2web.ui.json.internal.messages.Messages;
import org.eclipse.emf.ecp.internal.ide.util.EcoreHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportJSONFormsHandler
extends AbstractSchemaExportCommandHandler {
    private final List<String> registeredEcores = new LinkedList<String>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.registeredEcores.clear();
        super.execute(event);
        for (String registeredEcore : this.registeredEcores) {
            EcoreHelper.unregisterEcore((String)registeredEcore);
        }
        return null;
    }

    protected Collection<VView> getViews(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        LinkedList<VView> views = new LinkedList<VView>();
        LinkedList<IFile> failedFiles = new LinkedList<IFile>();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof IFile)) continue;
            IFile file = (IFile)selectedObject;
            String path = file.getLocation().toString();
            VView view = this.loadView(path);
            if (!this.viewIsResolved(view)) {
                try {
                    view = this.tryResolve(view, path, this.registeredEcores);
                }
                catch (IOException e) {
                    Activator.logException(e);
                }
                if (!this.viewIsResolved(view)) {
                    failedFiles.add(file);
                    continue;
                }
            }
            views.add(view);
        }
        if (!failedFiles.isEmpty()) {
            this.showErrorMessage(failedFiles, views.isEmpty());
            if (views.isEmpty()) {
                return null;
            }
        }
        return views;
    }

    private boolean viewIsResolved(VView view) {
        return !view.getRootEClass().eIsProxy();
    }

    private VView tryResolve(VView view, String path, Collection<String> registeredEcores) throws IOException {
        EcoreUtil.resolveAll((EObject)view);
        if (this.viewIsResolved(view)) {
            return view;
        }
        if (view.getEcorePath() == null || ResourcesPlugin.getWorkspace().getRoot().findMember(view.getEcorePath()) == null) {
            throw new FileNotFoundException(path);
        }
        EcoreHelper.registerEcore((String)view.getEcorePath());
        registeredEcores.add(view.getEcorePath());
        VView reloadView = this.loadView(path);
        if (!this.viewIsResolved(reloadView)) {
            EcoreUtil.resolveAll((EObject)reloadView);
        }
        return reloadView;
    }

    private VView loadView(String path) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)path);
        Resource resource = resourceSet.getResource(fileURI, true);
        if (resource != null) {
            return (VView)resource.getContents().get(0);
        }
        return null;
    }

    private void showErrorMessage(Collection<IFile> files, boolean allFailed) {
        Iterator<IFile> viewIt = files.iterator();
        String viewNames = viewIt.next().getName();
        while (viewIt.hasNext()) {
            viewNames = String.valueOf(viewNames) + ", " + viewIt.next().getName();
        }
        String message = String.valueOf(Messages.ExportJSONFormsHandler_ViewsNotResolved) + viewNames;
        message = allFailed ? String.valueOf(message) + "\n" + Messages.ExportJSONFormsHandler_ExportCanceled : String.valueOf(message) + "\n" + Messages.ExportJSONFormsHandler_ViewsSkipped;
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportJSONFormsHandler_ErrorResolvedViews, (String)message);
    }

    protected GenerationController getGenerationController() {
        return new JsonGenerationController();
    }

    protected GenerationExporter getGenerationExporter() {
        return new FileGenerationExporter();
    }
}

