/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.editsupport;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.emfspecificservice.EMFSpecificService;

public class EMFFormsEditSupportImpl
implements EMFFormsEditSupport {
    private EMFFormsDatabinding emfFormsDatabinding;
    private EMFSpecificService emfSpecificService;
    private ReportService reportService;

    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    protected void setEMFSpecificService(EMFSpecificService emfSpecificService) {
        this.emfSpecificService = emfSpecificService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public boolean isMultiLine(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return false;
        }
        return itemPropertyDescriptor.isMultiLine((Object)value);
    }

    @Override
    public boolean canSetProperty(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return false;
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return false;
        }
        return itemPropertyDescriptor.canSetProperty((Object)value);
    }

    @Override
    public String getText(VDomainModelReference domainModelReference, EObject rootObject, Object element) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        Assert.create((Object)element).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return ex.getMessage();
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return null;
        }
        IItemLabelProvider labelProvider = itemPropertyDescriptor.getLabelProvider((Object)rootObject);
        return labelProvider.getText(element);
    }

    @Override
    public Object getImage(VDomainModelReference domainModelReference, EObject rootObject, Object element) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return ex.getMessage();
        }
        IObserving observing = (IObserving)observableValue;
        EObject value = (EObject)observing.getObserved();
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return null;
        }
        IItemLabelProvider labelProvider = itemPropertyDescriptor.getLabelProvider((Object)rootObject);
        return labelProvider.getImage(element);
    }

    private void reportMissingPropertyDescriptor(EObject value, EStructuralFeature structuralFeature) {
        this.reportService.report(new AbstractReport(String.format("No IItemPropertyDescriptor for feature %2$s in EClass %1$s found.", value.eClass().getName(), structuralFeature.getName())));
    }
}

