/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.IEMFValueProperty;
import org.eclipse.emf.databinding.internal.EMFValuePropertyDecorator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.internal.core.services.databinding.SegmentConverterValueResultImpl;
import org.eclipse.emfforms.internal.core.services.segments.index.EMFIndexedValueProperty;
import org.eclipse.emfforms.internal.core.services.segments.index.IllegalListTypeException;
import org.eclipse.emfforms.internal.core.services.segments.index.IndexedSetting;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.emf.DomainModelReferenceSegmentConverterEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterListResultEMF;
import org.eclipse.emfforms.spi.core.services.databinding.emf.SegmentConverterValueResultEMF;
import org.eclipse.emfforms.spi.view.indexsegment.model.VIndexDomainModelReferenceSegment;
import org.osgi.service.component.annotations.Component;

@Component(name="IndexSegmentConverter")
public class IndexSegmentConverter
implements DomainModelReferenceSegmentConverterEMF {
    public double isApplicable(VDomainModelReferenceSegment segment) {
        Assert.create((Object)segment).notNull();
        if (segment instanceof VIndexDomainModelReferenceSegment) {
            return 10.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public SegmentConverterValueResultEMF convertToValueProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        VIndexDomainModelReferenceSegment indexSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = segmentRoot.getEStructuralFeature(indexSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new DatabindingFailedException(String.format("The segment's feature could not be resolved for the given EClass. The segment was %1$s. The EClass was %2$s.", segment, segmentRoot));
        }
        this.checkListType(structuralFeature);
        EMFIndexedValueProperty indexProperty = new EMFIndexedValueProperty(editingDomain, indexSegment.getIndex(), structuralFeature);
        EMFValuePropertyDecorator resultProperty = new EMFValuePropertyDecorator((IValueProperty)indexProperty, structuralFeature);
        if (EReference.class.isInstance(structuralFeature)) {
            return new SegmentConverterValueResultImpl((IEMFValueProperty)resultProperty, ((EReference)structuralFeature).getEReferenceType());
        }
        return new SegmentConverterValueResultImpl((IEMFValueProperty)resultProperty, null);
    }

    public SegmentConverterListResultEMF convertToListProperty(VDomainModelReferenceSegment segment, EClass segmentRoot, EditingDomain editingDomain) throws DatabindingFailedException {
        throw new UnsupportedOperationException("A VIndexDomainModelReferenceSegment cannot be converted to a list property, only to a value property.");
    }

    public EStructuralFeature.Setting getSetting(VDomainModelReferenceSegment segment, EObject eObject) throws DatabindingFailedException {
        VIndexDomainModelReferenceSegment indexSegment = this.checkAndConvertSegment(segment);
        EStructuralFeature structuralFeature = eObject.eClass().getEStructuralFeature(indexSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new DatabindingFailedException(String.format("The given EOject does not contain the segment's feature. The segment was %1$s. The EObject was %2$s.", segment, eObject));
        }
        if (structuralFeature.getEType() == null) {
            throw new DatabindingFailedException(String.format("The eType of the feature %1$s is null.", structuralFeature.getName()));
        }
        this.checkListType(structuralFeature);
        return new IndexedSetting(eObject, structuralFeature, indexSegment.getIndex());
    }

    private VIndexDomainModelReferenceSegment checkAndConvertSegment(VDomainModelReferenceSegment segment) throws DatabindingFailedException {
        Assert.create((Object)segment).notNull();
        Assert.create((Object)segment).ofClass(VIndexDomainModelReferenceSegment.class);
        VIndexDomainModelReferenceSegment indexSegment = (VIndexDomainModelReferenceSegment)segment;
        if (indexSegment.getDomainModelFeature() == null) {
            throw new DatabindingFailedException("The segment's domain model feature must not be null.");
        }
        if (indexSegment.getDomainModelFeature().isEmpty()) {
            throw new DatabindingFailedException("The segment's domain model feature must not be an empty string.");
        }
        return indexSegment;
    }

    private void checkListType(EStructuralFeature structuralFeature) throws IllegalListTypeException {
        if (!structuralFeature.isMany()) {
            throw new IllegalListTypeException("The VIndexDomainModelReferenceSegment's domainModelFeature must reference a list.");
        }
    }
}

