/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.controlmapper;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.internal.core.services.controlmapper.SettingToControlExpandHelper;
import org.eclipse.emfforms.internal.core.services.controlmapper.ViewModelListener;
import org.eclipse.emfforms.spi.core.services.controlmapper.EMFFormsSettingToControlMapper;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProviderManager;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public class SettingToControlMapperImpl
implements EMFFormsSettingToControlMapper,
EMFFormsContextListener {
    private final EMFFormsViewContext viewModelContext;
    private final ViewModelListener dataModelListener;
    private final Map<EObject, Set<UniqueSetting>> eObjectToMappedSettings = new LinkedHashMap<EObject, Set<UniqueSetting>>();
    private final Map<UniqueSetting, List<VElement>> settingToControlMap = new LinkedHashMap<UniqueSetting, List<VElement>>();
    private final Map<VElement, List<UniqueSetting>> controlToSettingMap = new LinkedHashMap<VElement, List<UniqueSetting>>();
    private final EMFFormsMappingProviderManager mappingManager;
    private final Map<VControl, EMFFormsViewContext> controlContextMap = new LinkedHashMap<VControl, EMFFormsViewContext>();
    private final Map<EMFFormsViewContext, VElement> contextParentMap = new LinkedHashMap<EMFFormsViewContext, VElement>();
    private final Map<EMFFormsViewContext, ViewModelListener> contextListenerMap = new LinkedHashMap<EMFFormsViewContext, ViewModelListener>();
    private final ModelChangeAddRemoveListenerImplementation viewModelChangeListener;
    private boolean disposed;

    public SettingToControlMapperImpl(EMFFormsMappingProviderManager mappingManager, EMFFormsViewContext viewModelContext) {
        this.mappingManager = mappingManager;
        this.viewModelContext = viewModelContext;
        viewModelContext.registerEMFFormsContextListener(this);
        this.viewModelChangeListener = new ModelChangeAddRemoveListenerImplementation();
        viewModelContext.registerViewChangeListener((ModelChangeListener)this.viewModelChangeListener);
        this.dataModelListener = new ViewModelListener(viewModelContext, this);
    }

    @Override
    public Set<VControl> getControlsFor(EStructuralFeature.Setting setting) {
        LinkedHashSet<VControl> result = new LinkedHashSet<VControl>();
        Set<VElement> allElements = this.getControlsFor(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
        for (VElement element : allElements) {
            if (!VControl.class.isInstance(element)) continue;
            result.add((VControl)element);
        }
        return result;
    }

    @Override
    public Set<VElement> getControlsFor(UniqueSetting setting) {
        LinkedHashSet<VElement> elements = new LinkedHashSet<VElement>();
        List<VElement> currentControls = this.settingToControlMap.get(setting);
        LinkedHashSet<VControl> controls = new LinkedHashSet<VControl>();
        LinkedHashSet<VElement> validParents = new LinkedHashSet<VElement>();
        if (currentControls != null) {
            for (VElement control : currentControls) {
                if (!control.isEffectivelyEnabled() || !control.isEffectivelyVisible() || control.isEffectivelyReadonly()) continue;
                if (VControl.class.isInstance(control)) {
                    controls.add((VControl)control);
                    if (!this.controlContextMap.containsKey(control)) continue;
                    VElement parent = this.contextParentMap.get(this.controlContextMap.get(control));
                    validParents.add(parent);
                    continue;
                }
                elements.add(control);
            }
        }
        if (controls.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<VElement> result = new LinkedHashSet<VElement>(controls);
        elements.retainAll(validParents);
        result.addAll(elements);
        return result;
    }

    @Override
    public synchronized void updateControlMapping(VControl vControl) {
        if (vControl == null) {
            return;
        }
        this.deleteOldMapping(vControl);
        EMFFormsViewContext controlContext = this.controlContextMap.get(vControl);
        Set<UniqueSetting> map = this.mappingManager.getAllSettingsFor(vControl.getDomainModelReference(), controlContext == null ? this.viewModelContext.getDomainModel() : controlContext.getDomainModel());
        if (!this.controlToSettingMap.containsKey(vControl)) {
            this.controlToSettingMap.put((VElement)vControl, new ArrayList<UniqueSetting>(map));
        } else {
            this.controlToSettingMap.get(vControl).addAll(map);
        }
        block0: for (UniqueSetting setting : map) {
            if (!this.settingToControlMap.containsKey(setting)) {
                this.settingToControlMap.put(setting, new ArrayList(1));
                this.handleAddForEObjectMapping(setting);
            }
            this.settingToControlMap.get(setting).add((VElement)vControl);
            if (controlContext == null) continue;
            VElement parentElement = this.contextParentMap.get(controlContext);
            while (parentElement != null) {
                this.settingToControlMap.get(setting).add(parentElement);
                EMFFormsViewContext context = this.controlContextMap.get(parentElement);
                if (context == null) continue block0;
                parentElement = this.contextParentMap.get(context);
            }
        }
    }

    private void deleteOldMapping(VControl vControl) {
        if (this.controlToSettingMap.containsKey(vControl)) {
            LinkedHashSet<UniqueSetting> keysWithEmptySets = new LinkedHashSet<UniqueSetting>();
            for (UniqueSetting setting : this.controlToSettingMap.get(vControl)) {
                List<VElement> controlSet = this.settingToControlMap.get(setting);
                controlSet.remove(vControl);
                if (!controlSet.isEmpty()) continue;
                keysWithEmptySets.add(setting);
            }
            for (UniqueSetting setting : keysWithEmptySets) {
                this.settingToControlMap.remove(setting);
                this.handleRemoveForEObjectMapping(setting);
            }
            this.controlToSettingMap.remove(vControl);
        }
    }

    private void handleAddForEObjectMapping(UniqueSetting setting) {
        if (!this.eObjectToMappedSettings.containsKey(setting.getEObject())) {
            this.eObjectToMappedSettings.put(setting.getEObject(), new LinkedHashSet());
        }
        this.eObjectToMappedSettings.get(setting.getEObject()).add(setting);
    }

    private void handleRemoveForEObjectMapping(UniqueSetting setting) {
        Set<UniqueSetting> settings = this.eObjectToMappedSettings.get(setting.getEObject());
        settings.remove(setting);
        if (settings.isEmpty()) {
            this.eObjectToMappedSettings.remove(setting.getEObject());
        }
    }

    @Override
    public void vControlRemoved(VControl vControl) {
        this.deleteOldMapping(vControl);
        EMFFormsViewContext viewContext = this.controlContextMap.get(vControl);
        if (viewContext != null && this.contextListenerMap.containsKey(viewContext)) {
            this.contextListenerMap.get(viewContext).removeVControl(vControl);
        } else {
            this.dataModelListener.removeVControl(vControl);
        }
    }

    @Override
    public void vControlAdded(VControl vControl) {
        if (vControl.getDomainModelReference() == null) {
            return;
        }
        EMFFormsViewContext viewContext = this.controlContextMap.get(vControl);
        this.resolveDMR(vControl, viewContext);
        this.checkAndUpdateSettingToControlMapping((EObject)vControl);
        if (viewContext != null) {
            this.contextListenerMap.get(viewContext).addVControl(vControl);
        } else {
            this.dataModelListener.addVControl(vControl);
        }
    }

    private void resolveDMR(VControl vControl, EMFFormsViewContext childContext) {
        EMFFormsViewContext viewContext = childContext != null ? childContext : this.viewModelContext;
        SettingToControlExpandHelper.resolveDomainReferences((EObject)vControl.getDomainModelReference(), viewContext.getDomainModel(), viewContext);
    }

    @Override
    public void checkAndUpdateSettingToControlMapping(EObject eObject) {
        if (VControl.class.isInstance(eObject)) {
            VControl vControl = (VControl)eObject;
            if (vControl.getDomainModelReference() == null) {
                return;
            }
            this.updateControlMapping(vControl);
        }
    }

    @Override
    public void childContextAdded(VElement parentElement, EMFFormsViewContext childContext) {
        childContext.registerViewChangeListener((ModelChangeListener)this.viewModelChangeListener);
        this.contextParentMap.put(childContext, parentElement);
        this.contextListenerMap.put(childContext, new ViewModelListener(childContext, this));
        TreeIterator eAllContents = childContext.getViewModel().eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(next)) continue;
            this.controlContextMap.put((VControl)next, childContext);
            this.vControlAdded((VControl)next);
        }
        childContext.registerEMFFormsContextListener(this);
    }

    @Override
    public void childContextDisposed(EMFFormsViewContext childContext) {
        if (this.disposed) {
            return;
        }
        childContext.unregisterViewChangeListener((ModelChangeListener)this.viewModelChangeListener);
        ViewModelListener listener = this.contextListenerMap.remove(childContext);
        listener.dispose();
        TreeIterator eAllContents = childContext.getViewModel().eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(next)) continue;
            VControl controlToRemove = (VControl)next;
            this.vControlParentsRemoved(childContext, controlToRemove);
            this.vControlRemoved(controlToRemove);
            this.controlContextMap.remove(controlToRemove);
        }
        this.contextParentMap.remove(childContext);
        childContext.unregisterEMFFormsContextListener(this);
    }

    private void vControlParentsRemoved(EMFFormsViewContext childContext, VControl controlToRemove) {
        if (childContext == null) {
            return;
        }
        VElement parentElement = this.contextParentMap.get(childContext);
        if (parentElement == null) {
            return;
        }
        for (UniqueSetting setting : this.getSettingsForControl(controlToRemove)) {
            this.settingToControlMap.get(setting).remove(parentElement);
        }
        EMFFormsViewContext parentContext = this.controlContextMap.get(parentElement);
        this.vControlParentsRemoved(parentContext, controlToRemove);
    }

    @Override
    public void contextInitialised() {
    }

    @Override
    public void contextDispose() {
        this.viewModelContext.unregisterEMFFormsContextListener(this);
        this.dataModelListener.dispose();
        this.settingToControlMap.clear();
        this.controlContextMap.clear();
        this.contextParentMap.clear();
        this.contextListenerMap.clear();
        this.disposed = true;
    }

    @Override
    public boolean hasControlsFor(EObject eObject) {
        return this.eObjectToMappedSettings.containsKey(eObject);
    }

    @Override
    public Collection<EObject> getEObjectsWithSettings() {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        result.addAll(this.eObjectToMappedSettings.keySet());
        return result;
    }

    @Override
    public Set<UniqueSetting> getSettingsForControl(VControl control) {
        List<UniqueSetting> settings = this.controlToSettingMap.get(control);
        if (settings == null) {
            return Collections.emptySet();
        }
        return new SetView<UniqueSetting>(settings);
    }

    private final class ModelChangeAddRemoveListenerImplementation
    implements ModelChangeAddRemoveListener {
        private ModelChangeAddRemoveListenerImplementation() {
        }

        public void notifyChange(ModelChangeNotification notification) {
        }

        public void notifyAdd(Notifier notifier) {
            VDomainModelReference domainModelReference;
            VControl control;
            if (VDomainModelReference.class.isInstance(notifier) && !VDomainModelReference.class.isInstance(((EObject)EObject.class.cast(notifier)).eContainer()) && (control = this.findControl(domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(notifier))) != null) {
                SettingToControlMapperImpl.this.vControlAdded(control);
            }
        }

        private VControl findControl(VDomainModelReference dmr) {
            EObject parent = dmr.eContainer();
            while (!VControl.class.isInstance(parent) && parent != null) {
                parent = parent.eContainer();
            }
            return (VControl)parent;
        }

        public void notifyRemove(Notifier notifier) {
            if (VControl.class.isInstance(notifier)) {
                SettingToControlMapperImpl.this.vControlRemoved((VControl)notifier);
            }
        }
    }

    final class SetView<E>
    extends AbstractSet<E> {
        private final Collection<? extends E> content;

        SetView(Collection<? extends E> content) {
            this.content = content;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<? extends E> delegate = this.content.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public E next() {
                    return delegate.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.content.size();
        }
    }
}

