/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.genmodel.toolbaractions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emfforms.internal.editor.genmodel.Messages;
import org.eclipse.emfforms.internal.editor.genmodel.toolbaractions.GenerateJavaCodeAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GenerateEcoreEditorJavaCodeAction
extends GenerateJavaCodeAction {
    @Override
    public boolean canExecute(Object object) {
        if (!ResourceSet.class.isInstance(object)) {
            return false;
        }
        return this.getEPackage((ResourceSet)object) != null;
    }

    @Override
    public Action getAction(Object currentObject, ISelectionProvider selectionProvider) {
        ResourceSet resourceSet = (ResourceSet)currentObject;
        GenModel genModel = this.getGenModel(resourceSet);
        return new CreateEcoreJavaCodeAction(genModel, selectionProvider);
    }

    @Override
    protected GenModel getGenModel(ResourceSet resourceSet) {
        EPackage ePackage = this.getEPackage(resourceSet);
        if (ePackage == null) {
            return null;
        }
        URI resourceURI = ePackage.eResource().getURI();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(resourceURI.toFileString());
        IFile file = root.getFileForLocation((IPath)path);
        IContainer parent = file.getParent();
        return this.getGenModelFile(parent, resourceSet, ePackage);
    }

    private GenModel getGenModelFile(IContainer parent, ResourceSet resourceSet, EPackage ePackage) {
        for (IResource resource : this.getGenModelFiles(parent)) {
            Resource emfResource = resourceSet.getResource(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), true);
            if (emfResource.getContents().isEmpty() || !GenModel.class.isInstance(emfResource.getContents().get(0))) continue;
            GenModel genModel = (GenModel)emfResource.getContents().get(0);
            for (GenPackage genPackage : genModel.getGenPackages()) {
                if (ePackage.getNsURI() == null || genPackage.getEcorePackage() == null || !ePackage.getNsURI().equals(genPackage.getEcorePackage().getNsURI())) continue;
                return genModel;
            }
        }
        return null;
    }

    private List<IResource> getGenModelFiles(IContainer parent) {
        ArrayList<IResource> genModelFiles = new ArrayList<IResource>();
        parent.exists();
        try {
            IResource[] iResourceArray = parent.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getFileExtension().equals("genmodel")) {
                    genModelFiles.add(member);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return genModelFiles;
    }

    protected EPackage getEPackage(ResourceSet resourceSet) {
        if (resourceSet.getResources().isEmpty()) {
            return null;
        }
        Resource topResource = (Resource)resourceSet.getResources().get(0);
        if (!topResource.getContents().isEmpty() && EPackage.class.isInstance(topResource.getContents().get(0))) {
            return (EPackage)topResource.getContents().get(0);
        }
        return null;
    }

    class CreateEcoreJavaCodeAction
    extends GenerateJavaCodeAction.CreateJavaCodeAction {
        CreateEcoreJavaCodeAction(GenModel genModel, ISelectionProvider selectionProvider) {
            super(GenerateEcoreEditorJavaCodeAction.this, genModel, selectionProvider);
        }

        CreateEcoreJavaCodeAction(String text, Object[] types, GenModel genModel, ISelectionProvider selectionProvider) {
            super(GenerateEcoreEditorJavaCodeAction.this, text, types, genModel, selectionProvider);
        }

        @Override
        public void run() {
            if (this.getGenModel() == null) {
                this.showNoGenModelDialog();
                return;
            }
            super.run();
        }

        @Override
        protected Action getJavaCodeAction(String text, Object[] types) {
            return new CreateEcoreJavaCodeAction(text, types, this.getGenModel(), this.getSelectionProvider());
        }

        private void showNoGenModelDialog() {
            MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.GenerateEcoreEditorJavaCodeAction_noGenModelDialogTitle, (String)Messages.GenerateEcoreEditorJavaCodeAction_noGenModelDialogMessage);
        }
    }
}

