/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class MatchItemComboViewer
extends ComboViewer {
    private static final int TIMEOUT = 1000;
    private long lastKeyPressMillis = -1L;
    private final StringBuffer searchBuffer = new StringBuffer();

    public MatchItemComboViewer(CCombo combo) {
        super(combo);
        this.init();
    }

    public MatchItemComboViewer(Composite area, int style) {
        super(area, style);
        this.init();
    }

    public void onEnter(int selectedIndex) {
        this.setClosestMatch(this.getCCombo().getText());
    }

    protected void init() {
        this.getCCombo().addKeyListener((KeyListener)new MatchItemKeyAdapter());
        this.getCCombo().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                MatchItemComboViewer.this.resetBuffer();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    public int getClosestMatchIndex(String str) {
        String[] cItems = this.getCCombo().getItems();
        int i = 0;
        while (i < cItems.length) {
            if (cItems[i].toLowerCase().startsWith(str.toLowerCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void setClosestMatch(String s) {
        CCombo combo = this.getCCombo();
        String[] comboItems = combo.getItems();
        int index = this.getClosestMatchIndex(s);
        if (index != -1) {
            String item = comboItems[index];
            Point pt = combo.getSelection();
            combo.select(index);
            combo.setText(item);
            combo.setSelection(new Point(pt.x, item.length()));
        }
    }

    protected boolean keyPressTimedOut() {
        long timeElapsed = -1L;
        if (this.lastKeyPressMillis > 0L) {
            timeElapsed = System.currentTimeMillis() - this.lastKeyPressMillis;
        }
        return timeElapsed != -1L && timeElapsed > 1000L;
    }

    public void resetKeyPressedTimer() {
        this.lastKeyPressMillis = -1L;
    }

    protected void resetKeyPressedTimeout() {
        this.lastKeyPressMillis = System.currentTimeMillis();
    }

    public void addToBuffer(Character character) {
        this.searchBuffer.append(Character.toString(character.charValue()));
    }

    private void removeLastFromBuffer() {
        this.searchBuffer.deleteCharAt(this.searchBuffer.length() - 1);
    }

    public void resetBuffer() {
        this.searchBuffer.setLength(0);
    }

    public boolean isEmptyBuffer() {
        return this.searchBuffer.length() == 0;
    }

    private String bufferAsString() {
        return this.searchBuffer.toString();
    }

    class MatchItemKeyAdapter
    extends KeyAdapter {
        MatchItemKeyAdapter() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.keyCode == 13) {
                keyEvent.doit = true;
                int selectedIndex = MatchItemComboViewer.this.getClosestMatchIndex(MatchItemComboViewer.this.bufferAsString());
                MatchItemComboViewer.this.onEnter(selectedIndex);
                MatchItemComboViewer.this.resetBuffer();
                MatchItemComboViewer.this.resetKeyPressedTimer();
            } else if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                keyEvent.doit = true;
                MatchItemComboViewer.this.resetBuffer();
            } else {
                keyEvent.doit = false;
                if (!Character.isISOControl(keyEvent.character) || keyEvent.keyCode == 8) {
                    MatchItemComboViewer.this.setClosestMatch(MatchItemComboViewer.this.bufferAsString());
                } else if (keyEvent.keyCode != 131072) {
                    MatchItemComboViewer.this.resetBuffer();
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            keyEvent.doit = false;
            if (MatchItemComboViewer.this.keyPressTimedOut() && keyEvent.keyCode != 13) {
                MatchItemComboViewer.this.resetBuffer();
            }
            if (!Character.isISOControl(keyEvent.character)) {
                MatchItemComboViewer.this.addToBuffer(Character.valueOf(keyEvent.character));
                MatchItemComboViewer.this.resetKeyPressedTimeout();
            } else if (keyEvent.keyCode == 8 && !MatchItemComboViewer.this.isEmptyBuffer()) {
                MatchItemComboViewer.this.removeLastFromBuffer();
                MatchItemComboViewer.this.resetKeyPressedTimeout();
            } else if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001) {
                keyEvent.doit = true;
            }
        }
    }
}

