/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.controlmapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.internal.core.services.controlmapper.SettingToControlExpandHelper;
import org.eclipse.emfforms.internal.core.services.controlmapper.ViewModelListener;
import org.eclipse.emfforms.spi.core.services.controlmapper.EMFFormsSettingToControlMapper;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProviderManager;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public class SettingToControlMapperImpl
implements EMFFormsSettingToControlMapper,
EMFFormsContextListener {
    private final EMFFormsViewContext viewModelContext;
    private final ViewModelListener viewModelListener;
    private final Map<EObject, Set<UniqueSetting>> eObjectToMappedSettings = new LinkedHashMap<EObject, Set<UniqueSetting>>();
    private final Map<UniqueSetting, Set<VControl>> settingToControlMap = new LinkedHashMap<UniqueSetting, Set<VControl>>();
    private final EMFFormsMappingProviderManager mappingManager;
    private final Map<VElement, Set<EMFFormsSettingToControlMapper>> childMappers = new LinkedHashMap<VElement, Set<EMFFormsSettingToControlMapper>>();

    public SettingToControlMapperImpl(EMFFormsMappingProviderManager mappingManager, EMFFormsViewContext viewModelContext) {
        this.mappingManager = mappingManager;
        this.viewModelContext = viewModelContext;
        viewModelContext.registerEMFFormsContextListener(this);
        viewModelContext.registerViewChangeListener((ModelChangeListener)new ModelChangeAddRemoveListenerImplementation());
        this.viewModelListener = new ViewModelListener(viewModelContext, this);
    }

    @Override
    public Set<VControl> getControlsFor(EStructuralFeature.Setting setting) {
        return this.settingToControlMap.get(UniqueSetting.createSetting((EStructuralFeature.Setting)setting));
    }

    @Override
    public Set<VElement> getControlsFor(UniqueSetting setting) {
        LinkedHashSet<VElement> elements = new LinkedHashSet<VElement>();
        Set<VControl> currentControls = this.settingToControlMap.get(setting);
        if (currentControls != null) {
            for (VElement vElement : currentControls) {
                if (!vElement.isEnabled() || !vElement.isVisible() || vElement.isReadonly()) continue;
                elements.add(vElement);
            }
        }
        for (VElement vElement : this.childMappers.keySet()) {
            for (EMFFormsSettingToControlMapper childMapper : this.childMappers.get(vElement)) {
                Set<VElement> controlsFor = childMapper.getControlsFor(setting);
                elements.addAll(controlsFor);
                if (controlsFor.isEmpty()) continue;
                elements.add(vElement);
            }
        }
        return elements;
    }

    @Override
    public void updateControlMapping(VControl vControl) {
        if (vControl == null) {
            return;
        }
        LinkedHashSet<UniqueSetting> keysWithEmptySets = new LinkedHashSet<UniqueSetting>();
        for (UniqueSetting setting : this.settingToControlMap.keySet()) {
            Set<VControl> controlSet = this.settingToControlMap.get(setting);
            controlSet.remove(vControl);
            if (!controlSet.isEmpty()) continue;
            keysWithEmptySets.add(setting);
        }
        for (UniqueSetting setting : keysWithEmptySets) {
            this.settingToControlMap.remove(setting);
            this.handleRemoveForEObjectMapping(setting);
        }
        Set<UniqueSetting> map = this.mappingManager.getAllSettingsFor(vControl.getDomainModelReference(), this.viewModelContext.getDomainModel());
        for (UniqueSetting setting : map) {
            if (!this.settingToControlMap.containsKey(setting)) {
                this.settingToControlMap.put(setting, new LinkedHashSet());
                this.handleAddForEObjectMapping(setting);
            }
            this.settingToControlMap.get(setting).add(vControl);
        }
    }

    private void handleAddForEObjectMapping(UniqueSetting setting) {
        if (!this.eObjectToMappedSettings.containsKey(setting.getEObject())) {
            this.eObjectToMappedSettings.put(setting.getEObject(), new LinkedHashSet());
        }
        this.eObjectToMappedSettings.get(setting.getEObject()).add(setting);
    }

    private void handleRemoveForEObjectMapping(UniqueSetting setting) {
        Set<UniqueSetting> settings = this.eObjectToMappedSettings.get(setting.getEObject());
        settings.remove(setting);
        if (settings.isEmpty()) {
            this.eObjectToMappedSettings.remove(setting.getEObject());
        }
    }

    @Override
    public void vControlRemoved(VControl vControl) {
        if (vControl.getDomainModelReference() == null) {
            return;
        }
        Set<UniqueSetting> map = this.mappingManager.getAllSettingsFor(vControl.getDomainModelReference(), this.viewModelContext.getDomainModel());
        for (UniqueSetting setting : map) {
            if (!this.settingToControlMap.containsKey(setting)) continue;
            this.settingToControlMap.get(setting).remove(vControl);
            if (this.settingToControlMap.get(setting).size() != 0) continue;
            this.settingToControlMap.remove(setting);
            this.handleRemoveForEObjectMapping(setting);
        }
        this.viewModelListener.removeVControl(vControl);
    }

    @Override
    public void vControlAdded(VControl vControl) {
        if (vControl.getDomainModelReference() == null) {
            return;
        }
        this.checkAndUpdateSettingToControlMapping((EObject)vControl);
        this.viewModelListener.addVControl(vControl);
    }

    @Override
    public void checkAndUpdateSettingToControlMapping(EObject eObject) {
        if (VControl.class.isInstance(eObject)) {
            VControl vControl = (VControl)eObject;
            if (vControl.getDomainModelReference() == null) {
                return;
            }
            this.updateControlMapping(vControl);
        }
    }

    @Override
    public void childContextAdded(VElement parentElement, EMFFormsViewContext childContext) {
        EMFFormsSettingToControlMapper childSettingToControlMapper = childContext.getService(EMFFormsSettingToControlMapper.class);
        if (!this.childMappers.containsKey(parentElement)) {
            this.childMappers.put(parentElement, new LinkedHashSet());
        }
        this.childMappers.get(parentElement).add(childSettingToControlMapper);
    }

    @Override
    public void childContextDisposed(EMFFormsViewContext childContext) {
        EMFFormsSettingToControlMapper childSettingToControlMapper = childContext.getService(EMFFormsSettingToControlMapper.class);
        for (VElement vElement : this.childMappers.keySet()) {
            this.childMappers.get(vElement).remove(childSettingToControlMapper);
        }
    }

    @Override
    public void contextInitialised() {
    }

    @Override
    public void contextDispose() {
        this.viewModelContext.unregisterEMFFormsContextListener(this);
        this.viewModelListener.dispose();
        this.settingToControlMap.clear();
        this.childMappers.clear();
    }

    @Override
    public boolean hasControlsFor(EObject eObject) {
        if (this.eObjectToMappedSettings.containsKey(eObject)) {
            return true;
        }
        for (VElement parentElement : this.childMappers.keySet()) {
            for (EMFFormsSettingToControlMapper childMapper : this.childMappers.get(parentElement)) {
                if (!childMapper.hasControlsFor(eObject)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<EObject> getEObjectsWithSettings() {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        result.addAll(this.eObjectToMappedSettings.keySet());
        for (VElement parentElement : this.childMappers.keySet()) {
            for (EMFFormsSettingToControlMapper childMapper : this.childMappers.get(parentElement)) {
                result.addAll(childMapper.getEObjectsWithSettings());
            }
        }
        return result;
    }

    private final class ModelChangeAddRemoveListenerImplementation
    implements ModelChangeAddRemoveListener {
        private ModelChangeAddRemoveListenerImplementation() {
        }

        public void notifyChange(ModelChangeNotification notification) {
        }

        public void notifyAdd(Notifier notifier) {
            if (VDomainModelReference.class.isInstance(notifier) && !VDomainModelReference.class.isInstance(((EObject)EObject.class.cast(notifier)).eContainer())) {
                VDomainModelReference domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(notifier);
                SettingToControlExpandHelper.resolveDomainReferences((EObject)domainModelReference, SettingToControlMapperImpl.this.viewModelContext.getDomainModel(), SettingToControlMapperImpl.this.viewModelContext);
                VControl control = this.findControl(domainModelReference);
                if (control != null) {
                    SettingToControlMapperImpl.this.vControlAdded(control);
                }
            }
        }

        private VControl findControl(VDomainModelReference dmr) {
            EObject parent = dmr.eContainer();
            while (!VControl.class.isInstance(parent) && parent != null) {
                parent = parent.eContainer();
            }
            return (VControl)parent;
        }

        public void notifyRemove(Notifier notifier) {
            if (VControl.class.isInstance(notifier)) {
                SettingToControlMapperImpl.this.vControlRemoved((VControl)notifier);
            }
        }
    }
}

