/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.diagnostician;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.diagnostician.ECPValidator;

public class ClassifierValidatorWrapper
extends ECPValidator {
    private final Set<EClassifier> classifier = new LinkedHashSet<EClassifier>();
    private final Set<ECPValidator> validators;

    public ClassifierValidatorWrapper(EClassifier classifier, Set<ECPValidator> validators) {
        this.classifier.add(classifier);
        this.validators = validators;
    }

    @Override
    public Set<EClassifier> getValidatedEClassifier() {
        return this.classifier;
    }

    @Override
    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<ECPValidator> iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            boolean validationResult = iterator.next().validate(eClass, eObject, diagnostics, context);
            if (validationResult) continue;
            result = validationResult;
        }
        return result;
    }

    @Override
    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<ECPValidator> iterator = this.validators.iterator();
        while (iterator.hasNext()) {
            boolean validationResult = iterator.next().validate(eDataType, value, diagnostics, context);
            if (validationResult) continue;
            result = validationResult;
        }
        return result;
    }
}

