/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.context;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;

public interface ViewModelServiceProvider {
    public static final ViewModelServiceProvider NULL = new ViewModelServiceProvider(){

        @Override
        public Collection<? extends ViewModelService> getViewModelServices(VElement view, EObject eObject) {
            return Collections.emptySet();
        }
    };

    public Collection<? extends ViewModelService> getViewModelServices(VElement var1, EObject var2);

    public static final class Composed
    implements ViewModelServiceProvider {
        private final ViewModelServiceProvider first;
        private final ViewModelServiceProvider second;

        public Composed(ViewModelServiceProvider first, ViewModelServiceProvider second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public Collection<? extends ViewModelService> getViewModelServices(VElement view, EObject eObject) {
            LinkedHashMap result = new LinkedHashMap();
            this.provide(this.first, view, eObject, result);
            this.provide(this.second, view, eObject, result);
            return result.values();
        }

        private void provide(ViewModelServiceProvider provider, VElement view, EObject eObject, Map<Class<?>, ViewModelService> result) {
            for (ViewModelService viewModelService : provider.getViewModelServices(view, eObject)) {
                if (result.containsKey(viewModelService.getClass())) {
                    viewModelService.dispose();
                    continue;
                }
                result.put(viewModelService.getClass(), viewModelService);
            }
        }
    }
}

