/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;

public class ChildrenListImpl
extends BasicEList<Object>
implements InternalChildrenList {
    private static final long serialVersionUID = 1L;
    private final Object parent;

    public ChildrenListImpl(Object parent) {
        this.parent = parent;
    }

    @Override
    public final Object getParent() {
        return this.parent;
    }

    @Override
    public synchronized boolean hasChildren() {
        return !this.isEmpty();
    }

    @Override
    public synchronized Object[] getChildren() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public synchronized Object getChild(int index) {
        return this.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChildWithoutRefresh(Object child) {
        ChildrenListImpl childrenListImpl = this;
        synchronized (childrenListImpl) {
            this.add(child);
        }
    }

    @Override
    public final void addChild(Object child) {
        this.addChildWithoutRefresh(child);
        this.childrenAdded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> void addChildren(T ... children) {
        ChildrenListImpl childrenListImpl = this;
        synchronized (childrenListImpl) {
            int i = 0;
            while (i < children.length) {
                T child = children[i];
                this.add(child);
                ++i;
            }
        }
        this.childrenAdded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> void addChildren(Collection<T> children) {
        ChildrenListImpl childrenListImpl = this;
        synchronized (childrenListImpl) {
            this.addAll(children);
        }
        this.childrenAdded();
    }

    @Override
    public boolean isSlow() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public void setComplete() {
    }

    protected void childrenAdded() {
    }
}

