/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.group.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GroupType implements Enumerator
{
    NORMAL(0, "Normal", "Normal"),
    EMBEDDED(1, "Embedded", "Embedded"),
    COLLAPSIBLE(2, "Collapsible", "Collapsible");

    public static final int NORMAL_VALUE = 0;
    public static final int EMBEDDED_VALUE = 1;
    public static final int COLLAPSIBLE_VALUE = 2;
    private static final GroupType[] VALUES_ARRAY;
    public static final List<GroupType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GroupType[]{NORMAL, EMBEDDED, COLLAPSIBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GroupType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GroupType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GroupType get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return EMBEDDED;
            }
            case 2: {
                return COLLAPSIBLE;
            }
        }
        return null;
    }

    private GroupType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

