/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.controlmapper;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public final class SettingToControlExpandHelper {
    private SettingToControlExpandHelper() {
    }

    public static void resolveDomainReferences(EObject resolvable, EObject domainModelRoot, EMFFormsViewContext viewModelContext) {
        EMFFormsDomainExpander domainExpander = viewModelContext.getService(EMFFormsDomainExpander.class);
        if (domainExpander == null) {
            return;
        }
        SettingToControlExpandHelper.expandAndInitDMR(domainModelRoot, domainExpander, resolvable, viewModelContext);
        TreeIterator eAllContents = resolvable.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eObject = (EObject)eAllContents.next();
            SettingToControlExpandHelper.expandAndInitDMR(domainModelRoot, domainExpander, eObject, viewModelContext);
        }
    }

    private static void expandAndInitDMR(EObject domainModelRoot, EMFFormsDomainExpander domainExpander, EObject eObject, EMFFormsViewContext viewModelContext) {
        if (VDomainModelReference.class.isInstance(eObject) && !VDomainModelReference.class.isInstance(eObject.eContainer()) && !VDomainModelReferenceSegment.class.isInstance(eObject.eContainer())) {
            VDomainModelReference domainModelReference = (VDomainModelReference)VDomainModelReference.class.cast(eObject);
            domainModelReference.init(domainModelRoot);
            try {
                domainExpander.prepareDomainObject(domainModelReference, domainModelRoot);
            }
            catch (EMFFormsExpandingFailedException ex) {
                viewModelContext.getService(ReportService.class).report(new AbstractReport((Throwable)ex));
            }
        }
    }
}

