/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.spi.swt.reference;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.actions.ECPSWTAction;
import org.eclipse.emf.ecp.edit.spi.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class NewReferenceAction
extends ECPSWTAction {
    private final ReferenceService referenceService;

    public NewReferenceAction(EditingDomain editingDomain, EStructuralFeature.Setting setting, EMFFormsEditSupport editSupport, EMFFormsLabelProvider labelProvider, ReferenceService referenceService, ReportService reportService, VDomainModelReference domainModelReference, EObject domainModel) {
        super(editingDomain, setting);
        String attribute;
        this.referenceService = referenceService;
        EObject obj = null;
        EReference eReference = (EReference)this.getSetting().getEStructuralFeature();
        if (!eReference.getEReferenceType().isAbstract()) {
            obj = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create(eReference.getEReferenceType());
        }
        Object labelProviderImageResult = editSupport.getImage(domainModelReference, domainModel, obj);
        ImageData imageData = null;
        if (ComposedImage.class.isInstance(labelProviderImageResult)) {
            labelProviderImageResult = ((ComposedImage)labelProviderImageResult).getImages().get(0);
        }
        if (URI.class.isInstance(labelProviderImageResult)) {
            try {
                labelProviderImageResult = new URL(((URI)labelProviderImageResult).toString());
            }
            catch (MalformedURLException ex) {
                Activator.logException(ex);
            }
        }
        imageData = URL.class.isInstance(labelProviderImageResult) ? Activator.getImageData((URL)labelProviderImageResult) : Activator.getImageData(null);
        ImageDescriptor addOverlay = Activator.getImageDescriptor("icons/add_overlay.png");
        OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(imageData, addOverlay, 2);
        this.setImageDescriptor((ImageDescriptor)imageDescriptor);
        try {
            IObservableValue displayName = labelProvider.getDisplayName(domainModelReference, domainModel);
            attribute = (String)displayName.getValue();
            displayName.dispose();
        }
        catch (NoLabelFoundException ex) {
            reportService.report(new AbstractReport((Throwable)ex));
            this.setToolTipText(ex.getMessage());
            return;
        }
        if (attribute.endsWith("ies")) {
            attribute = String.valueOf(attribute.substring(0, attribute.length() - 3)) + "y";
        } else if (attribute.endsWith("s")) {
            attribute = attribute.substring(0, attribute.length() - 1);
        }
        this.setToolTipText(String.valueOf(LocalizationServiceHelper.getString(NewReferenceAction.class, (String)"NewReferenceAction_CreateAndLinkNew")) + attribute);
    }

    public NewReferenceAction(EditingDomain editingDomain, EObject eObject, EStructuralFeature structuralFeature, EMFFormsEditSupport editSupport, EMFFormsLabelProvider labelProvider, ReferenceService referenceService, ReportService reportService, VDomainModelReference domainModelReference, EObject domainModel) {
        this(editingDomain, ((InternalEObject)eObject).eSetting(structuralFeature), editSupport, labelProvider, referenceService, reportService, domainModelReference, domainModel);
    }

    public void run() {
        final EReference eReference = (EReference)this.getSetting().getEStructuralFeature();
        if (eReference.isContainment() && this.getSetting().getEObject().eIsSet((EStructuralFeature)eReference)) {
            MessageDialog dialog = this.getContainmentWarningDialog();
            new ECPDialogExecutor((Dialog)dialog){

                @Override
                public void handleResult(int codeResult) {
                    if (codeResult == 0) {
                        NewReferenceAction.this.addNewElementsToReferenceService(NewReferenceAction.this.getSetting().getEObject(), eReference);
                    }
                }
            }.execute();
        }
        this.addNewElementsToReferenceService(this.getSetting().getEObject(), eReference);
    }

    private void addNewElementsToReferenceService(EObject eObject, EReference eReference) {
        if (this.referenceService == null) {
            return;
        }
        this.referenceService.addNewModelElements(eObject, eReference, true);
    }

    private MessageDialog getContainmentWarningDialog() {
        return new MessageDialog(null, LocalizationServiceHelper.getString(NewReferenceAction.class, (String)"NewReferenceAction_Confirmation"), null, LocalizationServiceHelper.getString(NewReferenceAction.class, (String)"NewReferenceAction_Warning"), 4, new String[]{LocalizationServiceHelper.getString(NewReferenceAction.class, (String)"NewReferenceAction_Yes"), LocalizationServiceHelper.getString(NewReferenceAction.class, (String)"NewReferenceAction_No")}, 0);
    }
}

