/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.internal.swt.table.DefaultTableControlSWTCustomization;
import org.eclipse.emfforms.spi.swt.table.AbstractFeatureAwareBuilder;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.DNDProvider;
import org.eclipse.emfforms.spi.swt.table.TableConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableConfigurationBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerComposite;
import org.eclipse.emfforms.spi.swt.table.TableViewerCompositeBuilder;
import org.eclipse.emfforms.spi.swt.table.TableViewerCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.emfforms.spi.swt.table.action.ActionBar;
import org.eclipse.emfforms.spi.swt.table.action.ActionConfiguration;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;

public class TableViewerSWTBuilder
extends AbstractFeatureAwareBuilder<TableViewerSWTBuilder> {
    private boolean tableConfigured;
    private final Composite composite;
    private final int swtStyleBits;
    private final Object input;
    private final DefaultTableControlSWTCustomization customization;
    private final IObservableValue title;
    private final IObservableValue tooltip;
    private final Set<Feature> features = new LinkedHashSet<Feature>();

    protected TableViewerSWTBuilder(Composite composite, int swtStyleBits, Object input, IObservableValue title, IObservableValue tooltip) {
        this.composite = composite;
        this.swtStyleBits = swtStyleBits;
        this.input = input;
        this.title = title;
        this.tooltip = tooltip;
        this.customization = new DefaultTableControlSWTCustomization(){

            @Override
            public TableConfiguration getTableConfiguration() {
                if (!TableViewerSWTBuilder.this.tableConfigured) {
                    this.configureTable(TableConfigurationBuilder.withFeatures(TableViewerSWTBuilder.this.features).build());
                }
                return super.getTableConfiguration();
            }
        };
    }

    protected Composite getComposite() {
        return this.composite;
    }

    protected int getSwtStyleBits() {
        return this.swtStyleBits;
    }

    protected Object getInput() {
        return this.input;
    }

    public TableViewerSWTCustomization<?> getCustomization() {
        return this.customization;
    }

    protected IObservableValue getTitle() {
        return this.title;
    }

    protected IObservableValue getTooltip() {
        return this.tooltip;
    }

    public TableViewerSWTBuilder customizeCompositeStructure(TableViewerCompositeBuilder builder) {
        this.customization.setTableViewerCompositeBuilder(builder);
        return this;
    }

    public TableViewerSWTBuilder customizeTableViewerCreation(TableViewerCreator<? extends AbstractTableViewer> creator) {
        this.customization.setTableViewerCreator(creator);
        return this;
    }

    public TableViewerSWTBuilder customizeComparator(ViewerComparator comparator) {
        this.customization.setViewerComparator(comparator);
        return this;
    }

    public TableViewerSWTBuilder customizeContentProvider(IContentProvider provider) {
        this.customization.setContentProvider(provider);
        return this;
    }

    public TableViewerSWTBuilder customizeActionBar(ActionBar<? extends Viewer> actionBar) {
        this.customization.setActionBar(actionBar);
        return this;
    }

    public TableViewerSWTBuilder customizeActionConfiguration(ActionConfiguration actionConfiguration) {
        this.customization.setActionConfiguration(actionConfiguration);
        return this;
    }

    public TableViewerSWTBuilder customizeDragAndDrop(DNDProvider provider) {
        this.customization.setDND(provider);
        return this;
    }

    public TableViewerSWTBuilder configureTable(TableConfiguration tableConfiguration) {
        this.customization.configureTable(tableConfiguration);
        this.tableConfigured = true;
        return this;
    }

    public TableViewerSWTBuilder addColumn(ColumnConfiguration columnConfiguration) {
        this.customization.addColumn(columnConfiguration);
        return this;
    }

    @Override
    @Deprecated
    public Set<Feature> getSupportedFeatures() {
        return new LinkedHashSet<Feature>(TableConfiguration.ALL_FEATURES);
    }

    @Override
    @Deprecated
    public Set<Feature> getEnabledFeatures() {
        return this.features;
    }

    public TableViewerSWTBuilder showHideColumns(boolean showHideColumns) {
        return showHideColumns ? (TableViewerSWTBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW) : (TableViewerSWTBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_HIDE_SHOW);
    }

    public TableViewerSWTBuilder columnSubstringFilter(boolean columnSubstringFilter) {
        return columnSubstringFilter ? (TableViewerSWTBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_FILTER) : (TableViewerSWTBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_FILTER);
    }

    public TableViewerSWTBuilder columnRegexFilter(boolean columnRegexFilter) {
        return columnRegexFilter ? (TableViewerSWTBuilder)this.enableFeature(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER) : (TableViewerSWTBuilder)this.disableFeature(TableConfiguration.FEATURE_COLUMN_REGEX_FILTER);
    }

    public AbstractTableViewerComposite<? extends AbstractTableViewer> build() {
        TableViewerComposite viewerComposite = new TableViewerComposite(this.composite, this.swtStyleBits, this.input, (TableViewerSWTCustomization)this.customization, this.title, this.tooltip);
        viewerComposite.setData("emfforms.table.configuration", this.customization.getTableConfiguration());
        return viewerComposite;
    }
}

